/**
 * @file    log.c
 * @brief   簡易シリアルログ ライブラリ
 * @date    2021.12.02
 * @author  Copyright (c) 2021, eForce Co.,Ltd.  All rights reserved.
 ****************************************************************************
 */

#include "kernel.h"
#include "kernel_id.h"

#include <string.h> // strlen

#include "log.h"

// 文字列をシリアルログに出力
void log_str(const VB *str)
{
    T_MSGBLK *blk;

    UINT len = strlen(str);
    if (len > MPF_BLK_SIZE_LOG) {
        len = MPF_BLK_SIZE_LOG;
    }

    (void)get_mpf(ID_MPF_LOG, (VP *)&blk);


    memcpy(blk->buf, str, len);
    blk->cnt = len;
    (void)snd_mbx(ID_MBX_LOG, (T_MSG *)blk);
}

// idm/pmmをシリアルログに出力
void log_idm_pmm(const UB data[8])
{
    static VB dec2hex[16] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

    T_MSGBLK *blk;

    int i;
    int pos;

    (void)get_mpf(ID_MPF_LOG, (VP *)&blk);

    pos = 0;
    for (i = 0; i < 8; i++) {
        blk->buf[pos++] = dec2hex[data[i]/16];
        blk->buf[pos++] = dec2hex[data[i]%16];
        blk->buf[pos++] = ' '; // separator
    }
    blk->buf[pos++] = '\r';
    blk->buf[pos++] = '\n';

    blk->cnt = pos;
    (void)snd_mbx(ID_MBX_LOG, (T_MSG *)blk);
}

