/*
 * RC-S620/S sample library for uC3
 */

#ifndef RCS620S_H_
#define RCS620S_H_

#include <inttypes.h>

// Constant
#define RCS620S_MAX_CARD_RESPONSE_LEN    254
#define RCS620S_MAX_RW_RESPONSE_LEN      265

// External variable
extern uint8_t idm_[8];
extern uint8_t pmm_[8];

// External function
extern int RCS620S_initDevice(ID comid);
extern int RCS620S_polling(uint16_t systemCode);
extern int RCS620S_cardCommand(const uint8_t *command, uint8_t commandLen, uint8_t response[RCS620S_MAX_CARD_RESPONSE_LEN], uint8_t *responseLen);
extern int RCS620S_rfOff(void);
extern int RCS620S_push(const uint8_t *data, uint8_t dataLen);

#endif /* !RCS620S_H_ */
