/**
 * @file    DDR_M_SysTick.c
 * @brief   MICRO C CUBE / COMPACT, DEVICE DRIVER
 *          Interval Timer Driver for Cortex-M
 * @date    2016.12.04
 * @author  Copyright (c) 2011-2016, eForce Co., Ltd. All rights reserved.
 *
 ****************************************************************************
 * @par     History
 *          - rev 1.0 (2011.09.02)
 *            Created.
 *          - rev 1.1 (2012.11.30)
 *            Removed comment in japanese.
 *          - rev 1.2 (2016.12.04) y-kim
 *            Fixed the IPA warnings.
 ****************************************************************************
 */
#include "kernel.h"
#include "DDR_M_SysTick.h"
#include "DDR_M_SysTick_cfg.h"

/*******************************
    Systick ISR
 *******************************/

void _ddr_m_systick(VP_INT exinf)
{
    if ((REG_SYSTICK.CTRSTS & 0x00010000UL) != 0UL) {
        (void)isig_tim();
    }
}

/*******************************
    Initialize
 *******************************/

void _ddr_m_systick_init(void)
{
    REG_SYSTICK.CTRSTS = 0x00000000UL;
    REG_SYSTICK.CURRENT = 0UL;
    REG_SNVIC.SYSPRI[2] = (REG_SNVIC.SYSPRI[2] & 0x00FFFFFFUL) | ((UW)TICKPRI << 24);
    REG_SYSTICK.RELOAD = (UW)RELOADV - 1UL;
    REG_SYSTICK.CTRSTS = 0x00000007UL;
}
