/**
 * @file    DDR_STM32L4_USART0.h
 * @brief   Serial Interface STMicroelectronics STM32L4xx USART
 * @date    2020.08.24
 * @author  Copyright (c) 2015-2020, eForce Co.,Ltd.  All rights reserved.
 *
 * @par     History
 *          - rev 1.0 (2015.02.05) i-cho
 *            Initial version.
 *          - rev 1.1 (2020.08.24) sugawara
 *            Add FIFO mode for STM32L4+ series.
 */

#ifndef _DDR_STM32L4_USART0_H_
#define _DDR_STM32L4_USART0_H_

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct t_stm32l4_usart0_cmng {
    VB              *tbuf;
    VB              *rbuf;
    UB              *sbuf;
    UH              tsize;
    UH              rsize;
    UH              xoff_size;
    UH              xon_size;
    UH              tsemid;
    UH              rsemid;
    UW              pclk;       /* Peripheral clock                         */
    volatile UW     *enr;       /* APBx Peripheral clock enable register    */
    volatile UW     *rstr;      /* APBx Peripheral reset register           */
    UW              apbbit;     /* USARTx bit on Peripheral clock enable register */
    volatile UW     *ctsport;
    UW              ctsbit;
    UB              fifo_en;
    UB              fifo_txft;
    UB              fifo_rxft;
} T_STM32L4_USART0_CMNG;

typedef union t_stm32l4_usart0_msts {
    UINT        word;
    struct {
        UINT        init_flg:1;
        UINT        ena_tx:1;
        UINT        ena_rx:1;
        UINT        sft_flw:1;
        UINT        hrd_flw:1;
        UINT        sns_brk:1;
        UINT        tx_xoff:1;
        UINT        rx_xoff:1;
        UINT        req_xon_xoff:1;
        UINT        er_buf_ovr:1;
        UINT        cln_wait:1;
        UINT        dummy:5;
    } bit;
} T_STM32L4_USART0_MSTS;

typedef struct t_stm32l4_usart0_dmng {
    T_COM_SND                   *SndData;
    T_COM_RCV                   *RcvData;
    T_STM32L4_USART0_MSTS       status;
    UH                          sndp;
    UH                          rcvp;
    UH                          tcnt;
    UH                          rcnt;
    UH                          tlockid;
    UH                          rlockid;
    UW                          mask;
} T_STM32L4_USART0_DMNG;

typedef struct t_stm32l4_usart0_mng {
    volatile struct t_usart     *port;
    T_STM32L4_USART0_CMNG const *cdata;
    T_STM32L4_USART0_DMNG       *data;
} T_STM32L4_USART0_MNG;

#ifdef __cplusplus
}
#endif

#endif /* _DDR_STM32L4_USART0_H_ */
