require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Interval Timer Configuration\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _DDR_RZT1_CMT0_CFG_H_\n")
    fprintf(fout, "#define _DDR_RZT1_CMT0_CFG_H_\n")
    
    ch = MCFGGetParamInteger("CFG_TIM_CH", 0)
    ipl = MCFGGetParamInteger("CFG_TIM_IPL", 0)
    clksrc = MCFGGetParamInteger("CFG_TIM_CLKSRC", 0)
    
    fprintf(fout, "\n")
    fprintf(fout, "/* Channel of CMT (0 ~ 3) */\n")
    fprintf(fout, "#define CH_TIM      %d\n", ch)

    fprintf(fout, "\n")
    fprintf(fout, "/* Interrupt priority (0 ~ 15) */\n")
    fprintf(fout, "#define IPL_TIMER   %d\n", ipl)

    fprintf(fout, "\n")
    fprintf(fout, "/**\n")
    fprintf(fout, " * Select CMT clock source (0 ~ 3) \n")
    fprintf(fout, " * 0 : PCLKD/8\n")
    fprintf(fout, " * 1 : PCLKD/32\n")
    fprintf(fout, " * 2 : PCLKD/128\n")
    fprintf(fout, " * 3 : PCLKD/512\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define CLK_SRC     %d\n", clksrc)

    fprintf(fout, "\n")
    fprintf(fout, "#endif /* _DDR_RZT1_CMT0_CFG_H_ */\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
