require("uC3")

-- uC3 module alias
fprintf = uC3.fprintf

function main()

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Clock Pulse Generator configurations\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _DDR_RZT1_CPG_CFG_H_\n")
    fprintf(fout, "#define _DDR_RZT1_CPG_CFG_H_\n")
    fprintf(fout, "\n")

    mainclk = MCFGGetParamInteger("CFG_CLK_MAINCLK", 0)
    audioclk = MCFGGetParamInteger("CFG_CLK_AUDIOCLK", 0)

    fprintf(fout, "/* Clock source (Hz) */\n")
    fprintf(fout, "#define MAIN_CLK        (%du) /* CNbNU */\n", mainclk)
    fprintf(fout, "#define AUDIO_CLK       (%du) /* SSIpONbN */\n", audioclk)

    fprintf(fout, "\n")
    fprintf(fout, "#endif /* _DDR_RZT1_CPG_CFG_H_ */\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* end */\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end

