require("uC3")

-- uC3 module alias
fprintf = uC3.fprintf

-- Setting for Ethernet0
function main()
    local nEtherCnt = MCFGGetParamInteger("CFG_PERIPH_ETHER", 0)
    local nIndex = -1

    -- CPUvOĈǂEthernetΏۂT
    for cnt = 0, nEtherCnt-1 do
        if MCFGGetParamInteger("CFG_PERIPH_ETHER_USE", cnt) ~= 0 then
            nIndex = cnt
            break
        end
    end

    -- CPUvOCEthernetugpvɃ`FbNĂȂꍇ
    if nIndex == -1 then
        return
    end

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Ethernet driver configuration for RZ/T1H\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __DDR_RZT1_ETH_CFG_H__\n")
    fprintf(fout, "#define __DDR_RZT1_ETH_CFG_H__\n")
    fprintf(fout, "\n")

    fprintf(fout, "\n")
    fprintf(fout, "#ifdef __cplusplus\n")
    fprintf(fout, "extern \"C\" {\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "\n")

    fprintf(fout, "/*\n")
--    fprintf(fout, " *  ETH_CFG_HAVE_RIN    : Configure whether controller have R-IN Engine\n")
--    fprintf(fout, " *                        = 0 : controller dose not have R-IN Engine\n")
--    fprintf(fout, " *                        = 1 : controller have R-IN Engine\n")
    fprintf(fout, " */\n")
--     fprintf(fout, "#define ETH_CFG_HAVE_RIN (%d)\n", MCFGGetParamInteger("CFG_ETHER_R_IN", nIndex))
    fprintf(fout, "#define ETH_CFG_HAVE_RIN (1)\n")
--    fprintf(fout, "#if ETH_CFG_HAVE_RIN == 0\n")
--    fprintf(fout, "#error This version is not support controller without R-IN Engine!\n")
--    fprintf(fout, "#endif\n")

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " *  ETH_CFG_PHY_ADDR : Configure Ethernet phy address\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define ETH_CFG_PHY_ADDR    0x%02X\n", MCFGGetParamInteger("CFG_ETHER_PHYID", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " *  ETH_CFG_PHY_IF : Configure PHY interface\n")
    fprintf(fout, " *                    = ETH_CFG_PHY_IF_MII  : MII\n")
    fprintf(fout, " *                    = ETH_CFG_PHY_IF_RMII : RMII\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define ETH_CFG_PHY_IF_MII  (0) /* MII */\n")
    fprintf(fout, "#define ETH_CFG_PHY_IF_RMII (1) /* RMII */\n")
    fprintf(fout, "#define ETH_CFG_PHY_IF (%d)\n", MCFGGetParamInteger("CFG_ETHER_PHYINTERFACE", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " *  IPL_ETHERNET    : Configure Interrupt priority level\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define IPL_ETHERNET    (%d)\n" , MCFGGetParamInteger("CFG_ETHER_INTLVL", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, "    Configure PHY Mode\n")
    fprintf(fout, "--------------------------------\n")
    fprintf(fout, "    (Default)   0 = Auto select mode\n")
    fprintf(fout, "                1 = 10M Half Duplex manual mode\n")
    fprintf(fout, "                2 = 10M Full/Half (Duplex auto select mode)\n")
    fprintf(fout, "                3 = 100M Half Duplex manual mode\n")
    fprintf(fout, "                4 = 100M Full/Half (Duplex auto select mode)\n")
    fprintf(fout, "*/\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE_AUTO      (0) /* Auto */\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE_10M_HALF  (1) /* 10M Half Duplex manual mode              */\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE_10M       (2) /* 10M Full/Half (Duplex auto select mode)  */\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE_100M_HALF (3) /* 100M Half Duplex manual mode             */\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE_100M      (4) /* 100M Full/Half (Duplex auto select mode) */\n")
    fprintf(fout, "#define ETH_CFG_PHY_MODE    (%d)\n", MCFGGetParamInteger("CFG_ETHER_PHYMODE", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, "    Configure Address Filter Mode\n")
    fprintf(fout, "--------------------------------\n")
    fprintf(fout, "    (Default)   0 = Filter disable (Perfect filtering)\n")
    fprintf(fout, "                1 = promiscuous mode (receive all packets)\n")
    fprintf(fout, "                2 = multicast filter mode\n")
    fprintf(fout, "*/\n")
    fprintf(fout, "#define ETH_CFG_FILTER_MODE    (%d)\n", MCFGGetParamInteger("CFG_ETHER_FILTERMODE", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " *  ETH_CFG_TSK_PRI : Configure task priority.\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define ETH_CFG_TSK_PRI    (%d)\n", MCFGGetParamInteger("CFG_ETHER_TASKPRI", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " *  ETH_CFG_TSK_PRI_PHY : Configure task priority while execute\n")
    fprintf(fout, " *                        phy access function.\n")
    fprintf(fout, " *                        Phy access function change task priority defined this\n")
    fprintf(fout, " *                        configuration value temporaly.\n")
    fprintf(fout, " *                        Must be configure low priority because phy access \n")
    fprintf(fout, " *                        function use polling for wait operation completion.\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#define ETH_CFG_TSK_PRI_PHY    (%d)\n", MCFGGetParamInteger("CFG_ETHER_PHYTASKPRI", nIndex))

    fprintf(fout, "\n")
    fprintf(fout, "/*\n")
    fprintf(fout, " * ETH_MACSEL : Configure Ethernet interface function\n")
    fprintf(fout, " *              See detail \"MACSEL\" Register\n")
    fprintf(fout, " */\n")
    fprintf(fout, "#if ETH_CFG_HAVE_RIN == 1\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETSW           (0UL)\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETCAT          (1UL)\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETMAC          (3UL)\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETCAT_AND_ETSW (5UL)\n")
    fprintf(fout, "#elif ETH_CFG_HAVE_RIN == 0\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETSW           (0UL)\n")
    fprintf(fout, "#define ETH_CFG_MACSEL_ETMAC          (3UL)\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "#define ETH_CFG_MACSEL    (%d)\n", MCFGGetParamInteger("CFG_ETHER_MACSELECT", nIndex))


    fprintf(fout, "\n")
    fprintf(fout, "#ifdef __cplusplus\n")
    fprintf(fout, "}\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "#endif   /* __DDR_RZT1_ETH_CFG_H__ */ \n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
