require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Serial Driver Configuration\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _DDR_RZT1_SCIF_CFG_H_\n")
    fprintf(fout, "#define _DDR_RZT1_SCIF_CFG_H_\n")
    fprintf(fout, "\n")
    
    fprintf(fout, "/* SCIFA settings */\n")
    fprintf(fout, "\n")
    uart_cnt = MCFGGetParamInteger("CFG_PERIPH_UART", 0)
    for i = 0, (uart_cnt-1) do
        if MCFGGetParamInteger("CFG_PERIPH_UART_USE", i) == 1 then
            fprintf(fout, "#define SCIF_%d\n", i)
            fprintf(fout, "#define TXBUF_SZ%d   %d\n" , i, MCFGGetParamInteger("CFG_UART_TXBUFSZ",  i))
            fprintf(fout, "#define RXBUF_SZ%d   %d\n" , i, MCFGGetParamInteger("CFG_UART_RXBUFSZ",  i))
            fprintf(fout, "#define XOFF_SZ%d    %d\n" , i, MCFGGetParamInteger("CFG_UART_XOFF",     i))
            fprintf(fout, "#define XON_SZ%d     %d\n" , i, MCFGGetParamInteger("CFG_UART_XON",      i))
            fprintf(fout, "#define RTRG_%d      %d\n" , i, MCFGGetParamInteger("CFG_UART_RTRG",     i))
            fprintf(fout, "#define TTRG_%d      %d\n" , i, MCFGGetParamInteger("CFG_UART_TTRG",     i))
            fprintf(fout, "#define RSTRG_%d     %d\n" , i, MCFGGetParamInteger("CFG_UART_RSTRG",    i))
            fprintf(fout, "#define IPL_SCIF%d   %d\n" , i, MCFGGetParamInteger("CFG_UART_IPL",      i))
            fprintf(fout, "\n")
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "#endif /* _DDR_RZT1_SCIF_CFG_H_ */\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* end */\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
