--[[
#===============================================================================
#
#       FILE:  main.c.lua
#
#       COMPANY: Copyright(c) 2013-2014, eForce Co.,Ltd. All rights reserved.
#       HISTORY:
#           VERSION: 1.0
#           CREATED: 2013-09-23
#           
#           VERSION: 2.0
#           2014-06-10 Supported GCC.
#
#           VERSION: 2.1
#           2014-08-07 VXȅkernel_cfg.cɈړ
#           
#===============================================================================
--]]
require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

--[[
 Support function
--]]
function is_uniq_isr(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_ISR", i) then
                return false
            end
        end
    end
    return true
end

function is_uniq_inh(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_INTHDR", i) then
                return false
            end
        end
    end
    return true
end

function is_uniq_cyc(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_CYCHDR", i) then
                return false
            end
        end
    end
    return true
end

function is_uniq_alm(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_ALMHDR", i) then
                return false
            end
        end
    end
    return true
end

function is_uniq_dev(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_DEVHDR", i) then
                return false
            end
        end
    end
    return true
end

function is_uniq_task(func, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if func == MCFGGetParamString("CFG_TASK", i) then
                return false
            end
        end
    end
    return true
end

--[[
    main function
--]]
function main()
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local kernel = MCFGGetKernelStdCfg()

    local all_tsk_count = MCFGGetParamInteger("CFG_TSK_COUNT", 0)
    local usr_tsk_count = uC3Std.task_count_usr()

    local all_cyc_cnt = MCFGGetParamInteger("CFG_CYC_COUNT", 0)
    local usr_cyc_cnt = uC3Std.cyc_count_usr()

    local all_alm_cnt = MCFGGetParamInteger("CFG_ALM_COUNT", 0)
    local usr_alm_cnt = uC3Std.alm_count_usr()

    local all_inh_cnt = MCFGGetParamInteger("CFG_INH_COUNT", 0)
    local usr_inh_cnt = uC3Std.inh_count_usr()

    local all_isr_cnt = MCFGGetParamInteger("CFG_ISR_COUNT", 0)
    local usr_isr_cnt = uC3Std.isr_count_usr()

    local all_dev_cnt = MCFGGetParamInteger("CFG_DEV_COUNT", 0)
    local usr_dev_cnt = uC3Std.dev_count_usr()

    local all_exc_cnt = MCFGGetParamInteger("CFG_EXC_COUNT", 0)
    local usr_exc_cnt = uC3Std.exc_count_usr()

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "  Sample program\n")
    fprintf(fout, "\n")
    fprintf(fout, "   Generated at %s\n", nowtim)
    fprintf(fout, "\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* {{UC3_INCLUDE */\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"kernel_id.h\"\n")
    fprintf(fout, "#include \"kernel_cfg.h\"\n")
    fprintf(fout, "#include \"hw_dep.h\"\n")
    fprintf(fout, "/* }}UC3_INCLUDE */\n")
    -- ǉwb_[
    if kernel:addheader() ~= "" and kernel:addheader() ~= nil then
        fprintf(fout, "#include \"%s\"\n", kernel:addheader())
    end
    fprintf(fout, "#ifdef __IAR_SYSTEMS_ICC__\n")
    fprintf(fout, "#include <intrinsics.h>\n")
    fprintf(fout, "#endif\n")

    fprintf(fout, "\n")
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "    No Heap\n")
    fprintf(fout, " ******************************************************************/\n")
    fprintf(fout, "#ifdef __CC_ARM\n")
    fprintf(fout, "#pragma import(__use_no_heap)\n")
    fprintf(fout, "#endif\n")

    -- uC3 start
    fprintf(fout, "\n")
    fprintf(fout, "/* {{UC3_CODE */\n")
    fprintf(fout, "\n")
   
    fprintf(fout, "\n")
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "    Default interrupt handler\n")
    fprintf(fout, "     Reached when the interrupt is accepted even though it is not the generation of an\n")
    fprintf(fout, "     interrupt service routine also define the interrupt handler.\n")
    fprintf(fout, " ******************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "void int_abort(void)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    for(;;);\n")
    fprintf(fout, "}\n")
    
    -- ACh֐
    if kernel:sysidl() ~= nil and kernel:sysidl() ~= "" then
        fprintf(fout, "\n")
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "    Idle Function\n")
        fprintf(fout, "*******************************/\n")
        fprintf(fout, "void %s(void)\n{\n}\n\n", kernel:sysidl())
    end
    if MCFGGetParamInteger("CFG_LOWPOWER_SLEEP", 0) == 1 then
        fprintf(fout, "\n")
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "  Lowpower idle function\n")
        fprintf(fout, "*******************************/\n")
        fprintf(fout, "void lowpower_idle(void)\n")
        fprintf(fout, "{\n")
        if kernel:sysidl() ~= nil and kernel:sysidl() ~= "" then
            fprintf(fout, "    %s();\n", kernel:sysidl())
        end
        fprintf(fout, "#if defined(__CC_ARM)\n")
        fprintf(fout, "    __wfi();\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "#if defined(__IAR_SYSTEMS_ICC__)\n")
        fprintf(fout, "    __WFI();\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "#if defined (__GNUC__)\n")
        fprintf(fout, "    __asm volatile (\"wfi\");\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n\n")
    end

    -- X^bN
    if kernel:inistk() ~= nil and kernel:inistk() ~= "" and uC3Std.is_user_init(kernel:inistk()) == true then
        fprintf(fout, "\n")
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "    Stack init Function\n")
        fprintf(fout, "*******************************/\n")
        fprintf(fout, "void %s(INT* stk, SIZE size, ID id)\n{\n}\n\n", kernel:inistk())
    end

    -- CPU Exception Handler
    if usr_exc_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_exc_cnt-1 do
            exc = MCFGGetKernelStdExc(i)
            if exc:externaluse() == false and exc:exchdr() ~= nil and exc:exchdr() ~= "" then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", exc:exchdr())
                fprintf(fout, "/* {{UC3_EXC(%s) */\n", exc:exchdr())
                if exc:excno() == 2 then -- EXC_SVC
                    fprintf(fout, "void %s(UW svcno, UW *reg)\n{\n}\n", exc:exchdr())
                else
                    fprintf(fout, "void %s(UW *reg, UW psr)\n{\n}\n", exc:exchdr())
                end
                fprintf(fout, "/* }}UC3_EXC */\n\n")
            end
        end
    end

    -- Overrun Handlers
    if kernel:enable_ovr() == true then
        fprintf(fout, "\n")
        ovr = MCFGGetKernelStdOverrunHandler(0)
        if ovr:externaluse() == false then
            fprintf(fout, "/*******************************\n        %s\n *******************************/\n", ovr:ovrhdr())
            fprintf(fout, "/* {{UC3_OVR(%s) */\n", ovr:ovrhdr())
            fprintf(fout, "void %s(ID tskid, VP_INT exinf)\n{\n}\n", ovr:ovrhdr())
            fprintf(fout, "/* }}UC3_OVR */\n\n")
        end
    end

    -- 荞݃nh
    if usr_inh_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_inh_cnt-1 do
            inh = MCFGGetKernelStdInh(i)
            if inh:externaluse() == false and is_uniq_inh(inh:inthdr(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", inh:inthdr())
                fprintf(fout, "/* {{UC3_INH(%s) */\n", inh:inthdr())
                fprintf(fout, "void %s(void)\n{\n}\n", inh:inthdr())
                fprintf(fout, "/* }}UC3_INH */\n\n")
            end
        end
    end

    -- Interrupt Service Routine
    if usr_isr_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_isr_cnt-1 do
            isr = MCFGGetKernelStdIsr(i)
            if isr:externaluse() == false and is_uniq_isr(isr:isr(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", isr:isr())
                fprintf(fout, "/* {{UC3_ISR(%s) */\n", isr:isr())
                fprintf(fout, "void %s(VP_INT exinf)\n{\n}\n", isr:isr())
                fprintf(fout, "/* }}UC3_ISR */\n\n")
            end
        end
    end

    -- Cyclic Handlers
    if usr_cyc_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_cyc_cnt-1 do
            cyc = MCFGGetKernelStdCyclicHandler(i)
            if cyc:externaluse() == false and is_uniq_cyc(cyc:cychdr(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", cyc:cychdr())
                fprintf(fout, "/* {{UC3_CYC(%s) */\n", cyc:cychdr())
                fprintf(fout, "void %s(VP_INT exinf)\n{\n}\n", cyc:cychdr())
                fprintf(fout, "/* }}UC3_CYC */\n\n")
            end
        end
    end

    -- Alarm Handlers
    if usr_alm_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_alm_cnt-1 do
            alm = MCFGGetKernelStdAlarmHandler(i)
            if alm:externaluse() == false and is_uniq_alm(alm:almhdr(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", alm:almhdr())
                fprintf(fout, "/* {{UC3_ALM(%s) */\n", alm:almhdr())
                fprintf(fout, "void %s(VP_INT exinf)\n{\n}\n", alm:almhdr())
                fprintf(fout, "/* }}UC3_ALM */\n\n")
            end
        end
    end

    -- Device
    if usr_dev_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_dev_cnt-1 do
            dev = MCFGGetKernelStdDev(i)
            if dev:externaluse() == false and is_uniq_dev(dev:devhdr(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", dev:devhdr())
                fprintf(fout, "/* {{UC3_DEV(%s) */\n", dev:devhdr())
                fprintf(fout, "void %s(ID funcid, VP ctrdev, VP ctrblk)\n{\n}\n", dev:devhdr())
                fprintf(fout, "/* }}UC3_DEV */\n\n")
            end
        end
    end

    -- Task
    if usr_tsk_count > 0 then
        for i = 0, (all_tsk_count-1) do
            local tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false and is_uniq_task(tsk:task(), i) == true then
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tsk:task())
                fprintf(fout, "/* {{UC3_TASK(%s) */\n", tsk:task())
                fprintf(fout, "void %s(VP_INT exinf)\n{\n}\n", tsk:task())
                fprintf(fout, "/* }}UC3_TASK */\n\n")
            end
        end
    end

    -- uC3 end
    fprintf(fout, "\n")
    fprintf(fout, "/* }}UC3_CODE */\n")
    fprintf(fout, "\n")

    fprintf(fout, "\n/*******************************\n")
    fprintf(fout, "        Main entry\n")
    fprintf(fout, " *******************************/\n")
    fprintf(fout, "\n")
    -- 荞݃Rg[
    local intc = MCFGGetParamString("CFG_INTC_INIT", 0)
    fprintf(fout, "extern void hw_init(void);\n")
    fprintf(fout, "extern void init_csys(T_CSYS* );\n")
    fprintf(fout, "extern void initpr(void);\n")
    -- 
    --fprintf(fout, "\n")
    --fprintf(fout, "extern long long SYSMEM[CFG_SYSMEM_SIZE/sizeof(long long)];\n")
    --if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "extern long long STKMEM[CFG_STKMEM_SIZE/sizeof(long long)];\n")
    --end
    --if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "extern long long MPLMEM[CFG_MPLMEM_SIZE/sizeof(long long)];\n")
    --end
    fprintf(fout, "\n")
    fprintf(fout, "int main(void)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    T_CSYS csys;\n")
    fprintf(fout, "\n")
    --fprintf(fout, "    /* Dummy access */\n")
    --fprintf(fout, "    SYSMEM[0] = 0;\n")
    --if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "    STKMEM[0] = 0;\n")
    --end
    --if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "    MPLMEM[0] = 0;\n")
    --end
    fprintf(fout, "\n")
    fprintf(fout, "    /* Initialize H/W */\n")
    fprintf(fout, "    hw_init();\n")
    fprintf(fout, "    %s();\n", intc)
    fprintf(fout, "\n")
    fprintf(fout, "    /* Generate system */\n")
    fprintf(fout, "    init_csys(&csys);\n")
    --fprintf(fout, "    csys.tskpri_max = CFG_TSKPRI_MAX;\n")
    --fprintf(fout, "    csys.tskid_max = CFG_TSKID_MAX;\n")
    --fprintf(fout, "    csys.semid_max = CFG_SEMID_MAX;\n")
    --fprintf(fout, "    csys.flgid_max = CFG_FLGID_MAX;\n")
    --fprintf(fout, "    csys.dtqid_max = CFG_DTQID_MAX;\n")
    --fprintf(fout, "    csys.mbxid_max = CFG_MBXID_MAX;\n")
    --fprintf(fout, "    csys.mtxid_max = CFG_MTXID_MAX;\n")
    --fprintf(fout, "    csys.mbfid_max = CFG_MBFID_MAX;\n")
    --fprintf(fout, "    csys.porid_max = CFG_PORID_MAX;\n")
    --fprintf(fout, "    csys.mpfid_max = CFG_MPFID_MAX;\n")
    --fprintf(fout, "    csys.mplid_max = CFG_MPLID_MAX;\n")
    --fprintf(fout, "    csys.almid_max = CFG_ALMID_MAX;\n")
    --fprintf(fout, "    csys.cycid_max = CFG_CYCID_MAX;\n")
    --fprintf(fout, "    csys.isrid_max = CFG_ISRID_MAX;\n")
    --fprintf(fout, "    csys.devid_max = CFG_DEVID_MAX;\n")
    --fprintf(fout, "    csys.tick = CFG_TICK;\n")
    --fprintf(fout, "    csys.ssb_num = CFG_SSB_NUM;\n")
    --fprintf(fout, "    csys.sysmem_top = (VP)&SYSMEM[0];\n")
    --fprintf(fout, "    csys.sysmem_end = (VP)((ADDR)&SYSMEM[0]+sizeof(SYSMEM));\n")
    --if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "    csys.stkmem_top = (VP)&STKMEM[0];\n")
    --    fprintf(fout, "    csys.stkmem_end = (VP)((ADDR)&STKMEM[0]+sizeof(STKMEM));\n")
    --else
    --    fprintf(fout, "    csys.stkmem_top = (VP)0;\n")
    --    fprintf(fout, "    csys.stkmem_end = (VP)0;\n")
    --end
    --if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
    --    fprintf(fout, "    csys.mplmem_top = (VP)&MPLMEM[0];\n")
    --    fprintf(fout, "    csys.mplmem_end = (VP)((ADDR)&MPLMEM[0]+sizeof(MPLMEM));\n")
    --else
    --    fprintf(fout, "    csys.mplmem_top = (VP)0;\n")
    --    fprintf(fout, "    csys.mplmem_end = (VP)0;\n")
    --end
    --if MCFGGetParamInteger("CFG_LOWPOWER_SLEEP", 0) == 1 then
    --    fprintf(fout, "    csys.sysidl = USER_IDLE(lowpower_idle);\n")
    --else
    --    if kernel:sysidl() ~= nil and kernel:sysidl() ~= "" then
    --        fprintf(fout, "    csys.sysidl = USER_IDLE(%s);\n", kernel:sysidl())
    --    else
    --        fprintf(fout, "    csys.sysidl = SYSTEM_IDLE;\n")
    --    end
    --end
    --if kernel:inistk() == nil or kernel:inistk() == "" then
    --    fprintf(fout, "    csys.inistk = STACK_ID_INIT;\n")
    --elseif uC3Std.is_user_init(kernel:inistk()) == true then
    --    fprintf(fout, "    csys.inistk = STACK_USER_INIT(%s);\n", kernel:inistk())
    --else
    --    fprintf(fout, "    csys.inistk = %s;\n", kernel:inistk())
    --end
    --fprintf(fout, "    csys.trace = %s;\n", kernel:trace())
    --fprintf(fout, "    csys.agent = %s;\n", kernel:agent())
    fprintf(fout, "\n")
    fprintf(fout, "    return (int)start_uC3(&csys, initpr);\n")
    fprintf(fout, "}\n")
    fprintf(fout, "\n")

    -- End
    fprintf(fout, "/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
