--[[
  @file     snmp_cfg.c.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/07/04    1.00        
  -------------------------------------------------------
--]]
require("uC3")
require("uC3Std")

-- alias
fprintf = uC3.fprintf

-- Azz̗vf擾
function get_hash_count( hash )
    local cnt = 0

    for key, value in pairs(hash) do
        cnt = cnt + 1
    end

    return cnt
end

-- ^XÑX^bN`𐶐
tsk_stack_hash = {}
function create_tsk_stack( strTaskCnt, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local cnt
    local tsk
    local hash_size

    -- ̃^XNȂꍇ
    if strTaskCnt == nil then
        tsk = MCFGGetKnlStdTask(id)

        -- e[uvfǉ
        hash_size = get_hash_count(tsk_stack_hash)
        strName = "_" .. tsk:task() .. "_stk" .. hash_size
        tsk_stack_hash[strTaskId .. index] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "long long %s[0x%X/sizeof(long long)] @ \"LOCALSTKMEM\";\n", strName, tsk:stksz())
        return
    end

    -- ̃^XNꍇ
    cnt = MCFGGetParamInteger(strTaskCnt, 0)
    for i = 0, (cnt-1) do 
        tsk = MCFGGetKnlStdTask(id .. i+1)

        -- e[uvfǉ
        hash_size = get_hash_count(tsk_stack_hash)
        strName = "_" .. tsk:task() .. "_stk" .. hash_size
        tsk_stack_hash[strTaskId .. index .. "_" .. i] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "long long %s[0x%X/sizeof(long long)] @ \"LOCALSTKMEM\";\n", strName, tsk:stksz())
    end
end

-- ^XN`𐶐iŒ薼j
function create_tsk_for_fixed_name( strName, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local tsk = MCFGGetKnlStdTask(id)

    -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
    fprintf(fout, "extern void %s(VP_INT exinf);\n", tsk:task())
    fprintf(fout, "T_CTSK const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.tskatr2str(bit.bor(tsk:tskatr1(), tsk:tskatr2())))
    -- g
    if tsk:exinf() == nil or tsk:exinf() == "" then
        fprintf(fout, "(VP_INT)0, ")
    else
       fprintf(fout, "(VP_INT)%s, ", tsk:exinf())
    end
    -- ֐
    fprintf(fout, "(FP)%s, ", tsk:task())
    -- Dx
    fprintf(fout, "%d, ", tsk:itskpri())
    -- X^bNTCY
    fprintf(fout, "0x%X, ", tsk:stksz())
    -- X^bN̈
    fprintf(fout, "(VP)%s, ", tsk_stack_hash[strTaskId .. index])
    -- IuWFNg
    if tsk:name() == nil or tsk:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", tsk:name())
    end
end

-- Z}tH`𐶐iŒ薼j
function create_sem_for_fixed_name( strName, strSemId, index )
    local id = MCFGGetParamString(strSemId, index)
    local sem = MCFGGetKnlStdSemaphore(id)

    fprintf(fout, "T_CSEM const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.sematr2str(sem:sematr()))
    -- ̏l
    fprintf(fout, "%d, ", sem:isemcnt())
    -- ̍ől
    fprintf(fout, "%d, ", sem:maxsem())
    -- IuWFNg
    if sem:name() == nil or sem:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", sem:name())
    end
end

-- CxgtO`𐶐iŒ薼j
function create_flg_for_fixed_name( strName, strFlgId, index )
    local id = MCFGGetParamString(strFlgId, index)
    local flg = MCFGGetKnlStdEventFlag(id)

    fprintf(fout, "T_CFLG const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.flgatr2str(flg:flgatr()))
    -- rbgp^[
    fprintf(fout, "0x%X, ", flg:iflgptn())
    -- IuWFNg
    if flg:name() == nil or flg:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", flg:name())
    end
end

-- [{bNX`𐶐iŒ薼j
function create_mbx_for_fixed_name( strName, strMbxId, index )
    local id = MCFGGetParamString(strMbxId, index)
    local mbx = MCFGGetKnlStdMailbox(id)

    fprintf(fout, "T_CMBX const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.mbxatr2str(mbx:mbxatr()))
    -- M郁bZ[W̗Dx̍ől
    fprintf(fout, "%d, ", mbx:mbxmpri())
    -- bZ[WL[wb_
    if bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
        fprintf(fout, "_netapp_mbx%d_mprihd, ", hash_size)
    else 
        fprintf(fout, "(VP)0, ")
    end
    -- IuWFNg
    if mbx:name() == nil or mbx:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", mbx:name())
    end
end

-- [{bNX`𐶐iŒ薼j
function create_soc_for_fixed_name( strName, strSocId, index )
    local id = MCFGGetParamString(strSocId, index)
    local soc = MCFGGetNetStdSoc(id)

    fprintf(fout, "T_NODE const %s = {", strName)
    -- |[gԍ
    fprintf(fout, "%d, ", soc:port())
    -- IPAhX^Cv
    if soc:ipver() == 0 then
        fprintf(fout, "IP_VER4, ")
    else
        fprintf(fout, "IP_VER6, ")
    end
    -- foCX
    fprintf(fout, "CFG_SNMP_NET_DEV_NUM, ")
    -- IP
    fprintf(fout, "INADDR_ANY};\n")
end

--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    local node_count = MCFGGetParamInteger("CFG_UNET3_SNMP_MNGR_COUNT", 0)
    local com_count = MCFGGetParamInteger("CFG_UNET3_SNMP_COM_COUNT", 0)
    local trap_count = MCFGGetParamInteger("CFG_UNET3_SNMP_TRAP_COUNT", 0)

    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    SNMP Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"net_hdr.h\"\n")
    fprintf(fout, "#include \"snmp.h\"\n")
    fprintf(fout, "#include \"snmp_cfg.h\"\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Device ID of network interface */\n")
    fprintf(fout, "#define NET_DEV_ID    CFG_SNMP_NET_DEV_NUM\n")
    
    -- Managers
    fprintf(fout, "\n")
    fprintf(fout, "/* SNMP managers */\n")
    for i = 0, node_count-1 do
        fprintf(fout, "static T_NODE snmp_cfg_mgr_nod_%d = {%d, ", i+1, MCFGGetParamInteger("CFG_UNET3_SNMP_MNGR_PORT", i))
        -- IP version(0:IPv4, 1:IPv6)
        if MCFGGetParamInteger("CFG_UNET3_SNMP_MNGR_IPVER", i) == 0 then
            fprintf(fout, "IP_VER4, ") 
        else
            fprintf(fout, "IP_VER6, ") 
        end
        fprintf(fout, "NET_DEV_ID, ") 
        fprintf(fout, "%s};\n", MCFGGetParamString("CFG_UNET3_SNMP_MNGR_IPADDR", i))
    end
    fprintf(fout, "\n")
    fprintf(fout, "T_SNMP_CFG_MGR snmp_cfg_mgr[] = {\n")
    for i = 0, node_count-1 do
        fprintf(fout, "    {&snmp_cfg_mgr_nod_%d},\n", i+1)
    end
    fprintf(fout, "    0\n")
    fprintf(fout, "};\n")

    -- Communities
    fprintf(fout, "\n")
    fprintf(fout, "/* Communities */\n")
    for i = 0, com_count-1 do
        fprintf(fout, "static VB snmp_cfg_com_%d[] = \"%s\";\n", i+1, MCFGGetParamString("CFG_UNET3_SNMP_COM_NANE", i))
    end
    fprintf(fout, "\n")
    fprintf(fout, "T_SNMP_CFG_COM snmp_cfg_com[] = {\n")
    for i = 0, com_count-1 do
        fprintf(fout, "    {snmp_cfg_com_%d, %s},\n", i+1, MCFGGetParamString("CFG_UNET3_SNMP_COM_STS_STR", i))
    end
    fprintf(fout, "    {0, 0}\n")
    fprintf(fout, "};\n")

    -- Trap
    fprintf(fout, "\n")
    fprintf(fout, "/* Remote host address for normal trap */\n")
    for i = 0, trap_count-1 do
        fprintf(fout, "static VB snmp_cfg_trp_com_%d[] = \"%s\";\n", i+1, MCFGGetParamString("CFG_UNET3_SNMP_TRAP_NANE", i))
    end
    for i = 0, trap_count-1 do
        fprintf(fout, "static T_NODE snmp_cfg_trp_nod_%d = {%d, ", i+1, MCFGGetParamInteger("CFG_UNET3_SNMP_TRAP_PORT", i))
        if MCFGGetParamInteger("CFG_UNET3_SNMP_TRAP_IPVER", i) == 0 then
            fprintf(fout, "IP_VER4, ") 
        else
            fprintf(fout, "IP_VER6, ") 
        end
        fprintf(fout, "NET_DEV_ID, ") 
        fprintf(fout, "%s};\n", MCFGGetParamString("CFG_UNET3_SNMP_TRAP_IPADDR", i))
    end
    fprintf(fout, "\n")
    fprintf(fout, "T_SNMP_CFG_TRP snmp_cfg_trp[] = {\n")
    for i = 0, trap_count-1 do
        fprintf(fout, "    {snmp_cfg_trp_com_%d, &snmp_cfg_trp_nod_%d, %s, 0},\n", i+1, i+1, MCFGGetParamString("CFG_UNET3_SNMP_TRAP_VER_STR", i))
    end
    fprintf(fout, "    {0, 0, 0 ,0}\n")
    fprintf(fout, "};\n")
    
    -- Callback
    cbk = MCFGGetParamString("CFG_UNET3_SNMP_CBK", 0)
    fprintf(fout, "\n")
    fprintf(fout, "/* callback function */\n")
    if cbk ~= "" and cbk ~= nil then
        fprintf(fout, "extern ER %s(T_SNMP_CFG_CBK_DAT*);\n", cbk)
    end
    fprintf(fout, "\n")
    fprintf(fout, "T_SNMP_CFG_CBK snmp_cfg_cbk[] = {\n")
    if cbk ~= "" and cbk ~= nil then
        fprintf(fout, "    %s,\n", cbk)
    end
    fprintf(fout, "    0\n")
    fprintf(fout, "};\n")

    fprintf(fout, "/* OS and netowrk configuration */\n")
    fprintf(fout, "#include \"kernel_id.h\"\n")
    fprintf(fout, "#include \"net_id.h\"\n")
    fprintf(fout, "#ifdef NET_S_OS\n")
    fprintf(fout, "/* Standard OS */\n")
    -- Local stack for Task
    fprintf(fout, "\n")
    fprintf(fout, "/*******************************************\n")
    fprintf(fout, "        Local Stack allocate\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "#ifdef __IAR_SYSTEMS_ICC__\n")
    fprintf(fout, "#pragma section = \"LOCALSTKMEM\"\n")
    create_tsk_stack( nil, "CFG_UNET3_SNMP_TSKID", 0 )
    create_tsk_stack( nil, "CFG_UNET3_SNMP_TSKID", 1 )
    create_tsk_stack( nil, "CFG_UNET3_SNMP_TSKID", 2 )
    fprintf(fout, "#endif\n")
    fprintf(fout, "\n")


    -- snmp task
    create_tsk_for_fixed_name( "snmp_cfg_os_tsk_rcv", "CFG_UNET3_SNMP_TSKID", 0 )
    create_tsk_for_fixed_name( "snmp_cfg_os_tsk_tim", "CFG_UNET3_SNMP_TSKID", 1 )
    create_tsk_for_fixed_name( "snmp_cfg_os_tsk_trp", "CFG_UNET3_SNMP_TSKID", 2 )

    -- snmp semaphore
    create_sem_for_fixed_name( "snmp_cfg_os_sem_mib", "CFG_UNET3_SNMP_SEMID", 0 )
    create_sem_for_fixed_name( "snmp_cfg_os_sem_trp", "CFG_UNET3_SNMP_SEMID", 1 )

    -- snmp event flag
    create_flg_for_fixed_name( "snmp_cfg_os_flg_sts", "CFG_UNET3_SNMP_FLGID", 0 )
    create_flg_for_fixed_name( "snmp_cfg_os_flg_trp", "CFG_UNET3_SNMP_FLGID", 1 )

    -- snmp mailbox
    create_mbx_for_fixed_name( "snmp_cfg_os_mbx_trp", "CFG_UNET3_SNMP_MBXID", 0 )

    -- snmp socket
    create_soc_for_fixed_name( "snmp_cfg_net_soc_udp", "CFG_UNET3_SNMP_SOCID", 0 )
    create_soc_for_fixed_name( "snmp_cfg_net_soc_udp_trp", "CFG_UNET3_SNMP_SOCID", 1 )

    fprintf(fout, "#else\n")
    fprintf(fout, "/* Compact OS */\n")
    fprintf(fout, "/* Do not change the following items */\n")
    fprintf(fout, "const T_SNMP_CFG_OS snmp_cfg_os = {\n")
    fprintf(fout, "    %s,    /* Task for receiving message */\n", MCFGGetParamString("CFG_UNET3_SNMP_TSKID", 0))
    fprintf(fout, "    %s,    /* Task for timer */\n", MCFGGetParamString("CFG_UNET3_SNMP_TSKID", 1))
    fprintf(fout, "    #if (CFG_SNMP_MAX_TRP_CNT > 0)\n")
    fprintf(fout, "    %s,    /* Task for trap */\n", MCFGGetParamString("CFG_UNET3_SNMP_TSKID", 2))
    fprintf(fout, "    #else\n")
    fprintf(fout, "    0,\n")
    fprintf(fout, "    #endif\n")
    fprintf(fout, "    %s,    /* Semaphore for MIB */\n", MCFGGetParamString("CFG_UNET3_SNMP_SEMID", 0))
    fprintf(fout, "    #if (CFG_SNMP_MAX_TRP_CNT > 0)\n")
    fprintf(fout, "    %s,    /* Semaphore for trap */\n", MCFGGetParamString("CFG_UNET3_SNMP_SEMID", 1))
    fprintf(fout, "    #else\n")
    fprintf(fout, "    0,\n")
    fprintf(fout, "    #endif\n")
    fprintf(fout, "    %s,    /* Flag for status */\n", MCFGGetParamString("CFG_UNET3_SNMP_FLGID", 0))
    fprintf(fout, "    #if (CFG_SNMP_MAX_TRP_CNT > 0)\n")
    fprintf(fout, "    %s,    /* Flag for trap */\n", MCFGGetParamString("CFG_UNET3_SNMP_FLGID", 1))
    fprintf(fout, "    %s,    /* Mailbox for trap */\n", MCFGGetParamString("CFG_UNET3_SNMP_MBXID", 0))
    fprintf(fout, "    #else\n")
    fprintf(fout, "    0,\n")
    fprintf(fout, "    0,\n")
    fprintf(fout, "    #endif\n")
    fprintf(fout, "    %s,    /* UDP socket */\n", MCFGGetParamString("CFG_UNET3_SNMP_SOCID", 0))
    fprintf(fout, "    %s /* UDP socket for TRP */\n", MCFGGetParamString("CFG_UNET3_SNMP_SOCID", 1))
    fprintf(fout, "};\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* User configuration */\n")
    fprintf(fout, "const T_SNMP_CFG_USR snmp_cfg_usr = {\n")
    fprintf(fout, "    CFG_SNMP_NET_DEV_NUM,    /* Network device number */\n")
    fprintf(fout, "    CFG_SNMP_UDP_SND_TMO,    /* UDP socket send timeout */\n")
    fprintf(fout, "    CFG_SNMP_UDP_RCV_TMO,    /* UDP socket receive timeout */\n")
    fprintf(fout, "    CFG_SNMP_SEM_TMO,        /* Semaphore timeput period */\n")
    fprintf(fout, "    CFG_SNMP_FNC_FLG,        /* SNMP agent */\n")
    fprintf(fout, "    CFG_SNMP_MAX_TRP_CNT,    /* Number of traps at any time */\n")
    fprintf(fout, "    CFG_SNMP_SND_MSG_LEN,    /* Maximum size of an SNMP message can send */\n")
    fprintf(fout, "    CFG_SNMP_RCV_MSG_LEN,    /* Maximum size of an SNMP message can receive */\n")
    fprintf(fout, "    CFG_SNMP_MSG_VAR_CNT,    /* Maximum number of variable bindings */\n")
    fprintf(fout, "    CFG_SNMP_MIB_NOD_CNT,    /* Number of nodes in the MIB tree */\n")
    fprintf(fout, "    CFG_SNMP_MAX_MIB_DEP,    /* Maximum depth of the MIB tree */\n")
    fprintf(fout, "    CFG_SNMP_MIB_DAT_LEN,    /* Maximum size of the MIB data */\n")
    fprintf(fout, "    CFG_SNMP_GEN_TRP_ENA     /* Generic trap enabled */\n")
    fprintf(fout, "};\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* Global variables */\n")
    fprintf(fout, "#include \"snmp_ber.h\"\n")
    fprintf(fout, "#include \"snmp_def.h\"\n")
    fprintf(fout, "#include \"snmp_mac.h\"\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* TCP configuration */\n")
    fprintf(fout, "const T_SNMP_CFG_TCP snmp_cfg_tcp = {\n")
    fprintf(fout, "    CFG_SNMP_MAX_SOC_CNT,   /* Number of sockets */\n")
    fprintf(fout, "    CFG_SNMP_MAX_TCP_CNT,   /* Number of TCP sockets */\n")
    fprintf(fout, "    SNMP_MAC_ARP_DAT_CNT,   /* Number of ARP data buffer */\n")
    fprintf(fout, "    SNMP_MAC_TCP_DAT_CNT    /* Number of TCP data buffer */\n")
    fprintf(fout, "};\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* Data buffer */\n")
    fprintf(fout, "UW snmp_cfg_buf[SNMP_MAC_BUF_LEN];             /* SNMP */\n")
    fprintf(fout, "UW snmp_cfg_tcp_buf[SNMP_MAC_TCP_BUF_LEN];     /* TCP */\n")
    fprintf(fout, "\n")
    
    -- End
    fprintf(fout, "\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



