--[[
  @file     ftp_client_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/13    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    TFTP Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __TFTP_CLIENT_CFG_H__\n")
    fprintf(fout, "#define __TFTP_CLIENT_CFG_H__\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_FFSYS_USE", 0) == 1 then
        fprintf(fout, "/* File system */\n")
        if MCFGGetParamInteger("CFG_UNET3_FFSYS_SEL", 0) == 0 then
            fprintf(fout, "#include \"%s\"\n",  MCFGGetParamString("CFG_UNET3_FFSYS_OTHER_INC", 0))
        else
            fprintf(fout, "#include \"ffsys.h\"\n")
        end
    end
    fprintf(fout, "\n")
    fprintf(fout, "#define TFTP_RETRY_CNT      %d       /* TFTP Communication retries */\n", MCFGGetParamInteger("CFG_UNET3_TFTPC_RETRY_CNT", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __TFTP_CLIENT_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



