--[[
  @file     net_cfg.c.lua
  @brief    
  
  @author   t-nakamura
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2015/04/03    1.00        t@[Xg[X
  2015/06/05    -           HTTPdgT|[g
  -------------------------------------------------------
--]]
require("uC3")
require("uC3Std")

-- alias
fprintf = uC3.fprintf


--[[
    Support function
--]]

function bytetbl(n, cnt)
    fprintf(fout, "0x%02x, ", n)
    if (cnt % 8) == 7 then
        fprintf(fout, "\n")
    end
end

-- ֐錾֐̂ݒo
-- Ex.) Get "temp_net_ini" from "ER temp_net_ini(UH dev_num)"
function extract_funcname(decl)
    local m = "#err#"
    if decl ~= nil then
        m = string.match(decl, "[^%s]+%s+([^%s(]+).+")
        if m == nil then
          m = decl
        end
    end
    
    return m
end

-- lbg[NC^tF[X̃N^Cv(g)
-- Ex.) "Ethernet0" -> {"Ethernet","0"}, "Loopback" -> {"Loopback", nil}, "PPP0" -> {"PPP","0"}, "Virtual" -> {"Virtual", nil}, 
function netif_linktype_ex(index)
    local name = MCFGGetParamString("CFG_UNET3_IFDEV", index)
    local num
    name, num = string.match(name, "([a-zA-Z]+)([0-9]*)")
    return name, num
end

-- lbg[NC^tF[X̃N^Cv
function netif_linktype(index)
    local name, num
    name, num = netif_linktype_ex(index)
    return name
end

-- w胊N^CvJEg
function netif_linktype_count(name)
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if netif_linktype(i) == name then
            count = count + 1
        end
    end
    return count
end


-- PPPfoCX
function netif_ppp_count()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if netif_linktype(i) == "PPP" then
            count  = count + 1
        end
    end
    return count
end

-- ACD@\gpC^tF[X
function count_acd_all()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if netif_linktype(i) ~= "PPP" then
            if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 then
                count  = count + 1
            end
        end
    end
    return count
end

function count_acd_static()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 and MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE", i) == 0 then
            count  = count + 1
        end
    end
    return count
end

-- t@Cϐɕϊ
-- ϐLnbVe[u
resource_hash = {}
function filename2variable(filename, cnt)
    local var = filename
    -- ʂȋ󔒏
    --var = string.match(var, "(%S+)")
    -- t@C擾
    var = uC3.path_basename(var)
    -- Xy[XAhbg̓A_[XRAɕϊ
    var = string.gsub(var, " ", "_")
    var = string.gsub(var, "%.", "_")
    -- t@C͏d邱Ƃ̂
    -- dh߂ɘAԂǉ
    var = var..cnt
    -- tpXL[ƂănbVŊǗ
    resource_hash[filename] = var
    return var
end

-- \PbgIDIPver擾
function socid2ipver(id)
    local ver = 0
    local count = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    for i = 0, count-1 do
        if MCFGGetParamString("CFG_UNET3_SOCID", i) == id then
            ver = MCFGGetParamInteger("CFG_UNET3_SOC_IPVER", i)
            break
        end
    end
    return ver
end

function is_uniq_resource(res, cur) 
    for i = 0, cur-1 do 
        if res == MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i) then
            return false
        end
    end
    return true
end

function is_uniq_altfunc(func, cur) 
    for i = 0, cur-1 do 
        if func == MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i) then
            return false
        end
    end
    return true
end

-- ̍(orE)ɃXy[X߂
function fill_spc(str, cnt, left)
    local fmt = "%" .. ((left == 0) and "" or "-") .. cnt .. "s"
    local s = string.format(fmt, str)
    return s
end

--[[
    FTPd̃ZLeB|V[̏擾
--]]
function get_ftpd_secure_info()
    local result = ""

    if MCFGGetParamInteger("CFG_UNET3_FTPD_NOT_WELLKNOWN", 0) ~= 0 then
        result = result .. "ENA_NOTCON_WELL_KNOWNPORT"
    end

    if MCFGGetParamInteger("CFG_UNET3_FTPD_DENY_PORTCMD", 0) ~= 0 then
        if result == "" then
            -- _aŌKvȂ
            result = result .. "ENA_DENY_PORTCOMMAND"
        else
            -- _aŌKv
            result = result .. " | ENA_DENY_PORTCOMMAND"
        end
    end

    return result
end

-- Azz̗vf擾
function get_hash_count( hash )
    local cnt = 0

    for key, value in pairs(hash) do
        cnt = cnt + 1
    end

    return cnt
end

-- ^XÑX^bN`𐶐
tsk_stack_hash = {}
function create_tsk_stack( strTaskCnt, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local cnt
    local tsk
    local hash_size

    -- ̃^XNȂꍇ
    if strTaskCnt == nil then
        tsk = MCFGGetKnlStdTask(id)

        -- e[uvfǉ
        hash_size = get_hash_count(tsk_stack_hash)
        strName = "_" .. tsk:task() .. "_stk" .. hash_size
        tsk_stack_hash[strTaskId .. index] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "long long %s[0x%X/sizeof(long long)] @ \"LOCALSTKMEM\";\n", strName, tsk:stksz())
        return
    end

    -- ̃^XNꍇ
    cnt = MCFGGetParamInteger(strTaskCnt, 0)
    for i = 0, (cnt-1) do 
        tsk = MCFGGetKnlStdTask(id .. i+1)

        -- e[uvfǉ
        hash_size = get_hash_count(tsk_stack_hash)
        strName = "_" .. tsk:task() .. "_stk" .. hash_size
        tsk_stack_hash[strTaskId .. index .. "_" .. i] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "long long %s[0x%X/sizeof(long long)] @ \"LOCALSTKMEM\";\n", strName, tsk:stksz())
    end
end

-- Œ蒷v[`𐶐
mpf_size_hash = {}
function create_mpf_size( strMpfCnt, strMpfId, index )
    local id = MCFGGetParamString(strMpfId, index)
    local cnt
    local mpf
    local strName
    local hash_size

    -- MPFȂꍇ
    if strMpfCnt == nil then
        -- e[uvfǉ
        hash_size = get_hash_count(mpf_size_hash)
        strName = "_netapp_mpf" .. hash_size .. "_buf"
        mpf_size_hash[strMpfId .. index] = strName

        mpf = MCFGGetKnlStdFixedMemPool(id)
        if mpf:direct() == true then
            fprintf(fout, "long long %s[(%d*%d)/sizeof(long long)] @ \"LOCALMPLMEM\";\n", strName, mpf:blkcnt(), mpf:blksz())
        else 
            fprintf(fout, "long long %s[(%d*TSZ_MPF(1, (%s)))/sizeof(long long)] @ \"LOCALMPLMEM\";\n", strName, mpf:blkcnt(), mpf:expression())
        end

        return
    end

    -- MPFꍇ
    cnt = MCFGGetParamInteger(strMpfCnt, 0)
    for i = 0, (cnt-1) do 
        -- e[uvfǉ
        hash_size = get_hash_count(mpf_size_hash)
        strName = "_netapp_mpf" .. hash_size .. "_buf"
        mpf_size_hash[strMpfId .. index .. "_" .. i] = strName

        mpf = MCFGGetKnlStdFixedMemPool(id .. i+1)
        if mpf:direct() == true then
            fprintf(fout, "long long %s[(%d*%d)/sizeof(long long)] @ \"LOCALMPLMEM\";\n", strName, mpf:blkcnt(), mpf:blksz())
        else 
            fprintf(fout, "long long %s[(%d*TSZ_MPF(1, (%s)))/sizeof(long long)] @ \"LOCALMPLMEM\";\n", strName, mpf:blkcnt(), mpf:expression())
        end
    end
end

-- ^XN`𐶐iŒ薼j
function create_tsk_for_fixed_name( strName, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local tsk = MCFGGetKnlStdTask(id)

    -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
    fprintf(fout, "extern void %s(VP_INT exinf);\n", tsk:task())
    fprintf(fout, "T_CTSK const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.tskatr2str(bit.bor(tsk:tskatr1(), tsk:tskatr2())))
    -- g
    if tsk:exinf() == nil or tsk:exinf() == "" then
        fprintf(fout, "(VP_INT)0, ")
    else
       fprintf(fout, "(VP_INT)%s, ", tsk:exinf())
    end
    -- ֐
    fprintf(fout, "(FP)%s, ", tsk:task())
    -- Dx
    fprintf(fout, "%d, ", tsk:itskpri())
    -- X^bNTCY
    fprintf(fout, "0x%X, ", tsk:stksz())
    -- X^bN̈
    fprintf(fout, "(VP)%s, ", tsk_stack_hash[strTaskId .. index])
    -- IuWFNg
    if tsk:name() == nil or tsk:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", tsk:name())
    end
end

-- ^XN`𐶐
tsk_hash = {}
function create_tsk( strTaskCnt, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local cnt
    local tsk
    local hash_size

    -- ̃^XNȂꍇ
    if strTaskCnt == nil then
        tsk = MCFGGetKnlStdTask(id)

        -- e[uvfǉ
        hash_size = get_hash_count( tsk_hash )
        strName = "_netapp_ctsk" .. hash_size
        tsk_hash[strTaskId .. index] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "extern void %s(VP_INT exinf);\n", tsk:task())
        fprintf(fout, "static T_CTSK const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.tskatr2str(bit.bor(tsk:tskatr1(), tsk:tskatr2())))
        -- g
        if tsk:exinf() == nil or tsk:exinf() == "" then
            fprintf(fout, "(VP_INT)0, ")
        else
           fprintf(fout, "(VP_INT)%s, ", tsk:exinf())
        end
        -- ֐
        fprintf(fout, "(FP)%s, ", tsk:task())
        -- Dx
        fprintf(fout, "%d, ", tsk:itskpri())
        -- X^bNTCY
        fprintf(fout, "0x%X, ", tsk:stksz())
        -- X^bN̈
        fprintf(fout, "(VP)%s, ", tsk_stack_hash[strTaskId .. index])
        -- IuWFNg
        if tsk:name() == nil or tsk:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", tsk:name())
        end
        return
    end

    -- ̃^XNꍇ
    cnt = MCFGGetParamInteger(strTaskCnt, 0)
    for i = 0, (cnt-1) do 
        tsk = MCFGGetKnlStdTask(id .. i+1)

        -- e[uvfǉ
        hash_size = get_hash_count( tsk_hash )
        strName = "_netapp_ctsk" .. hash_size
        tsk_hash[strTaskId .. index .. "_" .. i] = strName

        -- ϐɊ֐͎gpłȂBIDقȂΓ֐͎gp\
        fprintf(fout, "extern void %s(VP_INT exinf);\n", tsk:task())
        fprintf(fout, "static T_CTSK const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.tskatr2str(bit.bor(tsk:tskatr1(), tsk:tskatr2())))
        -- g
        if tsk:exinf() == nil or tsk:exinf() == "" then
            fprintf(fout, "(VP_INT)0, ")
        else
           fprintf(fout, "(VP_INT)%s, ", tsk:exinf())
        end
        -- ֐
        fprintf(fout, "(FP)%s, ", tsk:task())
        -- Dx
        fprintf(fout, "%d, ", tsk:itskpri())
        -- X^bNTCY
        fprintf(fout, "0x%X, ", tsk:stksz())
        -- X^bN̈
        fprintf(fout, "(VP)%s, ", tsk_stack_hash[strTaskId .. index .. "_" .. i])
        -- IuWFNg
        if tsk:name() == nil or tsk:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", tsk:name())
        end
    end
end

-- CxgtO`𐶐iŒ薼j
function create_flg_for_fixed_name( strName, strFlgId, index )
    local id = MCFGGetParamString(strFlgId, index)
    local flg = MCFGGetKnlStdEventFlag(id)

    fprintf(fout, "T_CFLG const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.flgatr2str(flg:flgatr()))
    -- rbgp^[
    fprintf(fout, "0x%X, ", flg:iflgptn())
    -- IuWFNg
    if flg:name() == nil or flg:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", flg:name())
    end
end

-- CxgtO`𐶐
flg_hash = {}
function create_flg( strFlgCnt, strFlgId, index )
    local id = MCFGGetParamString(strFlgId, index)
    local cnt
    local flg
    local strName
    local hash_size

    -- FLGȂꍇ
    if strFlgCnt == nil then
        -- e[uvfǉ
        hash_size = get_hash_count( flg_hash )
        strName = "_netapp_cflg" .. hash_size
        flg_hash[strFlgId .. index] = strName

        flg = MCFGGetKnlStdEventFlag(id)
        fprintf(fout, "static T_CFLG const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.flgatr2str(flg:flgatr()))
        -- rbgp^[
        fprintf(fout, "0x%X, ", flg:iflgptn())
        -- IuWFNg
        if flg:name() == nil or flg:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", flg:name())
        end

        return
    end

    -- FLGꍇ
    cnt = MCFGGetParamInteger(strFlgCnt, 0)
    for i = 0, (cnt-1) do 
        -- e[uvfǉ
        hash_size = get_hash_count( flg_hash )
        strName = "_netapp_cflg" .. hash_size
        flg_hash[strFlgId .. index .. "_" .. i] = strName

        flg = MCFGGetKnlStdEventFlag(id .. i+1)
        fprintf(fout, "static T_CFLG const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.flgatr2str(flg:flgatr()))
        -- rbgp^[
        fprintf(fout, "0x%X, ", flg:iflgptn())
        -- IuWFNg
        if flg:name() == nil or flg:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", flg:name())
        end
    end
end

-- [{bNX`𐶐iŒ薼j
function create_mbx_for_fixed_name( strName, strMbxId, index )
    local id = MCFGGetParamString(strMbxId, index)
    local mbx = MCFGGetKnlStdMailbox(id)

    fprintf(fout, "T_CMBX const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.mbxatr2str(mbx:mbxatr()))
    -- M郁bZ[W̗Dx̍ől
    fprintf(fout, "%d, ", mbx:mbxmpri())
    -- bZ[WL[wb_
    if bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
        fprintf(fout, "_netapp_mbx%d_mprihd, ", hash_size)
    else 
        fprintf(fout, "(VP)0, ")
    end
    -- IuWFNg
    if mbx:name() == nil or mbx:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", mbx:name())
    end
end

-- [{bNX`𐶐
mbx_hash = {}
function create_mbx( strMbxCnt, strMbxId, index )
    local id = MCFGGetParamString(strMbxId, index)
    local cnt
    local mbx
    local strName
    local hash_size

    -- MBXȂꍇ
    if strMbxCnt == nil then
        -- e[uvfǉ
        hash_size = get_hash_count( mbx_hash )
        strName = "_netapp_cmbx" .. hash_size
        mbx_hash[strMbxId .. index] = strName

        mbx = MCFGGetKnlStdMailbox(id)
        fprintf(fout, "static T_CMBX const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.mbxatr2str(mbx:mbxatr()))
        -- M郁bZ[W̗Dx̍ől
        fprintf(fout, "%d, ", mbx:mbxmpri())
        -- bZ[WL[wb_
        if bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
            fprintf(fout, "_netapp_mbx%d_mprihd, ", hash_size)
        else 
            fprintf(fout, "(VP)0, ")
        end
        -- IuWFNg
        if mbx:name() == nil or mbx:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", mbx:name())
        end

        return
    end

    -- MBXꍇ
    cnt = MCFGGetParamInteger(strMbxCnt, 0)
    for i = 0, (cnt-1) do 
        -- e[uvfǉ
        hash_size = get_hash_count( mbx_hash )
        strName = "_netapp_cmbx" .. hash_size
        mbx_hash[strMbxId .. index .. "_" .. i] = strName

        mbx = MCFGGetKnlStdMailbox(id .. i+1)
        fprintf(fout, "static T_CMBX const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.mbxatr2str(mbx:mbxatr()))
        -- M郁bZ[W̗Dx̍ől
        fprintf(fout, "%d, ", mbx:mbxmpri())
        -- bZ[WL[wb_
        if bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
            fprintf(fout, "_netapp_mbx%d_mprihd, ", hash_size)
        else 
            fprintf(fout, "(VP)0, ")
        end
        -- IuWFNg
        if mbx:name() == nil or mbx:name() == "" then
            fprintf(fout, "NULL};\n")
        else
           fprintf(fout, "\"%s\"};\n", mbx:name())
        end
    end
end

-- Œ蒷v[`𐶐iŒ薼j
function create_mpf_for_fixed_name( strName, strMpfId, index )
    local id = MCFGGetParamString(strMpfId, index)
    local mpf = MCFGGetKnlStdFixedMemPool(id)

    fprintf(fout, "T_CMPF const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.mpfatr2str(mpf:mpfatr()))
    -- ubN
    fprintf(fout, "%d, ", mpf:blkcnt())
    -- ubNTCY
    if mpf:direct() == true then
        fprintf(fout, "%d, ", mpf:blksz())
    else
        fprintf(fout, "TSZ_MPF(1, (%s)), ", mpf:expression())
    end
    -- v[̈̐擪Ԓn
    fprintf(fout, "(VP)%s, ", mpf_size_hash[strMpfId .. index])
    -- IuWFNg
    if mpf:name() == nil or mpf:name() == "" then
        fprintf(fout, "NULL};\n")
    else
        fprintf(fout, "\"%s\"};\n", mpf:name())
    end
end


-- Œ蒷v[`𐶐
mpf_hash = {}
function create_mpf( strMpfCnt, strMpfId, index )
    local id = MCFGGetParamString(strMpfId, index)
    local cnt
    local mpf
    local strName
    local hash_size

    -- MPFȂꍇ
    if strMpfCnt == nil then
        -- e[uvfǉ
        hash_size = get_hash_count( mpf_hash )
        strName = "_netapp_cmpf" .. hash_size
        mpf_hash[strMpfId .. index] = strName

        mpf = MCFGGetKnlStdFixedMemPool(id)
        fprintf(fout, "static T_CMPF const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.mpfatr2str(mpf:mpfatr()))
        -- ubN
        fprintf(fout, "%d, ", mpf:blkcnt())
        -- ubNTCY
        if mpf:direct() == true then
            fprintf(fout, "%d, ", mpf:blksz())
        else
            fprintf(fout, "TSZ_MPF(1, (%s)), ", mpf:expression())
        end
        -- v[̈̐擪Ԓn
        fprintf(fout, "(VP)%s, ", mpf_size_hash[strMpfId .. index])
        -- IuWFNg
        if mpf:name() == nil or mpf:name() == "" then
            fprintf(fout, "NULL};\n")
        else
            fprintf(fout, "\"%s\"};\n", mpf:name())
        end

        return
    end

    -- MPFꍇ
    cnt = MCFGGetParamInteger(strMpfCnt, 0)
    for i = 0, (cnt-1) do 
        -- e[uvfǉ
        hash_size = get_hash_count( mpf_hash )
        strName = "_netapp_cmpf" .. hash_size
        mpf_hash[strMpfId .. index .. "_" .. i] = strName

        mpf = MCFGGetKnlStdFixedMemPool(id .. i+1)
        fprintf(fout, "static T_CMPF const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.mpfatr2str(mpf:mpfatr()))
        -- ubN
        fprintf(fout, "%d, ", mpf:blkcnt())
        -- ubNTCY
        if mpf:direct() == true then
            fprintf(fout, "%d, ", mpf:blksz())
        else
            fprintf(fout, "TSZ_MPF(1, (%s)), ", mpf:expression())
        end
        -- v[̈̐擪Ԓn
        fprintf(fout, "(VP)%s, ", mpf_size_hash[strMpfId .. index .. "_" .. i])
        -- IuWFNg
        if mpf:name() == nil or mpf:name() == "" then
            fprintf(fout, "NULL};\n")
        else
            fprintf(fout, "\"%s\"};\n", mpf:name())
        end
    end
end

-- Z}tH`𐶐iŒ薼j
function create_sem_for_fixed_name( strName, strSemId, index )
    local id = MCFGGetParamString(strSemId, index)
    local sem = MCFGGetKnlStdSemaphore(id)

    fprintf(fout, "T_CSEM const %s = {", strName)
    -- 
    fprintf(fout, "%s, ", uC3Std.sematr2str(sem:sematr()))
    -- ̏l
    fprintf(fout, "%d, ", sem:isemcnt())
    -- ̍ől
    fprintf(fout, "%d, ", sem:maxsem())
    -- IuWFNg
    if sem:name() == nil or sem:name() == "" then
        fprintf(fout, "NULL};\n")
    else
       fprintf(fout, "\"%s\"};\n", sem:name())
    end
end

-- 荞݃T[rX[``𐶐
isr_hash = {}
function create_isr( strIsrCnt, strIsrId, index )
    local id = MCFGGetParamString(strIsrId, index)
    local cnt
    local isr
    local strName
    local hash_size

    -- ISRȂꍇ
    if strIsrCnt == nil then
        -- e[uvfǉ
        hash_size = get_hash_count( isr_hash )
        strName = "_netapp_cisr" .. hash_size
        isr_hash[strIsrId .. index] = strName

        isr = MCFGGetKnlStdIsr(id)
        fprintf(fout, "extern void %s(VP_INT exinf);\n", isr:isr())
        fprintf(fout, "static T_CISR const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.isratr2str(isr:isratr()))
        -- g
        if isr:exinf() == nil or isr:exinf() == "" then
            fprintf(fout, "(VP_INT)0, ")
        else
           fprintf(fout, "(VP_INT)%s, ", isr:exinf())
        end
        -- ݔԍ
        fprintf(fout, "%d, ", isr:intno())
        -- ֐
        fprintf(fout, "(FP)%s, ", isr:isr())
        -- ݃x
        fprintf(fout, "%d};\n", isr:imask())

        return
    end

    -- ISRꍇ
    cnt = MCFGGetParamInteger(strIsrCnt, 0)
    for i = 0, (cnt-1) do 
        -- e[uvfǉ
        hash_size = get_hash_count( isr_hash )
        strName = "_netapp_cisr" .. hash_size
        isr_hash[strIsrId .. index .. "_" .. i] = strName

        isr = MCFGGetKnlStdIsr(id .. i+1)
        fprintf(fout, "extern void %s(VP_INT exinf);\n", isr:isr())
        fprintf(fout, "static T_CISR const %s = {", strName)
        -- 
        fprintf(fout, "%s, ", uC3Std.isratr2str(isr:isratr()))
        -- g
        if isr:exinf() == nil or isr:exinf() == "" then
            fprintf(fout, "(VP_INT)0, ")
        else
           fprintf(fout, "(VP_INT)%s, ", isr:exinf())
        end
        -- ݔԍ
        fprintf(fout, "%d, ", isr:intno())
        -- ֐
        fprintf(fout, "(FP)%s, ", isr:isr())
        -- ݃x
        fprintf(fout, "%d};\n", isr:imask())
    end
end

-- acre_tsk̃R[h𐶐
function create_acre_tsk( strTaskCnt, strTaskId, index )
    local id = MCFGGetParamString(strTaskId, index)
    local cnt
    local tsk

    -- ̃^XNȂꍇ
    if strTaskCnt == nil then
        tsk = MCFGGetKnlStdTask(id)

        fprintf(fout, "    %s = acre_tsk((T_CTSK *)&%s);\n", tsk:tskid(), tsk_hash[strTaskId .. index])
        fprintf(fout, "    if ( %s <= 0 ) {\n", tsk:tskid())
        fprintf(fout, "        return (ER)%s;\n", tsk:tskid())
        fprintf(fout, "    }\n")

        return
    end

    -- ̃^XNꍇ
    cnt = MCFGGetParamInteger(strTaskCnt, 0)
    for i = 0, (cnt-1) do 
        tsk = MCFGGetKnlStdTask(id .. i+1)

        fprintf(fout, "    %s = acre_tsk((T_CTSK *)&%s);\n", tsk:tskid(), tsk_hash[strTaskId .. index .. "_" .. i])
        fprintf(fout, "    if ( %s <= 0 ) {\n", tsk:tskid())
        fprintf(fout, "        return (ER)%s;\n", tsk:tskid())
        fprintf(fout, "    }\n")
    end
end

-- acre_flg̃R[h𐶐
function create_acre_flg( strFlgCnt, strFlgId, index )
    local id = MCFGGetParamString(strFlgId, index)
    local cnt
    local flg

    -- FLGȂꍇ
    if strFlgCnt == nil then
        flg = MCFGGetKnlStdEventFlag(id)

        fprintf(fout, "    %s = acre_flg((T_CFLG *)&%s);\n", flg:flgid(), flg_hash[strFlgId .. index])
        fprintf(fout, "    if ( %s <= 0 ) {\n", flg:flgid())
        fprintf(fout, "        return (ER)%s;\n", flg:flgid())
        fprintf(fout, "    }\n")

        return
    end

    -- FLGꍇ
    cnt = MCFGGetParamInteger(strFlgCnt, 0)
    for i = 0, (cnt-1) do 
        flg = MCFGGetKnlStdEventFlag(id .. i+1)

        fprintf(fout, "    %s = acre_flg((T_CFLG *)&%s);\n", flg:flgid(), flg_hash[strFlgId .. index .. "_" .. i])
        fprintf(fout, "    if ( %s <= 0 ) {\n", flg:flgid())
        fprintf(fout, "        return (ER)%s;\n", flg:flgid())
        fprintf(fout, "    }\n")
    end
end

-- acre_mbx̃R[h𐶐
function create_acre_mbx( strMbxCnt, strMbxId, index )
    local id = MCFGGetParamString(strMbxId, index)
    local cnt
    local mbx

    -- MBXȂꍇ
    if strMbxCnt == nil then
        mbx = MCFGGetKnlStdMailbox(id)

        fprintf(fout, "    %s = acre_mbx((T_CMBX *)&%s);\n", mbx:mbxid(), mbx_hash[strMbxId .. index])
        fprintf(fout, "    if ( %s <= 0 ) {\n", mbx:mbxid())
        fprintf(fout, "        return (ER)%s;\n", mbx:mbxid())
        fprintf(fout, "    }\n")

        return
    end

    -- MBXꍇ
    cnt = MCFGGetParamInteger(strMbxCnt, 0)
    for i = 0, (cnt-1) do 
        mbx = MCFGGetKnlStdMailbox(id .. i+1)

        fprintf(fout, "    %s = acre_mbx((T_CMBX *)&%s);\n", mbx:mbxid(), mbx_hash[strMbxId .. index .. "_" .. i])
        fprintf(fout, "    if ( %s <= 0 ) {\n", mbx:mbxid())
        fprintf(fout, "        return (ER)%s;\n", mbx:mbxid())
        fprintf(fout, "    }\n")
    end
end

-- acre_mpf̃R[h𐶐
function create_acre_mpf( strMpfCnt, strMpfId, index )
    local id = MCFGGetParamString(strMpfId, index)
    local cnt
    local mpf

    -- MPFȂꍇ
    if strMpfCnt == nil then
        mpf = MCFGGetKnlStdFixedMemPool(id)

        fprintf(fout, "    %s = acre_mpf((T_CMPF *)&%s);\n", mpf:mpfid(), mpf_hash[strMpfId .. index])
        fprintf(fout, "    if ( %s <= 0 ) {\n", mpf:mpfid())
        fprintf(fout, "        return (ER)%s;\n", mpf:mpfid())
        fprintf(fout, "    }\n")

        return
    end

    -- MPFꍇ
    cnt = MCFGGetParamInteger(strMpfCnt, 0)
    for i = 0, (cnt-1) do 
        mpf = MCFGGetKnlStdFixedMemPool(id .. i+1)

        fprintf(fout, "    %s = acre_mpf((T_CMPF *)&%s);\n", mpf:mpfid(), mpf_hash[strMpfId .. index .. "_" .. i])
        fprintf(fout, "    if ( %s <= 0 ) {\n", mpf:mpfid())
        fprintf(fout, "        return (ER)%s;\n", mpf:mpfid())
        fprintf(fout, "    }\n")
    end
end

-- acre_isr̃R[h𐶐
function create_acre_isr( strIsrCnt, strIsrId, index )
    local id = MCFGGetParamString(strIsrId, index)
    local cnt
    local isr

    -- ISRȂꍇ
    if strIsrCnt == nil then
        isr = MCFGGetKnlStdIsr(id)

        fprintf(fout, "    %s = acre_isr((T_CISR *)&%s);\n", isr:isrid(), isr_hash[strIsrId .. index])
        fprintf(fout, "    if ( %s <= 0 ) {\n", isr:isrid())
        fprintf(fout, "        return (ER)%s;\n", isr:isrid())
        fprintf(fout, "    }\n")

        return
    end

    -- ISRꍇ
    cnt = MCFGGetParamInteger(strIsrCnt, 0)
    for i = 0, (cnt-1) do 
        isr = MCFGGetKnlStdIsr(id .. i+1)

        fprintf(fout, "    %s = acre_isr((T_CISR *)&%s);\n", isr:isrid(), isr_hash[strIsrId .. index .. "_" .. i])
        fprintf(fout, "    if ( %s <= 0 ) {\n", isr:isrid())
        fprintf(fout, "        return (ER)%s;\n", isr:isrid())
        fprintf(fout, "    }\n")
    end
end

--[[
    main function
--]]
function main()
    -- Variables
    version     = MCFGGetParamInteger("CFG_UNET3_VERSION", 0)
    tcp_count   = MCFGGetParamInteger("CFG_UNET3_SOC_TCP_COUNT", 0)
    udp_count   = MCFGGetParamInteger("CFG_UNET3_SOC_UDP_COUNT", 0)
    soc_count   = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    dhcp_count  = MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE_COUNT", 0)
    httpd_use   = MCFGGetParamInteger("CFG_UNET3_HTTPD_USE", 0)
    httpc_use   = MCFGGetParamInteger("CFG_UNET3_HTTPC_USE", 0)
    ipv6_use    = MCFGGetParamInteger("CFG_UNET3_IPV6_USE", 0)
    raw_use     = MCFGGetParamInteger("CFG_UNET3_RAW_USE", 0)
    use_bootpc  = MCFGGetParamInteger("CFG_UNET3_BOOTPC_USE", 0)
    use_bootpc  = (0 < use_bootpc) and MCFGGetParamInteger("CFG_UNET3_BOOTPC_INI", 0) or 0
    boot_func   = (0 < use_bootpc) and MCFGGetParamString("CFG_UNET3_BOOTPC_FUNC", 0) or ""
    bsd_use     = 0
    ssl_use     = MCFGGetParamInteger("CFG_UNET3_SSL_USE", 0)
    use_hw_os = MCFGGetParamInteger("CFG_UNET3_ETHER_NET_HW_OS", 0)
    
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local spc_cnt
    -- ver3ȍ~̕ϐ
    ftpd_use    = 0
    tftpd_use   = 0
    dhcpd_use   = 0
    sntpd_use   = 0
    telnetd_use = 0
    snmp_use    = 0
    httpd_ext_use = 0
    httpd_ext_cbk = 0
    forwarding_use = 0
    -- BSD variables
    bsd_tcps = 0
    bsd_udps = 0
    bsd_tsks = 0
    -- TCP veriables
    tcp_sndbuf_total = 0
    dynamic_tcp_defsndbuf = 0


    if version >= 300 then
        ftpd_use    = MCFGGetParamInteger("CFG_UNET3_FTPD_USE", 0)
        tftpd_use   = MCFGGetParamInteger("CFG_UNET3_TFTPD_USE", 0)
        dhcpd_use   = MCFGGetParamInteger("CFG_UNET3_DHCPD_USE", 0)
        sntpd_use   = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE", 0)
        telnetd_use = MCFGGetParamInteger("CFG_UNET3_TELNETD_USE", 0)
        snmp_use    = MCFGGetParamInteger("CFG_UNET3_SNMP_USE", 0)
        httpd_ext_use = MCFGGetParamInteger("CFG_UNET3_HTTPD_EXT_USE", 0)
        httpd_ext_cbk = MCFGGetParamString("CFG_UNET3_HTTPD_EXT_CBK", 0)
        forwarding_use = MCFGGetParamInteger("CFG_UNET3_FORWARDING_USE", 0)
        
        bsd_use     = MCFGGetParamInteger("CFG_UNET3_BSDWRP_USE", 0)
        if bsd_use == 1 then
            bsd_tcps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_TCPS_NUM", 0)
            bsd_udps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_UDPS_NUM", 0)
            bsd_tsks    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_TSKS_NUM", 0)
        
	        tcp_count   = tcp_count + bsd_tcps
	        udp_count   = udp_count + bsd_udps
	        soc_count   = soc_count + bsd_tcps + bsd_udps
        end
    end

    dynamic_tcp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_TCP_MAX", 0)
    dynamic_udp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_UDP_MAX", 0)
    static_tcp_count = MCFGGetParamInteger("CFG_UNET3_STATIC_TCP_MAX", 0)
    static_udp_count = MCFGGetParamInteger("CFG_UNET3_STATIC_UDP_MAX", 0)

    tcp_count = tcp_count + dynamic_tcp_count
    udp_count = udp_count + dynamic_udp_count
    soc_count = soc_count + dynamic_tcp_count + dynamic_udp_count

    fprintf(fout, "/************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / NETWORK\n")
    fprintf(fout, "    TCP/IP Configuration File\n")
    fprintf(fout, "    \n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " ************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"string.h\"\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"net_hdr.h\"\n")
    if ipv6_use == 1 then
        fprintf(fout, "#include \"net_hdr6.h\"\n")
    end
    fprintf(fout, "#include \"net_eva.h\"\n")
    fprintf(fout, "#include \"kernel_id.h\"\n")
    fprintf(fout, "#include \"net_id.h\"\n")
    if netif_ppp_count() > 0 then
        fprintf(fout, "#include \"ppp_mdm.h\"\n")
        fprintf(fout, "#include \"ppp_hdr.h\"\n")
    end
    if dhcp_count > 0 then
        if use_bootpc > 0 then
            fprintf(fout, "#include \"bootp_client.h\"\n")
        else
            fprintf(fout, "#include \"dhcp_client.h\"\n")
        end
    end
    if httpd_use == 1 then
        fprintf(fout, "#include \"http_server.h\"\n")
    end
    if ftpd_use == 1 and version >= 300 then
        fprintf(fout, "#include \"ftp_server.h\"\n")
    end
    if tftpd_use == 1 and version >= 300 then
        fprintf(fout, "#include \"tftp_server.h\"\n")
    end
    if dhcpd_use == 1 then
        fprintf(fout, "#include \"dhcp_server.h\"\n")
    end
    if sntpd_use == 1 and version >= 300 then
        fprintf(fout, "#include \"sntp_server.h\"\n")
    end
    if telnetd_use == 1 and version >= 300 then
        fprintf(fout, "#include \"telnet_server.h\"\n")
        fprintf(fout, "#include \"shell.h\"\n")
    end
    if snmp_use == 1 and version >= 300 then
        fprintf(fout, "#include \"snmp.h\"\n")
    end
    if ssl_use == 1 then
        fprintf(fout, "#include \"ssl_cfg.h\"\n")
    end
    if bsd_use == 1 then
        fprintf(fout, "#include \"sys/socket.h\"\n")
    end

    fprintf(fout, "\n")
    fprintf(fout, "#ifndef NULL\n")
    fprintf(fout, "#define NULL    ((void*)0)\n")
    fprintf(fout, "#endif\n")

    -- Local stack for Task
    fprintf(fout, "\n")
    fprintf(fout, "/*******************************************\n")
    fprintf(fout, "        Local Stack allocate\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "#ifdef __IAR_SYSTEMS_ICC__\n")
    fprintf(fout, "#pragma section = \"LOCALSTKMEM\"\n")

    if httpd_use == 1 then
        -- HTTPd
        create_tsk_stack( "CFG_UNET3_HTTPD_SESSION", "CFG_UNET3_HTTPD_TSKID", 0 )
    end

    if version >= 300 then
        -- FTPd
        if ftpd_use == 1 then
            create_tsk_stack( "CFG_UNET3_FTPD_SESSION", "CFG_UNET3_FTPD_TSKID", 0 )
        end
        -- DHCPd
        if dhcpd_use == 1 then
            create_tsk_stack( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_TSKID", 0 )
            create_tsk_stack( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_RCV_TSKID", 0 )
        end
        -- TFTPd
        if tftpd_use == 1 then
            create_tsk_stack( "CFG_UNET3_TFTPD_COUNT", "CFG_UNET3_TFTPD_TSKID", 0 )
        end
        -- SNTPd
        if sntpd_use == 1 then
            create_tsk_stack( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 0 )
            local mc_use = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0)
            if mc_use == 1 then
                create_tsk_stack( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 1 )
            end
        end
        -- Telnetd
        if telnetd_use == 1 then
            create_tsk_stack( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 0 )
            create_tsk_stack( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 1 )
        end
    end

    --[[
        Net protocol stack
    --]]
    create_tsk_stack( nil, "CFG_UNET3_KNL_TSKID", 0 )

    --[[
        ppp stack
    --]]
    if netif_ppp_count() > 0 then     -- PPP
        local pi = 0
        -- APPP0̂݃T|[g
        for i = 0, netif_count-1 do
            local dev, num = netif_linktype_ex(i)
            if (dev == "PPP") and (num == "0") then
                pi = i
                break
            end
        end

        create_tsk_stack( nil, "CFG_UNET3_PPP_CTL_TSKID", pi )
        create_tsk_stack( nil, "CFG_UNET3_PPP_TIM_TSKID", pi )
        create_tsk_stack( nil, "CFG_UNET3_PPP_SND_TSKID", pi )
        create_tsk_stack( nil, "CFG_UNET3_PPP_RCV_TSKID", pi )
    end
    fprintf(fout, "#endif\n")

    fprintf(fout, "\n")
    fprintf(fout, "/*******************************************\n")
    fprintf(fout, "        Local Pool Memory allocate\n")
    fprintf(fout, "********************************************/\n")
    -- for IAR
    fprintf(fout, "#ifdef __IAR_SYSTEMS_ICC__\n")
    fprintf(fout, "#pragma section = \"LOCALMPLMEM\"\n")

    -- Œ蒷v[
    fprintf(fout, "/* Fixed-Sized Memory Pool */\n")
    -- HTTPc
    if httpc_use == 1 then
        create_mpf_size( nil, "CFG_UNET3_HTTPC_MPFID", 0 )
    end
    if version >= 300 then
        -- DHCPd
        if dhcpd_use == 1 then
            create_mpf_size( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_MPFID", 0 )
        end
        -- Telnetd
        if telnetd_use == 1 then
            create_mpf_size( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_MPFID", 0 )
        end
    end

    --[[
        Net protocol stackiHW_OSL̏ꍇ͏o͂ȂBRZThCoΉj
    --]]
    if use_hw_os == 0 then
        create_mpf_size( nil, "CFG_UNET3_KNL_MPFID", 0 )
    end
    fprintf(fout, "#endif\n")

    fprintf(fout, "\n")
    fprintf(fout, "/*******************************************\n")
    fprintf(fout, "        Object Creation Information\n")
    fprintf(fout, "********************************************/\n")

    if httpd_use == 1 then
        -- HTTPd Task
        create_tsk( "CFG_UNET3_HTTPD_SESSION", "CFG_UNET3_HTTPD_TSKID", 0 )
    end

    if version >= 300 then
        -- FTPd Task
        if ftpd_use == 1 then
            create_tsk( "CFG_UNET3_FTPD_SESSION", "CFG_UNET3_FTPD_TSKID", 0 )
        end
        -- DHCPd Task
        if dhcpd_use == 1 then
            create_tsk( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_TSKID", 0 )
            create_tsk( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_RCV_TSKID", 0 )
        end
        -- TFTPd Task
        if tftpd_use == 1 then
            create_tsk( "CFG_UNET3_TFTPD_COUNT", "CFG_UNET3_TFTPD_TSKID", 0 )
        end
        -- SNTPd Task
        if sntpd_use == 1 then
            create_tsk( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 0 )
            local mc_use = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0)
            if mc_use == 1 then
                create_tsk( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 1 )
            end
        end
        -- Telnetd Task
        if telnetd_use == 1 then
            create_tsk( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 0 )
            create_tsk( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 1 )
        end
    end

    fprintf(fout, "\n")
    if version >= 300 then
        -- SNTPd Event Flag
        if sntpd_use == 1 then
            create_flg( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_FLGID", 0 )
        end
        -- Telnetd Event Flag
        if telnetd_use == 1 then
            create_flg( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_FLGID", 0 )
        end
    end

    fprintf(fout, "\n")
    if version >= 300 then
        -- DHCPd Mailbox
        if dhcpd_use == 1 then
            create_mbx( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_MBXID", 0 )
        end
        -- Telnetd Mailbox
        if telnetd_use == 1 then
            create_mbx( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_MBXID", 0 )
        end
    end

    fprintf(fout, "\n")
    if httpc_use == 1 then
        -- HTTPc Fixed-Sized Memory Pools
        create_mpf( nil, "CFG_UNET3_HTTPC_MPFID", 0 )
    end

    if version >= 300 then
        if dhcpd_use == 1 then
            -- DHCPd Fixed-Sized Memory Pools
            create_mpf( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_MPFID", 0 )
        end
        if telnetd_use == 1 then
            -- Telnetd Fixed-Sized Memory Pools
            create_mpf( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_MPFID", 0 )
        end
    end

    fprintf(fout, "\n")
    if version >= 300 then
        if sntpd_use == 1 then
            -- SNTPd Interrupt Service Routine
            create_isr( nil, "CFG_UNET3_SNTPD_ISRID", 0 )
        end
    end


    if version < 300 then
        --[[
            uNet3 user configuration
             v3ȍ~ACFG_XXXX̒`net_cfg.hֈړ
        --]]
        fprintf(fout, "\n/*******************************************\n")
        fprintf(fout, "      uNet3 User Configuration \n")
        fprintf(fout, "********************************************/\n")
        fprintf(fout, "\n")
        fprintf(fout, "#define CFG_NET_DEV_MAX         %d\n", netif_count)
        fprintf(fout, "#define CFG_NET_SOC_MAX         %d\n", soc_count)
        fprintf(fout, "#define CFG_NET_TCP_MAX         %d\n", tcp_count)
        fprintf(fout, "#define CFG_NET_ARP_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_ARPMAX", 0))
        fprintf(fout, "#define CFG_NET_MGR_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_MGRMAX", 0))
        fprintf(fout, "#define CFG_NET_IPR_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_IPRMAX", 0))
        fprintf(fout, "#define CFG_NET_BUF_SZ          %d\n", MCFGGetParamInteger("CFG_UNET3_NETBUF_SIZE", 0))
        fprintf(fout, "#define CFG_NET_BUF_OFFSET      DEF_NET_BUF_OFFSET\n")
        fprintf(fout, "#define CFG_PATH_MTU            %d\n", MCFGGetParamInteger("CFG_UNET3_IFMTU_MAX", 0))
        fprintf(fout, "#define CFG_ARP_RET_CNT         %d\n", MCFGGetParamInteger("CFG_UNET3_ARP_RET_CNT", 0))
        fprintf(fout, "#define CFG_ARP_RET_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_ARP_RET_TMO", 0))
        fprintf(fout, "#define CFG_ARP_CLR_TMO         %d*60*1000\n", MCFGGetParamInteger("CFG_UNET3_ARP_CLR_TMO", 0))
        fprintf(fout, "#define CFG_IP4_TTL             %d\n", MCFGGetParamInteger("CFG_UNET3_IP4_TTL", 0))
        fprintf(fout, "#define CFG_IP4_TOS             %d\n", MCFGGetParamInteger("CFG_UNET3_IP4_TOS", 0))
        fprintf(fout, "#define CFG_IP4_IPR_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_IP4_IPR_TMO", 0))
        fprintf(fout, "#define CFG_IP4_MCAST_TTL       DEF_IP4_MCAST_TTL\n")
        fprintf(fout, "#define CFG_IGMP_V1_TMO         DEF_IGMP_V1_TMO\n")
        fprintf(fout, "#define CFG_IGMP_REP_TMO        DEF_IGMP_REP_TMO\n")
        fprintf(fout, "#define CFG_TCP_MSS             (CFG_PATH_MTU-40)\n")
        fprintf(fout, "#define CFG_TCP_MSS_IPV6        (CFG_PATH_MTU-60)\n")
        fprintf(fout, "#define CFG_TCP_RTO_INI         DEF_TCP_RTO_INI\n")
        fprintf(fout, "#define CFG_TCP_RTO_MIN         DEF_TCP_RTO_MIN\n")
        fprintf(fout, "#define CFG_TCP_RTO_MAX         DEF_TCP_RTO_MAX\n")
        fprintf(fout, "#define CFG_TCP_SND_WND         DEF_TCP_SND_WND\n")
        fprintf(fout, "#define CFG_TCP_RCV_WND         DEF_TCP_RCV_WND\n")
        fprintf(fout, "#define CFG_TCP_DUP_CNT         DEF_TCP_DUP_CNT\n")
        fprintf(fout, "#define CFG_TCP_CON_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_CON_TMO", 0))
        fprintf(fout, "#define CFG_TCP_SND_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_SND_TMO", 0))
        fprintf(fout, "#define CFG_TCP_CLS_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_CLS_TMO", 0))
        fprintf(fout, "#define CFG_TCP_CLW_TMO         DEF_TCP_CLW_TMO\n")
        fprintf(fout, "#define CFG_TCP_ACK_TMO         DEF_TCP_ACK_TMO\n")
        fprintf(fout, "#ifdef KEEPALIVE_SUP\n")
        fprintf(fout, "#define CFG_TCP_KPA_CNT         %d\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_CNT", 0))
        fprintf(fout, "#define CFG_TCP_KPA_INT         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_INT", 0))
        fprintf(fout, "#define CFG_TCP_KPA_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_TMO", 0))
        fprintf(fout, "#endif\n")
        fprintf(fout, "#define CFG_PKT_RCV_QUE         %d\n", MCFGGetParamInteger("CFG_UNET3_PKT_RCV_QUE", 0))
        -- CFG_UNET3_PKT_UNREACH:           Bit 0
        -- CFG_UNET3_IP4_IGNORE_CHECKSUM:   Bit 1
        -- CFG_UNET3_TCP_IGNORE_CHECKSUM:   Bit 2
        -- CFG_UNET3_UDP_IGNORE_CHECKSUM:   Bit 3
        local ctlflg = 0
        val0 = MCFGGetParamInteger("CFG_UNET3_PKT_UNREACH", 0)
        val1 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_IP4_IGNORE_CHECKSUM", 0), 1)
        val2 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_TCP_IGNORE_CHECKSUM", 0), 2)
        val3 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_UDP_IGNORE_CHECKSUM", 0), 3)
        ctlflg = bit.bor(val0, val1)
        ctlflg = bit.bor(ctlflg, val2)
        ctlflg = bit.bor(ctlflg, val3)
        fprintf(fout, "#define CFG_PKT_CTL_FLG         0x%04x\n", ctlflg)
        fprintf(fout, "#ifdef ACD_SUP\n")
        fprintf(fout, "#define CFG_ARP_PRB_WAI         DEF_ARP_PRB_WAI\n")
        fprintf(fout, "#define CFG_ARP_PRB_NUM         DEF_ARP_PRB_NUM\n")
        fprintf(fout, "#define CFG_ARP_PRB_MIN         DEF_ARP_PRB_MIN\n")
        fprintf(fout, "#define CFG_ARP_PRB_MAX         DEF_ARP_PRB_MAX\n")
        fprintf(fout, "#define CFG_ARP_ANC_WAI         DEF_ARP_ANC_WAI\n")
        fprintf(fout, "#define CFG_ARP_ANC_NUM         DEF_ARP_ANC_NUM\n")
        fprintf(fout, "#define CFG_ARP_ANC_INT         DEF_ARP_ANC_INT\n")
        fprintf(fout, "#endif\n")
        if ipv6_use == 1 then
            fprintf(fout, "#define CFG_NET6_BUF_SZ         DEF_NET6_BUF_SZ\n")
            fprintf(fout, "#define CFG_NEIGH_CACHE         %d\n", MCFGGetParamInteger("CFG_UNET3_NEIGH_CACHE", 0))
            fprintf(fout, "#define CFG_DST_CACHE           %d\n", MCFGGetParamInteger("CFG_UNET3_DST_CACHE", 0))
            fprintf(fout, "#define CFG_RTR_LST             %d\n", MCFGGetParamInteger("CFG_UNET3_RTR_LST", 0))
            fprintf(fout, "#define CFG_PRFX_LST            %d\n", MCFGGetParamInteger("CFG_UNET3_PRFX_LST", 0))
            fprintf(fout, "#define CFG_PMTU_CACHE          %d\n", MCFGGetParamInteger("CFG_UNET3_PMTU_CACHE", 0))
        end
    end
    
    fprintf(fout, "\n/*******************************************\n")
    fprintf(fout, "       uNet3 Resources\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "\n")
    cfg_tcp_count   = MCFGGetParamInteger("CFG_UNET3_SOC_TCP_COUNT", 0)
    cfg_dynamic_tcp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_TCP_MAX", 0)
    cfg_dynamic_udp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_UDP_MAX", 0)
    cfg_soc_count   = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)

    cfg_tcp_count = cfg_tcp_count + cfg_dynamic_tcp_count
    cfg_soc_count = cfg_soc_count + cfg_dynamic_tcp_count + cfg_dynamic_udp_count

    fprintf(fout, "#define CFG_TCP_SND_WND         %d\n", MCFGGetParamInteger("CFG_UNET3_SOC_DEFAULT_SNDBUF", 0))
    fprintf(fout, "#define CFG_NET_DYNAMIC_TCP_MAX %d\n", cfg_dynamic_tcp_count)
    fprintf(fout, "#define CFG_NET_SOC_MAX         %d\n", cfg_soc_count)
    fprintf(fout, "#define CFG_NET_TCP_MAX         %d\n", cfg_tcp_count)
    fprintf(fout, "\n")
    fprintf(fout, "UW NET_SOC_MAX      = CFG_NET_SOC_MAX;  /* Maximum Number of Sockets          */\n")
    fprintf(fout, "UW NET_TCP_MAX      = CFG_NET_TCP_MAX;  /* Maximum Number of TCP Sockets      */\n")
    if ipv6_use == 1 then
        fprintf(fout, "UW NET6_BUF_SZ      = CFG_NET6_BUF_SZ;\n")
        fprintf(fout, "UW NET_NEIGH_CACHE  = CFG_NEIGH_CACHE;\n")
        fprintf(fout, "UW NET_DST_CACHE    = CFG_DST_CACHE;\n")
        fprintf(fout, "UW NET_RTR_LST      = CFG_RTR_LST;\n")
        fprintf(fout, "UW NET_PRFX_LST     = CFG_PRFX_LST;\n")
        fprintf(fout, "UW NET_PMTU_CACHE   = CFG_PMTU_CACHE;\n")
    end
    fprintf(fout, "\n/*******************************************\n")
    fprintf(fout, "      Define TCP Resources\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "\n")
    if soc_count > 0 then
        fprintf(fout, "T_NET_SOC gNET_SOC[CFG_NET_SOC_MAX];/* Socket control block */\n")
    end
    if tcp_count > 0 then
        fprintf(fout, "T_NET_TCP gNET_TCP[CFG_NET_TCP_MAX];/* TCP control block */\n")
        tcp_sndbuf_total = MCFGGetParamInteger("CFG_UNET3_SOC_TCP_SNDBUF_TOTAL", 0)
        dynamic_tcp_defsndbuf = MCFGGetParamInteger("CFG_UNET3_SOC_DEFAULT_SNDBUF", 0)
        if (tcp_sndbuf_total + bsd_tcps + (dynamic_tcp_defsndbuf * dynamic_tcp_count)) > 0 then   -- uNet3 tcp or bsd tcp 
            local sbufsz = ""
            if (tcp_sndbuf_total > 0) then
                tcp_sndbuf_total = tcp_sndbuf_total + (dynamic_tcp_defsndbuf * dynamic_tcp_count)
                sbufsz = sbufsz .. "" .. tcp_sndbuf_total
                -- Std̓I\PbgpɑMobt@mۂKv
                if (sbufsz ~= "") then
                    sbufsz = sbufsz .. " + "
                end
                sbufsz = sbufsz .. "CFG_TCP_SND_WND * CFG_NET_DYNAMIC_TCP_MAX"
            end
            -- BSD\PbgpɑMobt@mۂKv
            if (bsd_tcps > 0) then
                if (sbufsz ~= "") then
                    sbufsz = sbufsz .. " + "
                end
                sbufsz = sbufsz .. "CFG_BSD_TCP_SBUFSZ * CFG_BSD_TCP_MAX"
            end
        
            fprintf(fout, "UB        gTCP_SND_BUF[%s];       /* TCP Tx Buffer */\n", sbufsz)
        end
    end
    if ipv6_use == 1 then
        fprintf(fout, "T_NEIGH_CACHE gNEIGHBOR_CACHE[CFG_NEIGH_CACHE]; /* Neighbor Cache */\n")
        fprintf(fout, "T_DST_CACHE   gDEST_CACHE[CFG_DST_CACHE];       /* Destination Cache */\n")
        fprintf(fout, "T_RTR_LST     gRTR_LST[CFG_RTR_LST];            /* Router Cache */\n")
        fprintf(fout, "T_PREFIX_LST  gPRFX_LST[CFG_PRFX_LST];          /* Prefix Cache */\n")
        fprintf(fout, "PMTU_CACHE    gPMTU_CACHE[CFG_PMTU_CACHE];      /* Path MTU Cache */\n")
    end

    --[[
        Define Socket ID
    --]]
    if snmp_use == 1 then
        -- ̃\Pbg̓lbgAṽ\[Xcre_socĂiʏj
        snmp_socid = MCFGGetParamString("CFG_UNET3_SNMP_SOCID", 0)
        snmp_socid_trp = MCFGGetParamString("CFG_UNET3_SNMP_SOCID", 1)
    end
    
    if soc_count > 0 then
        fprintf(fout, "\n/*******************************\n")
        fprintf(fout, "    Socket Table\n")
        fprintf(fout, "********************************/\n")
        fprintf(fout, "\n")
        fprintf(fout, "T_SOC_TABLE const gSOC_TABLE[] = {\n")
        -- soc_countɂBSD\PbgƓI\Pbg̐܂܂邽ߊԈ
        for i = 0, soc_count-1-((bsd_tcps + bsd_udps) + (dynamic_tcp_count + dynamic_udp_count)) do
            if snmp_use == 1 then
                socid = MCFGGetParamString( "CFG_UNET3_SOCID", i )
                if socid ~= snmp_socid and socid ~= snmp_socid_trp then
                    fprintf(fout, "    { 0, ")                                              -- IDiStdł͖gp̂ߑS0j
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i))     -- Protocol
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOCPORT", i))      -- port
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_SNDTMO", i))   -- send timeout
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_RCVTMO", i))   -- recv timeout
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_CONTMO", i))   -- connection timeout
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_CLSTMO", i))   -- close timeout
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_SNDBUF", i))   -- send buffer size
                    fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_RCVBUF", i))   -- recv buffer size
                    -- Network Interface
                    bindif = MCFGGetParamString("CFG_UNET3_SOC_BINDIF", i)
                    if bindif ~= "" then
                        fprintf(fout, "%s, ", bindif)
                    else 
                        fprintf(fout, "0, ")
                    end
                    -- IP version(0:IPv4, 1:IPv6)
                    if MCFGGetParamInteger("CFG_UNET3_SOC_IPVER", i) == 0 then
                        fprintf(fout, "IP_VER4},\n") 
                    else
                        fprintf(fout, "IP_VER6},\n") 
                    end
                end
            else
                fprintf(fout, "    { 0, ")                                              -- IDiStdł͖gp̂ߑS0j
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i))     -- Protocol
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOCPORT", i))      -- port
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_SNDTMO", i))   -- send timeout
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_RCVTMO", i))   -- recv timeout
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_CONTMO", i))   -- connection timeout
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_CLSTMO", i))   -- close timeout
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_SNDBUF", i))   -- send buffer size
                fprintf(fout, "%d, ", MCFGGetParamInteger("CFG_UNET3_SOC_RCVBUF", i))   -- recv buffer size
                -- Network Interface
                bindif = MCFGGetParamString("CFG_UNET3_SOC_BINDIF", i)
                if bindif ~= "" then
                    fprintf(fout, "%s, ", bindif)
                else 
                    fprintf(fout, "0, ")
                end
                -- IP version(0:IPv4, 1:IPv6)
                if MCFGGetParamInteger("CFG_UNET3_SOC_IPVER", i) == 0 then
                    fprintf(fout, "IP_VER4},\n") 
                else
                    fprintf(fout, "IP_VER6},\n") 
                end
            end
        end
        fprintf(fout, "    0\n")    -- I[p(BSDCup)
        fprintf(fout, "};\n")
    end
    
    --[[
        RAW Socket Filter
    --]]
    if (1 == raw_use) and (soc_count > 0) then
        fprintf(fout, "\n/*******************************\n")
        fprintf(fout, "    RAW socket Ethernet Type\n")
        fprintf(fout, "********************************/\n")
        fprintf(fout, "\n")
        for i = 0, netif_count-1 do
            local mn = soc_count
            local ifid = MCFGGetParamString("CFG_UNET3_IFID", i)
            for n = 0, soc_count-1 do
                bindif = MCFGGetParamString("CFG_UNET3_SOC_BINDIF", n)
                
                if (bindif == ifid) and (255 == MCFGGetParamInteger("CFG_UNET3_SOCPROTO", n)) then
                    mn = n
                    break
                end
            end
            if mn ~= soc_count then
                local raw_et_num = MCFGGetParamInteger("CFG_UNET3_ETYPE_NUM", mn)
                fprintf(fout, "static UH rawtype_nic%d[] = {\n", i)
                for k = 0, raw_et_num-1 do
                    fprintf(fout, "  %d, \n", MCFGGetParamInteger("CFG_UNET3_ETYPE_NO"..(k+1), mn))
                end
                fprintf(fout, "  0\n};\n")
            else
                fprintf(fout, "static UH rawtype_nic%d[1] = {0}; ", i)
            end
        end
        
        fprintf(fout, "\n")
        fprintf(fout, "UH *gNET_RAWTYPE[] = {\n")
        for i = 0, netif_count-1 do
            fprintf(fout, " rawtype_nic%d", i)
            fprintf(fout, "%s", (i == (netif_count-1)) and ",\n" or "\n")
        end
        fprintf(fout, "};\n")
    end    

    --[[
        IP ADDRESS
    --]]
    use_addr_conv = MCFGGetParamInteger("CFG_UNET3_FORWARDING_NAT_CONVERT", 0)

    fprintf(fout, "\n/*******************************\n")
    fprintf(fout, "    Define Local IP Address\n")
    fprintf(fout, "********************************/\n")
    fprintf(fout, "\n")
    -- IPv4 address
    if netif_count == 0 then
        fprintf(fout, "T_NET_ADR gNET_ADR[1] = {0};\n")
    else
        -- C^tF[XJԂ
        fprintf(fout, "T_NET_ADR gNET_ADR[] = {\n")
        for i = 0, netif_count-1 do
            local ifid = MCFGGetParamString("CFG_UNET3_IFID", i)
            local gdev = MCFGGetParamString("CFG_UNET3_FORWARDING_GLOBAL_DEVICE", 0)
            if forwarding_use == 1 and use_addr_conv == 1 and ifid == gdev then
                fprintf(fout, "    {0x0, 0x1, ")
            else
                fprintf(fout, "    {0x0, 0x0, ")
            end

            if netif_linktype(i) == "PPP" then
                fprintf(fout, "0x0, 0x0, 0x0},\n")
            else
                fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_IF_IPADDR", i))
                fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_IF_GATEWAY", i))
                fprintf(fout, "%s}, \n", MCFGGetParamString("CFG_UNET3_IF_SUBNET", i))
            end
        end
        fprintf(fout, "};\n")
    end

    -- IPv6 address
    if ipv6_use == 1 then
        fprintf(fout, "\n")
        fprintf(fout, "UB ip6_manual = FALSE;\n")
        fprintf(fout, "UW ip6_rtr_manual[]= {0x0, 0x0, 0x0, 0x0};\n")
        fprintf(fout, "UW ip6_host_manual[]= {0x0, 0x0, 0x0, 0x0};\n")
        fprintf(fout, "UB pref_len_manual = 64;\n")
        netif_ip6 = netif_linktype_count("Ethernet") + netif_linktype_count("Loopback")
        if netif_ip6 == 0 then
            fprintf(fout, "\n")
            fprintf(fout, "T_NET6_ADR gNET6_ADR[1] = {0};\n")
            fprintf(fout, "UB ip6_manual_m[1] = {FALSE};\n")
            fprintf(fout, "UW ip6_rtr_manual_m[1][4]= {{0x0, 0x0, 0x0, 0x0}};\n")
            fprintf(fout, "UW ip6_host_manual_m[1][4]= {{0x0, 0x0, 0x0, 0x0}};\n")
            fprintf(fout, "UB pref_len_manual_m[1] = {64};\n")
         else
            fprintf(fout, "\n")
            fprintf(fout, "T_NET6_ADR gNET6_ADR[%d] = {0};\n", netif_ip6)
            fprintf(fout, "UB ip6_manual_m[] = {\n")
            for i = 0, netif_count-1 do
                if netif_linktype(i) ~= "PPP" then
                    if MCFGGetParamInteger("CFG_UNET3_IF_IP6_STATIC", i) == 1 then
                        fprintf(fout, "    TRUE,\n")
                    else
                        fprintf(fout, "    FALSE,\n")
                    end
                end
            end
            fprintf(fout, "};\n")
            fprintf(fout, "UW ip6_rtr_manual_m[][4]= {\n")
            for i = 0, netif_count-1 do
                if netif_linktype(i) ~= "PPP" then
                    if MCFGGetParamInteger("CFG_UNET3_IF_IP6_STATIC", i) == 1 then
                        fprintf(fout, "    {%s, %s, %s, %s},\n", 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ROUTER_0", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ROUTER_1", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ROUTER_2", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ROUTER_3", i))
                    else
                        fprintf(fout, "    {0x0, 0x0, 0x0, 0x0},\n")
                    end
                end
            end
            fprintf(fout, "};\n")
            fprintf(fout, "UW ip6_host_manual_m[][4]= {\n")
            for i = 0, netif_count-1 do
                if netif_linktype(i) ~= "PPP" then
                    if MCFGGetParamInteger("CFG_UNET3_IF_IP6_STATIC", i) == 1 then
                        fprintf(fout, "    {%s, %s, %s, %s},\n", 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ADDR_0", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ADDR_1", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ADDR_2", i), 
                                                            MCFGGetParamString("CFG_UNET3_IF_IP6_ADDR_3", i))
                    else
                        fprintf(fout, "    {0x0, 0x0, 0x0, 0x0},\n")
                    end
                end
            end
            fprintf(fout, "};\n")
            fprintf(fout, "UB pref_len_manual_m[] = {\n")
            for i = 0, netif_count-1 do
                if netif_linktype(i) ~= "PPP" then
                    fprintf(fout, "    %d,\n", MCFGGetParamInteger("CFG_UNET3_IF_IP6_PREFIXLEN", i))
                end
            end
            fprintf(fout, "};\n")
        end
    end

    --[[
        Device Forwarding
    --]]
    if forwarding_use == 1 then
        fprintf(fout, "\n/*******************************************\n")
        fprintf(fout, "     Define Forwarding Information\n")
        fprintf(fout, "********************************************/\n")
        fprintf(fout, "\n")

        --[[
        [eBO@\ڊǂɔp~
        local rte_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_RTE_COUNT", 0)
        --]]
        local nat_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_NATTBL_SIZE", 0)
        local flt_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_FLTTBL_SIZE", 0)

        if use_addr_conv == 0 then
            nat_num = 0
            flt_num = 0
        end

        --[[
        [eBO@\ڊǂɔp~
        if rte_num ~= 0 then
            fprintf(fout, "T_NET_RTE gNET_RTE[CFG_RTE_NUM] = {\n")
            for i = 0, rte_num - 1 do
                fprintf(fout, "    { %s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_RTE_IPADDR", i))
                fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_RTE_SUBNET", i))
                fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_RTE_GATEWAY", i))
                fprintf(fout, "%s },\n", MCFGGetParamString("CFG_UNET3_FORWARDING_RTE_DEVICE", i))
            end
            fprintf(fout, "};\n")
        end
        --]]

        if nat_num ~= 0 then
            fprintf(fout, "T_NET_NAT gNET_NAT[CFG_NAT_NUM];\n")
        end

        if flt_num ~= 0 then
            local net_flt_count = MCFGGetParamInteger("CFG_UNET3_FORWARDING_FLT_COUNT", 0)

            if net_flt_count ~= 0 then
                fprintf(fout, "T_NET_FLT gNET_FLT[CFG_FLT_NUM] = {\n")
                for i = 0, net_flt_count - 1 do
                    fprintf(fout, "    { 0, ")
                    fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_FLT_FWIP", i))
                    fprintf(fout, "0, ")
                    fprintf(fout, "0, ")
                    if MCFGGetParamInteger("CFG_UNET3_FORWARDING_FLT_UNSET", i) == 1 then
                        fprintf(fout, "0, 0, ")
                    elseif MCFGGetParamInteger("CFG_UNET3_FORWARDING_FLT_ICMP", i) == 1 then
                        fprintf(fout, "%s, 0, ", MCFGGetParamString("CFG_UNET3_FORWARDING_FLT_TYPE", i))
                    else
                        fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_FLT_DSTPORT", i))
                        fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_FLT_FWPORT", i))
                    end
                    fprintf(fout, "%s, ", MCFGGetParamString("CFG_UNET3_FORWARDING_FLT_PROTO", i))
                    fprintf(fout, "%s },\n", MCFGGetParamString("CFG_UNET3_FORWARDING_GLOBAL_DEVICE", 0))
                end
                fprintf(fout, "};\n")
            else
                fprintf(fout, "T_NET_FLT gNET_FLT[CFG_FLT_NUM];\n")
            end
        end
        fprintf(fout, "\n")

        fprintf(fout, "const VP gwy_inftbl[] = {\n")
        if rte_num == 0 then
            fprintf(fout, "    (VP)0,                  /* Routing table                                 */\n")
        else
            --[[
            [eBO@\ڊǂɔp~
            fprintf(fout, "    (VP)gNET_RTE,           /* Routing table                                 */\n")
            --]]
            fprintf(fout, "    (VP)0,                  /* Routing table                                 */\n")
        end
        if nat_num == 0 then
            fprintf(fout, "    (VP)0,                  /* NAT table                                     */\n")
        else
            fprintf(fout, "    (VP)gNET_NAT,           /* NAT table                                     */\n")
        end
        if flt_num == 0 then
            fprintf(fout, "    (VP)0,                  /* Filter table                                  */\n")
        else
            fprintf(fout, "    (VP)gNET_FLT,           /* Filter table                                  */\n")
        end
        fprintf(fout, "    (VP)CFG_NAT_TCP_TTL,    /* Life time TCP                                 */\n")
        fprintf(fout, "    (VP)CFG_NAT_UDP_TTL,    /* Life time UDP                                 */\n")
        fprintf(fout, "    (VP)CFG_NAT_ICMP_TTL,   /* Life time ICMP                                */\n")
        fprintf(fout, "    (VP)CFG_RTE_NUM,        /* Routing table size                            */\n")
        fprintf(fout, "    (VP)CFG_NAT_NUM,        /* NAT table size                                */\n")
        fprintf(fout, "    (VP)CFG_FLT_NUM,        /* Filter table size                             */\n")
        if use_addr_conv == 0 then
            fprintf(fout, "    (VP)0                   /* TCP monitoring                                */\n")
        else
            fprintf(fout, "    (VP)%d                   /* TCP monitoring                                */\n",
                    MCFGGetParamInteger("CFG_UNET3_FORWARDING_SESSION_WATCH", 0))
        end
        fprintf(fout, "};\n")
        fprintf(fout, "\n")
    end

    --[[
        TCP/IP Globals
    --]]
    fprintf(fout, "\n/*******************************************\n")
    fprintf(fout, "      Initialize TCP/IP Globals\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_IP4_LOOPBACK", 0) ~= 0 then
    --[[
    p~ip4_loopɒu
    if bsd_use == 1 then
        fprintf(fout, "extern ER lo_net_snd(UH dev_num, T_NET_BUF* pkt);\n")
    --]]
        fprintf(fout, "extern ER ip4_loop(T_NET_BUF* pkt);\n")
    end
    fprintf(fout, "const VP net_inftbl[] = {\n")
    if soc_count == 0 then
        fprintf(fout, "0,0,0,\n")
    else
        fprintf(fout, "0,\n")
        fprintf(fout, "(VP)gNET_SOC,\n")
        if tcp_count == 0 then
            fprintf(fout, "0,\n")
        else
            fprintf(fout, "(VP)gNET_TCP,\n")
        end
    end
    fprintf(fout, "0,\n")
    fprintf(fout, "0,\n")
    if (MCFGGetParamInteger("CFG_UNET3_SOC_TCP_SNDBUF_TOTAL", 0) + bsd_tcps) > 0 then
        fprintf(fout, "(VP)gTCP_SND_BUF,\n")
    else
        fprintf(fout, "0,\n")
    end
    if version >= 300 then      -- ver3n̂ݗLȃp[^
        if MCFGGetParamInteger("CFG_UNET3_IP4_LOOPBACK", 0) ~= 0 then
        --[[
        p~ip4_loopɒu
        if bsd_use == 1 then
            fprintf(fout, "(VP)lo_net_snd,\n")
        --]]
            fprintf(fout, "(VP)ip4_loop,\n")
        else 
            fprintf(fout, "0,\n")
        end
        if forwarding_use == 0 then
            fprintf(fout, "0\n")
        else
            fprintf(fout, "(VP)gwy_inftbl\n")
        end
    end
    fprintf(fout, "};\n")

    --[[
        ID
    --]]
    fprintf(fout, "\n/*******************************************\n")
    fprintf(fout, "     Define TCP/IP Kernel resource\n")
    fprintf(fout, "********************************************/\n")
    fprintf(fout, "\n")
    -- uNet3 Common resources
    --[[
        Defined c_net_tsk
    --]]
    create_tsk_for_fixed_name( "c_net_tsk", "CFG_UNET3_KNL_TSKID", 0 )

    --[[
        Defined c_net_mpfiHW_OSL̏ꍇ͏o͂ȂBRZThCoΉj
    --]]
    if use_hw_os == 0 then
        create_mpf_for_fixed_name( "c_net_mpf", "CFG_UNET3_KNL_MPFID", 0 )
    end

    --[[
        Defined c_net_sem
    --]]
    create_sem_for_fixed_name( "c_net_sem", "CFG_UNET3_KNL_SEMID", 0 )

    --[[
        Only PPP resources
    --]]
    if netif_ppp_count() > 0 then     -- PPP
        local pi = 0
        -- APPP0̂݃T|[g
        for i = 0, netif_count-1 do
            local dev, num = netif_linktype_ex(i)
            if (dev == "PPP") and (num == "0") then
                pi = i
                break
            end
        end

        fprintf(fout, "\n")
        -- ppp task
        create_tsk_for_fixed_name( "c_ppp_ctl_tsk", "CFG_UNET3_PPP_CTL_TSKID", pi )
        create_tsk_for_fixed_name( "c_ppp_tim_tsk", "CFG_UNET3_PPP_TIM_TSKID", pi )

        -- ppp event flag
        create_flg_for_fixed_name( "c_ppp_flg", "CFG_UNET3_PPP_FLGID", pi )

        -- ppp semaphore
        create_sem_for_fixed_name( "c_ppp_sem", "CFG_UNET3_PPP_SEMID", pi )

        fprintf(fout, "\n")
        -- ppp task
        create_tsk_for_fixed_name( "c_ppp_dev_snd_tsk", "CFG_UNET3_PPP_SND_TSKID", pi )
        create_tsk_for_fixed_name( "c_ppp_dev_rcv_tsk", "CFG_UNET3_PPP_RCV_TSKID", pi )

        -- ppp mailbox
        create_mbx_for_fixed_name( "c_ppp_dev_snd_mbx", "CFG_UNET3_PPP_SND_MBXID", pi )
        create_mbx_for_fixed_name( "c_ppp_dev_rcv_mbx", "CFG_UNET3_PPP_RCV_MBXID", pi )
    end

    fprintf(fout, "\n")
    fprintf(fout, "/*******************************\n")
    fprintf(fout, "     Memory function\n")
    fprintf(fout, " *******************************/\n")
    if version >= 300 then
        fprintf(fout, "void* net_memset(void *d, int c, SIZE n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMSET_\n")
        fprintf(fout, "    return _kernel_memset(d, c, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memset(d, c, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "void* net_memcpy(void *d, const void *s, SIZE n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMCPY_\n")
        fprintf(fout, "    return _kernel_memcpy(d, s, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memcpy(d, s, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "int net_memcmp(const void *d, const void *s, SIZE n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMCMP_\n")
        fprintf(fout, "    return _kernel_memcmp(d, s, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memcmp(d, s, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
    else
        fprintf(fout, "VP net_memset(VP d, int c, UINT n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMSET_\n")
        fprintf(fout, "    return _kernel_memset(d, c, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memset(d, c, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "VP net_memcpy(VP d, VP s, UINT n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMCPY_\n")
        fprintf(fout, "    return _kernel_memcpy(d, s, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memcpy(d, s, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "int net_memcmp(VP d, VP s, UINT n)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "#ifdef _KERNEL_MEMCMP_\n")
        fprintf(fout, "    return _kernel_memcmp(d, s, n);\n")
        fprintf(fout, "#else\n")
        fprintf(fout, "    return memcmp(d, s, n);\n")
        fprintf(fout, "#endif\n")
        fprintf(fout, "}\n")
    end
    fprintf(fout, "\n")
    
    if bsd_use == 1 then
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "     uNet3/BSD resources\n")
        fprintf(fout, " *******************************/\n")
        fprintf(fout, "/* uNet3/BSD resources */\n")
        fprintf(fout, "T_UNET3_BSD_SOC    gNET_BSD_SOC[BSD_SOCKET_MAX];\n")
        fprintf(fout, "UW tsk_errno[NUM_OF_TASK_ERRNO];\n")
        fprintf(fout, "UW BSD_TCP_SBUFSZ = CFG_BSD_TCP_SBUFSZ;\n")
        fprintf(fout, "UW BSD_TCP_RBUFSZ = CFG_BSD_TCP_RBUFSZ;\n")
        fprintf(fout, "\n")
    end

    --[[
        HTTP CONTETS
    --]]
    local res_cnt = 1
    if httpd_use == 1 then
        local content_cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0)
        if content_cnt > 0 then
            fprintf(fout, "\n")
            fprintf(fout, "/*******************************\n")
            fprintf(fout, "     HTTP Contents\n")
            fprintf(fout, " *******************************/\n")
            for i = 0, content_cnt-1 do
                if MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_TYPE", i) ~= "cgi" then
                    res_name = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i)
                    if is_uniq_resource(res_name, i) == true then
                        local fhs, estr, ecode = io.open(res_name, "rb")
                        fprintf(fout, "const char %s[] = {\n", filename2variable(res_name, res_cnt))
                        res_cnt = res_cnt + 1
                        bytecnt = 0
                        while true do
                            b = fhs:read(1)
                            if b == nil then
                                break
                            end
                            -- read\bȟʂ́AƂ݂Ȃ̂ŁA
                            -- oCgƂĈƂ̓rgC֐string.byte()gĐlɕϊ܂B
                            bytetbl(string.byte(b), bytecnt) 
                            bytecnt = bytecnt + 1
                        end
                        fhs:close()
                        fprintf(fout, "\n};\n\n")
                    end
                end
            end
        end
        --[[
        -- CGI Script extern defnition
        --]]
        if MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_CGI_COUNT", 0) > 0 then
            fprintf(fout, "/*******************************\n")
            fprintf(fout, "        CGI Script definition\n")
            fprintf(fout, " *******************************/\n")
            local cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0)
            for i = 0, cnt-1 do
                if MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_TYPE", i) == "cgi" then
                    func = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i)
                    if is_uniq_resource(func, i) == true then
                        fprintf(fout, "extern void %s(T_HTTP_SERVER *http);\n", func)
                    end
                end
            end
        end
        --[[
        -- HTTPd User Extension Callback defnition
        --]]
        if httpd_ext_use == 1 then
            fprintf(fout, "/*******************************\n")
            fprintf(fout, "    User Extension defnition\n")
            fprintf(fout, " *******************************/\n")
            if httpd_ext_cbk ~= "" then
                fprintf(fout, "extern ER %s(T_HTTP_SERVER *http, const T_HTTP_FILE *fp, UB evt);\n", httpd_ext_cbk)
            else
                fprintf(fout, "\n")
            end
        end
        --[[
            HTTP CONTETS LIST
        --]]
        if MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0) > 0 then
            fprintf(fout, "\n")
            fprintf(fout, "/*******************************\n")
            fprintf(fout, "    HTTP Content List\n")
            fprintf(fout, " *******************************/\n")
            fprintf(fout, "T_HTTP_FILE const content_list[] =\n")
            fprintf(fout, "{\n")
            local cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0)
            for i = 0, (cnt-1) do
                local typ = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_TYPE", i)
                local url = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_URL", i)
                local res = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i)
                if typ == "cgi" then
                    fprintf(fout, "    {\"%s\", \"\", NULL, 0, %s", url, res)
                else
                    var = resource_hash[res]
                    fprintf(fout, "    {\"%s\", \"%s\", %s, sizeof(%s), NULL", url, typ, var, var)
                end
                if httpd_ext_use > 0 then     -- HTTPdg@\L
                    local ext = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_EXT", i)
                    fprintf(fout, ", %d", ext)
                end
                fprintf(fout, "},\n")
            end
            fprintf(fout, "    {\"\", NULL, NULL, 0, NULL}\n")
            fprintf(fout, "};\n")
        end
    end

    --[[
        PPP function
    --]]
    if netif_ppp_count() > 0 then     -- PPP
        local pi = 0
        -- APPP0̂݃T|[g
        for i = 0, netif_count-1 do
            local dev, num = netif_linktype_ex(i)
            if (dev == "PPP") and (num == "0") then
                pi = i
                break
            end
        end

        local ppp_username      = MCFGGetParamString("CFG_UNET3_PPP_USERNAME", pi)
        local ppp_password      = MCFGGetParamString("CFG_UNET3_PPP_PASSWORD", pi)
        local ppp_dial          = MCFGGetParamString("CFG_UNET3_PPP_DIAL", pi)
        local ppp_auto_ip       = MCFGGetParamInteger("CFG_UNET3_PPP_AUTO_IP", pi)
        local ppp_ip_local      = MCFGGetParamString("CFG_UNET3_PPP_IP_LOCAL", pi)
        local ppp_ip_remote     = MCFGGetParamString("CFG_UNET3_PPP_IP_REMOTE", pi)
        local ppp_auto_dns      = MCFGGetParamInteger("CFG_UNET3_PPP_AUTO_DNS", pi)
        local ppp_dns_primary   = MCFGGetParamString("CFG_UNET3_PPP_DNS_PRIMARY", pi)
        local ppp_dns_secondary = MCFGGetParamString("CFG_UNET3_PPP_DNS_SECONDARY", pi)
        local ppp_auth_proto    = MCFGGetParamInteger("CFG_UNET3_PPP_AUTH_PROTO", pi)
        local ppp_vj_compress   = MCFGGetParamInteger("CFG_UNET3_PPP_VJ_COMPRESS", pi)
        local ppp_vj_slots      = MCFGGetParamInteger("CFG_UNET3_PPP_VJ_SLOTS", pi)
        local ppp_retry_cnt     = MCFGGetParamInteger("CFG_UNET3_PPP_RETRY_CNT", pi)
        local ppp_retry_interval= MCFGGetParamInteger("CFG_UNET3_PPP_RETRY_INTERVAL", pi)
        
        fprintf(fout, "\n")
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "    PPP functions templatet\n")
        fprintf(fout, " *******************************/\n")
        fprintf(fout, "ER ppp_setup(T_PPP *ppp)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "    ER ercd = E_OK;\n")
        fprintf(fout, "\n")
        fprintf(fout, "    /* Initialize Modem Driver */\n")
        fprintf(fout, "    ercd = mdm_ini();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
        fprintf(fout, "    /* Configure PPP connection */\n")
        fprintf(fout, "    memset((char *)ppp, 0, sizeof(T_PPP));\n")
        fprintf(fout, "\n")
        
        if ppp_auto_dns == 0 then   -- auto
            if ppp_vj_compress == 0 then
                fprintf(fout, "    ppp->host.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_IP_PDNS | OPT_IP_SDNS | OPT_IP_VJ;\n")
            else
                fprintf(fout, "    ppp->host.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_IP_PDNS | OPT_IP_SDNS;\n")
            end
        else
            if ppp_vj_compress == 0 then
                fprintf(fout, "    ppp->host.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_IP_VJ;\n")
            else
                fprintf(fout, "    ppp->host.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM;\n")
            end
        end
        fprintf(fout, "    ppp->host.accm = 0xFFFFFFFF;\n")
        if ppp_auth_proto == 2 then
            if ppp_vj_compress == 0 then
                fprintf(fout, "    ppp->peer.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_IP_VJ;\n")
            else
                fprintf(fout, "    ppp->peer.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM;\n")
            end
        else
        if ppp_vj_compress == 0 then
            fprintf(fout, "    ppp->peer.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_AUTH | OPT_IP_VJ;\n")
        else
            fprintf(fout, "    ppp->peer.opt  = OPT_PFC | OPT_ACFC | OPT_ACCM | OPT_AUTH;\n")
        end
        end
        if ppp_auth_proto == 0 then
            fprintf(fout, "    ppp->peer.auth = PPP_AUTH_CHAP;\n")
        elseif ppp_auth_proto == 1 then
            fprintf(fout, "    ppp->peer.auth = PPP_AUTH_PAP;\n")
        elseif ppp_auth_proto == 2 then
            fprintf(fout, "    ppp->peer.auth = PPP_AUTH_NONE;\n")
        end
        
        if ppp_auth_proto == 2 then
            fprintf(fout, "    strcpy(ppp->peer.user, \"%s\");\n", "")
            fprintf(fout, "    strcpy(ppp->peer.pass, \"%s\");\n", "")
        else
        fprintf(fout, "    strcpy(ppp->peer.user, \"%s\");\n", ppp_username)
        fprintf(fout, "    strcpy(ppp->peer.pass, \"%s\");\n", ppp_password)
        end
        
        fprintf(fout, "\n")
        -- ip address
        if ppp_auto_ip == 1 then   --static
            fprintf(fout, "    ppp->host.ip = %s;\n", ppp_ip_local)
            fprintf(fout, "    ppp->peer.ip = %s;\n", ppp_ip_remote)
        end
        -- DNS address
        if ppp_auto_dns == 1 then   --static
            fprintf(fout, "    ppp->host.dns[0] = %s;\n", ppp_dns_primary)
            fprintf(fout, "    ppp->peer.dns[1] = %s;\n", ppp_dns_secondary)
        end
        
        fprintf(fout, "    ppp->cfg.lcp_retry_cnt = %d;\n",     ppp_retry_cnt)
        fprintf(fout, "    ppp->cfg.ncp_retry_cnt = %d;\n",     ppp_retry_cnt)
        fprintf(fout, "    ppp->cfg.auth_retry_cnt = %d;\n",    ppp_retry_cnt)
        fprintf(fout, "    ppp->cfg.lcp_retry_tmo = %d;\n",     ppp_retry_interval)
        fprintf(fout, "    ppp->cfg.ncp_retry_tmo = %d;\n",     ppp_retry_interval)
        fprintf(fout, "    ppp->cfg.auth_retry_tmo = %d;\n",    ppp_retry_interval)
        fprintf(fout, "\n")
        fprintf(fout, "    return ercd;\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "ER ppp_close(T_PPP *ppp)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "    ER ercd;\n")
        fprintf(fout, "\n")
        fprintf(fout, "    /* Disconnect PPP */\n")
        fprintf(fout, "    ercd = ppp_cls();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
        fprintf(fout, "    /* Disconnect Line */\n")
        fprintf(fout, "    ercd = mdm_cls();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
        fprintf(fout, "    return ercd;\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
        fprintf(fout, "ER ppp_connect(T_PPP* ppp)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "    ER ercd;\n")
        fprintf(fout, "\n")
        fprintf(fout, "    /* Connect Line */\n")
        fprintf(fout, "    ercd = mdm_con(\"%s\\r\\n\");\n", ppp_dial)
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "    dly_tsk(3000);\n")
        fprintf(fout, "    /* Connect PPP */\n")
        fprintf(fout, "    ercd = ppp_con(ppp);\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        ppp_close(ppp);\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
        fprintf(fout, "    return ercd;\n")
        fprintf(fout, "}\n")
    end
    
    --[[
        ACD Callback
    --]]
    if count_acd_all() > 0 then
        fprintf(fout, "\n")
        fprintf(fout, "/*******************************\n")
        fprintf(fout, "      ACD Callback\n")
        fprintf(fout, " *******************************/\n")
        fprintf(fout, "ER acd_cbk(T_NET_ACD *adr)\n")
        fprintf(fout, "{\n")
        fprintf(fout, "    return E_OK;\n")
        fprintf(fout, "}\n")
        fprintf(fout, "\n")
    end

    --[[
        net_ini_soc
    --]]
    fprintf(fout, "\n")
    fprintf(fout, "/*******************************\n")
    fprintf(fout, "      Initialize Socket ID\n")
    fprintf(fout, " *******************************/\n")
    fprintf(fout, "ER net_ini_soc(void)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    static SID *socIdList[] = {\n")
    for i = 0, soc_count-1-((bsd_tcps + bsd_udps) + (dynamic_tcp_count + dynamic_udp_count)) do
        if snmp_use == 1 then
            -- SNMP̓lbgAvcre_socĂׁAcre_socsȂiʏj
            socid = MCFGGetParamString( "CFG_UNET3_SOCID", i )
            if socid ~= snmp_socid and socid ~= snmp_socid_trp then
                fprintf(fout, "        &%s,\n", MCFGGetParamString("CFG_UNET3_SOCID", i))
            end
        else
            fprintf(fout, "        &%s,\n", MCFGGetParamString("CFG_UNET3_SOCID", i))
        end
    end
    fprintf(fout, "        NULL\n")
    fprintf(fout, "    };\n")
    fprintf(fout, "    T_NODE host;\n")
    fprintf(fout, "    UW     i;\n")
    fprintf(fout, "    ER     ercd;\n")
    fprintf(fout, "\n")
    fprintf(fout, "    for ( i = 0; socIdList[i] != NULL; i++ ) {\n")
    fprintf(fout, "        host.num  = gSOC_TABLE[i].dev_num;\n")
    fprintf(fout, "        host.ver  = gSOC_TABLE[i].ver;\n")
    fprintf(fout, "        host.ipa  = INADDR_ANY;\n")
    fprintf(fout, "        host.port = gSOC_TABLE[i].port;\n")
    fprintf(fout, "        ercd = cre_soc(gSOC_TABLE[i].proto, &host);\n")
    fprintf(fout, "        if ( ercd <= 0 ) {\n")
    fprintf(fout, "            return ercd;\n")
    fprintf(fout, "        }\n")
    fprintf(fout, "        *socIdList[i] = (SID)ercd;\n")
    fprintf(fout, "        ercd = cfg_soc( *socIdList[i], SOC_TMO_CON, (VP)gSOC_TABLE[i].con_tmo );\n");
    fprintf(fout, "        if ( ercd != E_OK ) {\n")
    fprintf(fout, "            return ercd;\n")
    fprintf(fout, "        }\n")
    fprintf(fout, "        ercd = cfg_soc( *socIdList[i], SOC_TMO_SND, (VP)gSOC_TABLE[i].snd_tmo );\n");
    fprintf(fout, "        if ( ercd != E_OK ) {\n")
    fprintf(fout, "            return ercd;\n")
    fprintf(fout, "        }\n")
    fprintf(fout, "        ercd = cfg_soc( *socIdList[i], SOC_TMO_RCV, (VP)gSOC_TABLE[i].rcv_tmo );\n");
    fprintf(fout, "        if ( ercd != E_OK ) {\n")
    fprintf(fout, "            return ercd;\n")
    fprintf(fout, "        }\n")
    fprintf(fout, "        ercd = cfg_soc( *socIdList[i], SOC_TMO_CLS, (VP)gSOC_TABLE[i].cls_tmo );\n");
    fprintf(fout, "        if ( ercd != E_OK ) {\n")
    fprintf(fout, "            return ercd;\n")
    fprintf(fout, "        }\n")
    fprintf(fout, "    }\n")
    fprintf(fout, "\n")
    fprintf(fout, "    return E_OK;\n")
    fprintf(fout, "}\n")

    --[[
        net_cre_resrc
    --]]
    fprintf(fout, "\n")
    fprintf(fout, "/*******************************\n")
    fprintf(fout, "      Create Resource\n")
    fprintf(fout, " *******************************/\n")
    fprintf(fout, "ER net_cre_resrc(void)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    /* Create Task's */\n")
    if httpd_use == 1 then
        create_acre_tsk( "CFG_UNET3_HTTPD_SESSION", "CFG_UNET3_HTTPD_TSKID", 0 )
    end

    if version >= 300 then
        if ftpd_use == 1 then
            create_acre_tsk( "CFG_UNET3_FTPD_SESSION", "CFG_UNET3_FTPD_TSKID", 0 )
        end
        if dhcpd_use == 1 then
            create_acre_tsk( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_TSKID", 0 )
            create_acre_tsk( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_RCV_TSKID", 0 )
        end
        if tftpd_use == 1 then
            create_acre_tsk( "CFG_UNET3_TFTPD_COUNT", "CFG_UNET3_TFTPD_TSKID", 0 )
        end
        if sntpd_use == 1 then
            create_acre_tsk( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 0 )
            local mc_use = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0)
            if mc_use == 1 then
                create_acre_tsk( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_TSKID", 1 )
            end
        end
        if telnetd_use == 1 then
            create_acre_tsk( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 0 )
            create_acre_tsk( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_TSKID", 1 )
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    /* Create Event Flag's */\n")
    if version >= 300 then
        if sntpd_use == 1 then
            create_acre_flg( "CFG_UNET3_SNTPD_COUNT", "CFG_UNET3_SNTPD_FLGID", 0 )
        end
        if telnetd_use == 1 then
            create_acre_flg( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_FLGID", 0 )
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    /* Create Mailbox's */\n")
    if version >= 300 then
        if dhcpd_use == 1 then
            create_acre_mbx( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_MBXID", 0 )
        end
        if telnetd_use == 1 then
            create_acre_mbx( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_MBXID", 0 )
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    /* Create Fixed-Sized Memory Pool's */\n")
    if httpc_use == 1 then
        create_acre_mpf( nil, "CFG_UNET3_HTTPC_MPFID", 0 )
    end

    if version >= 300 then
        if dhcpd_use == 1 then
            create_acre_mpf( "CFG_UNET3_DHCPD_COUNT", "CFG_UNET3_DHCPD_SVR_MPFID", 0 )
        end
        if telnetd_use == 1 then
            create_acre_mpf( "CFG_UNET3_TELNETD_SESSION", "CFG_UNET3_TELNETD_MPFID", 0 )
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    /* Create Interrupt Service Routine's */\n")
    if version >= 300 then
        if sntpd_use == 1 then
            create_acre_isr( nil, "CFG_UNET3_SNTPD_ISRID", 0 )
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    return E_OK;\n")
    fprintf(fout, "}\n")

    --[[
        net_setup
    --]]
    fprintf(fout, "\n")
    if dhcp_count > 0 then
        if boot_func ~= "" then
            fprintf(fout, "extern ER %s(const T_BOOTP_CLIENT*);\n", boot_func)
        end
    end
    fprintf(fout, "\n")
    fprintf(fout, "/*******************************\n")
    fprintf(fout, "      Initialize Network\n")
    fprintf(fout, " *******************************/\n")
    if snmp_use == 1 and version >= 300 then
        fprintf(fout, "ER net_setup(VP opt_snmp)\n")
    else
        fprintf(fout, "ER net_setup(void)\n")
    end
    fprintf(fout, "{\n")
    fprintf(fout, "    ER ercd;\n")
    local retry_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPCLI_RETRY_CNT", 0) 
    local dhcp_ether = 0;
    local acd_count = count_acd_all()
    local acd_count_static = count_acd_static()
    for i = 0, netif_count-1 do
        if netif_linktype(i) == "Ethernet" then
            if MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE", i) == 1 then
                dhcp_ether = dhcp_ether + 1
            end
        end
    end
    if dhcp_ether > 0 then
        fprintf(fout, "    UW i;\n")
        if use_bootpc > 0 then
            if boot_func ~= "" then
                fprintf(fout, "    VB btp_svrhost[BOOTPC_SNAME_MAX];\n", dhcp_ether)
                fprintf(fout, "    VB btp_bootfile[BOOTPC_FILE_MAX];\n", dhcp_ether)
            end
            fprintf(fout, "    T_BOOTP_CLIENT btpc[%d];\n", dhcp_ether)
        else
            fprintf(fout, "    T_HOST_ADDR dhcp_addr[%d];\n", dhcp_ether)
        end
    end
    if acd_count_static > 0 then
        fprintf(fout, "    T_NET_ACD adr[%d];\n", acd_count_static)
    end
    
    fprintf(fout, "\n")
    fprintf(fout, "    /* Initialize TCP/IP Stack */\n")
    fprintf(fout, "    ercd = net_ini();\n")
    fprintf(fout, "    if (ercd != E_OK) {\n")
    fprintf(fout, "        return ercd;\n")
    fprintf(fout, "    }\n")
    
    -- Init SSL
    if ssl_use == 1 then
        fprintf(fout, "\n")
        fprintf(fout, "    /* Initialize SSL */\n")
        fprintf(fout, "    ercd = ssl_setup();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
    end

    -- Init SNMP
    if snmp_use == 1 and version >= 300 then
        fprintf(fout, "\n")
        fprintf(fout, "    /* Initialize SNMP */\n")
        fprintf(fout, "    ercd = snmp_ini(opt_snmp);\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "    ercd = snmp_ena();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
    end
    
    -- C^tF[XJԂ
    fprintf(fout, "\n")
    if netif_count > 0 then
        j = 0
        fprintf(fout, "    /* Initialize Network Driver */\n")
        for i = 0, netif_count-1 do
            if netif_linktype(i) ~= "Virtual" then
                local id = MCFGGetParamString("CFG_UNET3_IFID", i)
                fprintf(fout, "    ercd = net_dev_ini(%s);\n", id)
                fprintf(fout, "    if (ercd != E_OK) {\n")
                fprintf(fout, "        return ercd;\n")
                fprintf(fout, "    }\n")
                -- Check address conflict
                if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 and MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE", i) == 0 then
                    fprintf(fout, "\n")
                    fprintf(fout, "    ercd = net_acd(%s, &adr[%d]);\n", id, j)
                    fprintf(fout, "    if (ercd != E_OK) {\n")
                    fprintf(fout, "        return ercd;\n")
                    fprintf(fout, "    }\n")
                    fprintf(fout, "\n")
                    j = j + 1
                end
            end
        end
        fprintf(fout, "\n")
    end
    if ipv6_use == 1 then
        fprintf(fout, "    /* Initialize IPv6 */\n")
        fprintf(fout, "    ercd = net6_ini();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
    end

    -- Init static socket
    fprintf(fout, "\n")
    fprintf(fout, "    /* Initialize Socket ID */\n")
    fprintf(fout, "    ercd = net_ini_soc();\n")
    fprintf(fout, "    if ( ercd != E_OK ) {\n")
    fprintf(fout, "        return ercd;\n")
    fprintf(fout, "    }\n")
    fprintf(fout, "\n")

    -- Create netapp resource
    fprintf(fout, "\n")
    fprintf(fout, "    /* Create Resource for netapp */\n")
    fprintf(fout, "    ercd = net_cre_resrc();\n")
    fprintf(fout, "    if ( ercd != E_OK ) {\n")
    fprintf(fout, "        return ercd;\n")
    fprintf(fout, "    }\n")
    fprintf(fout, "\n")

    -- uIP[vobNLɂvɃ`FbNĂꍇ
    if MCFGGetParamInteger("CFG_UNET3_IP4_LOOPBACK", 0) ~= 0 then
        fprintf(fout, "    /* Initialize ip4 loop */\n")
        fprintf(fout, "    ercd = ip4_loop_ini();\n")
        fprintf(fout, "    if (ercd != E_OK) {\n")
        fprintf(fout, "        return ercd;\n")
        fprintf(fout, "    }\n")
        fprintf(fout, "\n")
    end

    if dhcp_ether > 0 then
        local ether_count = 0
        local dhcp_soc = MCFGGetParamString("CFG_UNET3_IF_DHCP_SOCID", 0)
        fprintf(fout, "    /* Resolve IP Address */\n")
        for i = 0, netif_count-1 do
            if netif_linktype(i) == "Ethernet" then
                if MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE", i) == 1 then
                    if use_bootpc > 0 then
                        fprintf(fout, "    net_memset(&btpc[%d], 0, sizeof(T_BOOTP_CLIENT));\n", ether_count)
                        fprintf(fout, "    btpc[%d].sid = %s;\n", ether_count, dhcp_soc);
                        fprintf(fout, "    btpc[%d].dev_num = %s;\n", ether_count, MCFGGetParamString("CFG_UNET3_IFID", i))
                        if boot_func ~= "" then
                            fprintf(fout, "    net_memset(btp_svrhost, 0, sizeof(btp_svrhost));\n")
                            fprintf(fout, "    net_memset(btp_bootfile, 0, sizeof(btp_bootfile));\n")
                            fprintf(fout, "    btpc[%d].sname = btp_svrhost;\n", ether_count);
                            fprintf(fout, "    btpc[%d].file = btp_bootfile;\n", ether_count);
                        end
                        fprintf(fout, "    for (i = 0; i < %d; i++) {\n", retry_cnt)
                        fprintf(fout, "        ercd = bootp_client(&btpc[%d]);\n", ether_count)
                        fprintf(fout, "        if (ercd == E_OK) {\n")
                        fprintf(fout, "            break;\n")
                        fprintf(fout, "        }\n")
                        fprintf(fout, "        dly_tsk(1000);\n")
                        fprintf(fout, "    }\n")
                        
                    else
                        fprintf(fout, "    net_memset(&dhcp_addr[%d], 0, sizeof(T_HOST_ADDR));\n", ether_count)
                        fprintf(fout, "    dhcp_addr[%d].socid = %s;\n", ether_count, dhcp_soc);
                        fprintf(fout, "    dhcp_addr[%d].dev_num = %s;\n", ether_count, MCFGGetParamString("CFG_UNET3_IFID", i))
                        if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 and MCFGGetParamInteger("CFG_UNET3_DHCPCLI_EXT_USE", 0) == 1 then
                            fprintf(fout, "    dhcp_addr[%d].arpchk = ARP_CHECK_ON;\n", ether_count)
                        end
                        fprintf(fout, "    for (i = 0; i < %d; i++) {\n", retry_cnt)
                        fprintf(fout, "        ercd = dhcp_client(&dhcp_addr[%d]);\n", ether_count)
                        fprintf(fout, "        if (ercd == E_OK) {\n")
                        fprintf(fout, "            break;\n")
                        fprintf(fout, "        }\n")
                        fprintf(fout, "        dly_tsk(1000);\n")
                        fprintf(fout, "    }\n")
                    end
                    
                    -- DHCPłE_TMOUTE_OKƂ
                    fprintf(fout, "    if (ercd == E_TMOUT) {\n")
                    fprintf(fout, "        ercd = E_OK;\n")
                    fprintf(fout, "    }\n")
                    fprintf(fout, "    if (ercd != E_OK) {\n")
                    fprintf(fout, "        return ercd;\n")
                    fprintf(fout, "    }\n")
                    
                    -- BOOTPNCAgɃ[U[u[g֐̎s
                    if boot_func ~= "" then
                        fprintf(fout, "    /* Execute User Boot Function */\n")
                        fprintf(fout, "    ercd = %s(&btpc[%d]);\n", boot_func, ether_count)
                        fprintf(fout, "    if (ercd != E_OK) {\n")
                        fprintf(fout, "        return ercd;\n")
                        fprintf(fout, "    }\n")
                    end
                    
                    fprintf(fout, "\n")
                    
                    ether_count = ether_count + 1
                end
            end
        end
        fprintf(fout, "\n")
    end
    if count_acd_all() > 0 then
        if netif_count > 0 then
            for i = 0, netif_count-1 do
                local id = MCFGGetParamString("CFG_UNET3_IFID", i)
                if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 then
                    fprintf(fout, "    net_cfg(%s, NET_ACD_CBK, (VP)acd_cbk);\n", id)
                end
            end
        end
        fprintf(fout, "\n")
    end

    --[[
    -- httpd task call
    --]]
    if httpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_SESSION", 0)
        fprintf(fout, "\n")
        fprintf(fout, "    gHTTP_FILE = (T_HTTP_FILE*)content_list;\n")
        if (httpd_ext_use > 0) and (httpd_ext_cbk ~= "") then   -- HTTPdg@\L
            fprintf(fout, "    gHTTP_EXT_CBK = %s;\n", httpd_ext_cbk)
        end
        fprintf(fout, "\n")
        fprintf(fout, "    /* Start HTTPd Task */\n")
        for i = 0, (session_cnt-1) do 
            id = MCFGGetParamString("CFG_UNET3_HTTPD_TSKID", 0)
            fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
        end
    end

    --[[
        FTPd task call
    --]]
    if version >= 300 then
        if ftpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_FTPD_SESSION", 0)
            fprintf(fout, "    /* Start FTPd Task */\n")
            for i = 0, (session_cnt-1) do 
                id = MCFGGetParamString("CFG_UNET3_FTPD_TSKID", 0)
                fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
            end
        end
    end

    --[[
        DHCPd task call
    --]]
    if version >= 300 then
        if dhcpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
            fprintf(fout, "    /* Start DHCPd Task */\n")
            for i = 0, (session_cnt-1) do 
                id = MCFGGetParamString("CFG_UNET3_DHCPD_SVR_TSKID", 0)
                fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
            end
        end
    end

    --[[
        TFTPd task call
    --]]
    if version >= 300 then
        if tftpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_TFTPD_COUNT", 0)
            fprintf(fout, "    /* Start TFTPd Task */\n")
            for i = 0, (session_cnt-1) do 
                id = MCFGGetParamString("CFG_UNET3_TFTPD_TSKID", 0)
                fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
            end
        end
    end

    --[[
        SNTPd task call
    --]]
    if version >= 300 then
        if sntpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
            fprintf(fout, "    /* Start SNTPd Task */\n")
            for i = 0, (session_cnt-1) do 
                id = MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 0)
                fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
            end
        end
    end

    --[[
        Telnetd task call
        Shell^XNtelnet_server^XNN̂,sta_tskȂ
    --]]
    if version >= 300 then
        if telnetd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
            fprintf(fout, "    /* Start Telnetd Task */\n")
            for i = 0, (session_cnt-1) do 
                id = MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 0)
                fprintf(fout, "    sta_tsk(%s%d, 0);\n", id, i+1)
            end
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    return ercd;\n")
    fprintf(fout, "}\n")

    --[[
        HTTPD TASK
    --]]
    if httpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "\n")
            tskname = MCFGGetParamString("CFG_UNET3_HTTPD_TASK", 0)..(i+1)
            socid = MCFGGetParamString("CFG_UNET3_HTTPD_SOCID", 0)..(i+1)
            svrvar = "http_server"..(i+1)
            fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
            fprintf(fout, "static T_HTTP_SERVER %s;\n", svrvar)
            fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
            fprintf(fout, "{\n")
            fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
            fprintf(fout, "    %s.SocketID = %s;\n", svrvar, socid);
            -- Add IP ver(IPv4 or IPv6)
            if socid2ipver(socid) == 0 then
                fprintf(fout, "    %s.ver = IP_VER4;\n", svrvar);
            else 
                fprintf(fout, "    %s.ver = IP_VER6;\n", svrvar);
            end
            fprintf(fout, "\n")
            fprintf(fout, "    http_server(&%s);\n", svrvar);
            fprintf(fout, "}\n")
        end
    end
    
    --[[
        FTPD TASK
    --]]
    if version >= 300 then
        if ftpd_use == 1 then
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_FTPD_SESSION", 0)
            for i = 0, (session_cnt-1) do 
                fprintf(fout, "\n")
                tskname = MCFGGetParamString("CFG_UNET3_FTPD_TASK", 0)..(i+1)
                socid_ctl = MCFGGetParamString("CFG_UNET3_FTPD_SOCID", 0)..(i+1)
                socid_data = MCFGGetParamString("CFG_UNET3_FTPD_SOCID", 1)..(i+1)
                svrvar = "ftp_server"..(i+1)
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
                fprintf(fout, "static T_FTP_SERVER %s;\n", svrvar)
                fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
                local ftpd_secure_inf = get_ftpd_secure_info()
                if ftpd_secure_inf == "" then
                    fprintf(fout, "    %s.sec = 0;\n", svrvar);
                else
                    fprintf(fout, "    %s.sec = %s;\n", svrvar, ftpd_secure_inf);
                end
                fprintf(fout, "    %s.dev_num = DEV_ANY;\n", svrvar);
                fprintf(fout, "    %s.ctl_sid = %s;\n", svrvar, socid_ctl);
                fprintf(fout, "    %s.dat_sid = %s;\n", svrvar, socid_data);
                fprintf(fout, "\n")
                fprintf(fout, "    ftp_server(&%s);\n", svrvar);
                fprintf(fout, "}\n")
            end
        end
    end

    --[[
        DHCPD TASK
    --]]
    if version >= 300 then
        if dhcpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
            -- extern
            for i = 0, (session_cnt-1) do
                func = MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i)
                if func ~= "" then
                    if is_uniq_altfunc(func, i) == true then
                        fprintf(fout, "extern void %s(ID type, T_DHCP_RESOURCE * dat);\n", func)
                    end
                end
            end
            
            for i = 0, (session_cnt-1) do 
                fprintf(fout, "\n")
                tskname = MCFGGetParamString("CFG_UNET3_DHCPD_SVR_TASK", 0)..(i+1)
                socid = MCFGGetParamString("CFG_UNET3_DHCPD_SOCID", 0)..(i+1)
                tsk_id = MCFGGetParamString("CFG_UNET3_DHCPD_RCV_TSKID", 1)..(i+1)
                mpf_id = MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MPFID", 0)..(i+1)
                mbx_id = MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MBXID", 0)..(i+1)
                svrvar = "dhcp_server"..(i+1)
                macvar = "reserv_mac"..(i+1)
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
                -- alt function
                alt_func = MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i)
                -- Server value
                fprintf(fout, "static T_DHCP_SERVER %s;\n", svrvar)
                -- MAC List
                local mac_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_RESERV_MAC_COUNT", i)
                if mac_cnt > 0 then
                    fprintf(fout, "static UB %s[][6] = {", macvar)
                    for j = 0, (mac_cnt-1) do
                        index = bit.bor(bit.lshift(j, 16), i)
                        fprintf(fout, "\n    {%s,", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_0", index))
                        fprintf(fout, " %s,", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_1", index))
                        fprintf(fout, " %s,", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_2", index))
                        fprintf(fout, " %s,", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_3", index))
                        fprintf(fout, " %s,", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_4", index))
                        fprintf(fout, " %s},", MCFGGetParamString("CFG_UNET3_DHCPD_RESERV_MAC_5", index))
                    end
                    fprintf(fout, "\n};\n")
                end
                -- CӂDHCPIvVݒ
                dhcp_opt_use = MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_USE", i)
                if dhcp_opt_use == 1 then
                    local opt_count = MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_COUNT", i)
                    local opt_kind
                    local opt_mode
                    local opt_octet
                    local value
                    local data_count
                    local nIndex
                    local cnt_i
                    local cnt_j
                    local cnt_k
                    local strCmp
                    local dhcp_opt_list_name = "dhcp_opt_list"..(i+1)
                    other_opt_name = "other_opt"..(i+1)

                    -- DHCPIvV0ȊȌꍇ
                    if opt_count ~= 0 then
                        -- DHCP opt list̔zvfvZ
                        fprintf(fout, "/* DHCP option list                                                          */\n")
                        nIndex = bit.band( i, 0x0000FFFF )
                        data_count = 0
                        for cnt_i = 0, opt_count-1 do
                            cnt_j = 0
                            nIndex = bit.band( nIndex, 0xFF00FFFF )
                            nIndex = bit.bor( nIndex, bit.band(bit.lshift(cnt_i, 16), 0x00FF0000) )
                            while true do
                                nIndex = bit.band( nIndex, 0x00FFFFFF )
                                nIndex = bit.bor( nIndex, bit.band(bit.lshift(cnt_j, 24), 0xFF000000) )
                                strData = MCFGGetParamString("CFG_UNET3_DHCPD_OPT_DATA", nIndex)
                                if strData == NULL then
                                    break
                                end
                                cnt_j = cnt_j + 1
                            end
                            if data_count < cnt_j then
                                data_count = cnt_j
                            end
                        end
                        fprintf(fout, "static UB *%s[][%d] =\n", dhcp_opt_list_name, data_count + 1)
                        fprintf(fout, "{\n")

                        -- DHCP opt list
                        nIndex = bit.band( i, 0x0000FFFF )
                        for cnt_i = 0, opt_count-1 do
                            fprintf(fout, "    { ")
                            cnt_j = 0
                            nIndex = bit.band( nIndex, 0xFF00FFFF )
                            nIndex = bit.bor( nIndex, bit.band(bit.lshift(cnt_i, 16), 0x00FF0000) )
                            while true do
                                nIndex = bit.band( nIndex, 0x00FFFFFF )
                                nIndex = bit.bor( nIndex, bit.band(bit.lshift(cnt_j, 24), 0xFF000000) )
                                strData = MCFGGetParamString("CFG_UNET3_DHCPD_OPT_DATA", nIndex)
                                if strData == NULL then
                                    break
                                end
                                opt_octet = MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_OCTET", nIndex)
                                if opt_octet == 1 then
                                    fprintf(fout, "\"%02X\", ", tonumber(strData))
                                elseif opt_octet == 2 then
                                    fprintf(fout, "\"%04X\", ", tonumber(strData))
                                elseif opt_octet == 4 then
                                    fprintf(fout, "\"%08X\", ", tonumber(strData))
                                elseif opt_octet == 8 then
                                    fprintf(fout, "\"%016X\", ", tonumber(strData))
                                else
                                    fprintf(fout, "\"")
                                    strLen = string.len( strData )
                                    for cnt_k = 1, strLen do
                                        strCmp = string.sub(strData, cnt_k, cnt_k)
                                        if "\'" == strCmp or "\\" == strCmp or "\"" == strCmp or "\?" == strCmp then
                                            fprintf(fout, "\\")
                                        end
                                        fprintf(fout, "%s", strCmp)
                                    end
                                    fprintf(fout, "\", ")
                                end
                                cnt_j = cnt_j + 1
                            end
                            fprintf(fout, "NULL },\n")
                        end
                        fprintf(fout, "};\n")
                    end

                    -- DHCP other options
                    fprintf(fout, "/* DHCP other options                                                        */\n")
                    fprintf(fout, "static T_DHCPD_MSG_OPTION %s[] =\n", other_opt_name)
                    fprintf(fout, "{\n")
                    for cnt_i = 0, opt_count-1 do
                        nIndex = 0
                        nIndex = bit.bor( nIndex, bit.band(bit.lshift(cnt_i, 16), 0xFFFF0000) )
                        value = MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_FORMAT", nIndex)
                        if value == 0 then
                            opt_kind = "DHCP_OPT_KIND_BINARY"
                        elseif value == 1 then
                            opt_kind = "DHCP_OPT_KIND_ADDRESS"
                        else
                            opt_kind = "DHCP_OPT_KIND_STRING"
                        end

                        value = MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_ENDIAN", nIndex)
                        if value == 0 then
                            opt_mode = "DHCP_MODE_BIG_ENDIAN"
                        elseif value == 1 then
                            opt_mode = "DHCP_MODE_LITTLE_ENDIAN"
                        else
                            opt_mode = "0"
                        end
                        fprintf(fout, "    { %s, %d, %d, %s, (VP *)&%s[%d][0] },\n",
                                opt_kind,
                                MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_OPTVALUE", nIndex),
                                MCFGGetParamInteger("CFG_UNET3_DHCPD_OPT_OPTLEN", nIndex),
                                opt_mode,
                                dhcp_opt_list_name,
                                cnt_i)
                    end
                    fprintf(fout, "    { 0, 0, 0, 0, NULL }                /* Terminate markiDo not changej   */\n")
                    fprintf(fout, "};\n")
                end
                fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
                fprintf(fout, "    %s.dev_num = %s;\n", svrvar, MCFGGetParamString("CFG_UNET3_DHCPD_BINDIF", i))
                if mac_cnt > 0 then
                    fprintf(fout, "    %s.reserve_mac = (UB**)%s;\n", svrvar, macvar);
                end
                fprintf(fout, "    %s.reserve_num = %d;\n", svrvar, mac_cnt);
                fprintf(fout, "    %s.starting_addr = ip_aton(\"%s\");\n", svrvar, MCFGGetParamString("CFG_UNET3_DHCPD_IPADDR", i))
                fprintf(fout, "    %s.lease_period = DHCP_LEASE_PERIOD;\n",  svrvar)
                fprintf(fout, "    %s.lease_num = %d;\n",  svrvar, MCFGGetParamInteger("CFG_UNET3_DHCPD_LEASE_NUM", i))
                fprintf(fout, "    %s.subnet = ip_aton(\"%s\");\n", svrvar, MCFGGetParamString("CFG_UNET3_DHCPD_SUBNET", i))
                fprintf(fout, "    %s.gateway = ip_aton(\"%s\");\n", svrvar, MCFGGetParamString("CFG_UNET3_DHCPD_GATEWAY", i))
                alt_func = MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i)
                if alt_func ~= "" then
                    fprintf(fout, "    %s.alt = %s;\n", svrvar, alt_func)
                end
                fprintf(fout, "    %s.sid = %s;\n", svrvar, socid)
                fprintf(fout, "    %s.tsk_id = %s;\n", svrvar, tsk_id)
                fprintf(fout, "    %s.mpf_id = %s;\n", svrvar, mpf_id)
                fprintf(fout, "    %s.mbx_id = %s;\n", svrvar, mbx_id)
                if dhcp_opt_use == 1 then
                    fprintf(fout, "    %s.other_opt = %s;\n", svrvar, other_opt_name)
                else
                    fprintf(fout, "    %s.other_opt = NULL;\n", svrvar)
                end
                fprintf(fout, "\n")
                fprintf(fout, "    dhcp_server(&%s);\n", svrvar)
                fprintf(fout, "}\n")
            end
        end
    end

    --[[
        TFTPd TASK
    --]]
    if version >= 300 then
        if tftpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_TFTPD_COUNT", 0)
            for i = 0, (session_cnt-1) do 
                fprintf(fout, "\n")
                tskname = MCFGGetParamString("CFG_UNET3_TFTPD_TASK", 0)..(i+1)
                socid_req = MCFGGetParamString("CFG_UNET3_TFTPD_SOCID", 0)..(i+1)
                socid_data = MCFGGetParamString("CFG_UNET3_TFTPD_SOCID", 1)..(i+1)
                svrvar = "tftp_server"..(i+1)
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
                -- Server value
                fprintf(fout, "static T_TFTP_SERVER %s;\n", svrvar)
                fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
                fprintf(fout, "    %s.dev_num = %s;\n", svrvar, MCFGGetParamString("CFG_UNET3_TFTPD_BINDIF", i))
                fprintf(fout, "    %s.req_sid = %s;\n", svrvar, socid_req)
                fprintf(fout, "    %s.dat_sid = %s;\n", svrvar, socid_data)
                fprintf(fout, "\n")
                fprintf(fout, "    tftp_server(&%s);\n", svrvar)
                fprintf(fout, "}\n")
            end
        end
    end

    --[[
        SNTPd TASK
    --]]
    if version >= 300 then
        if sntpd_use == 1 then
            fprintf(fout, "\n")
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
            for i = 0, (session_cnt-1) do 
                fprintf(fout, "\n")
                tskname = MCFGGetParamString("CFG_UNET3_SNTPD_TASK", 0)..(i+1)
                socid   = MCFGGetParamString("CFG_UNET3_SNTPD_SOCID", 0)..(i+1) -- \Pbg ID
                flgid   = MCFGGetParamString("CFG_UNET3_SNTPD_FLGID", 0)..(i+1) -- CxgtOID
                mc_tid  = MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 1)..(i+1) -- }`LXgMp^XNID
                svrvar  = "sntp_server"..(i+1)
                
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
                -- Server value
                fprintf(fout, "static T_SNTP_SERVER %s;\n", svrvar)
                fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
                fprintf(fout, "    %s.dev_num = %s;\n", svrvar, MCFGGetParamString("CFG_UNET3_SNTPD_BINDIF", i))
                fprintf(fout, "    %s.socid   = %s;\n", svrvar, socid)
                fprintf(fout, "    %s.flgid   = %s;\n", svrvar, flgid)
                if MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0) == 1 then
                    fprintf(fout, "    %s.mc_tid  = %s;\n", svrvar, mc_tid)
                end
                fprintf(fout, "\n")
                fprintf(fout, "    sntp_server(&%s);\n", svrvar)
                fprintf(fout, "}\n")
            end
        end
    end

    --[[
        Telnet, Shell TASK
    --]]
    if version >= 300 then
        if telnetd_use == 1 then
            local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
            for i = 0, (session_cnt-1) do 
                fprintf(fout, "\n")
                -- Telnet Server Task
                sid         = MCFGGetParamString("CFG_UNET3_TELNETD_SOCID", 0)..(i+1)
                shell_tid   = MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 1)..(i+1)
                mpf_id      = MCFGGetParamString("CFG_UNET3_TELNETD_MPFID", 0)..(i+1)
                flg_id      = MCFGGetParamString("CFG_UNET3_TELNETD_FLGID", 0)..(i+1)
                mbx_id      = MCFGGetParamString("CFG_UNET3_TELNETD_MBXID", 0)..(i+1)
                tskname     = MCFGGetParamString("CFG_UNET3_TELNETD_TASK", 0)..(i+1)
                svrvar      = "net_ctl_telnets"..(i+1)
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", tskname)
                fprintf(fout, "static T_TELNET_SERVER %s;\n", svrvar)
                fprintf(fout, "void %s(VP_INT exinf)\n", tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", svrvar, svrvar)
                fprintf(fout, "    %s.sid       = %s;\n", svrvar, sid);
                fprintf(fout, "    %s.shell_tid = %s;\n", svrvar, shell_tid);
                fprintf(fout, "    %s.mpf_id    = %s;\n", svrvar, mpf_id);
                fprintf(fout, "    %s.flg_id    = %s;\n", svrvar, flg_id);
                fprintf(fout, "    %s.mbx_id    = %s;\n", svrvar, mbx_id);
                fprintf(fout, "\n")
                fprintf(fout, "    telnet_server(&%s);\n", svrvar);
                fprintf(fout, "}\n")
                -- Shell Task for Telnet Server
                fprintf(fout, "\n")
                shell_tskname= MCFGGetParamString("CFG_UNET3_TELNETD_TASK", 1)..(i+1)
                shell_var    = "net_ctl_shell"..(i+1)
                fprintf(fout, "/*******************************\n        %s\n *******************************/\n", shell_tskname)
                fprintf(fout, "static T_SHELL_CTL %s;\n", shell_var)
                fprintf(fout, "void %s(VP_INT exinf)\n", shell_tskname)
                fprintf(fout, "{\n")
                fprintf(fout, "    net_memset((char* )&%s, 0, sizeof(%s));\n", shell_var, shell_var)
                fprintf(fout, "    %s.typ = TYP_TELNET;\n", shell_var);
                fprintf(fout, "    %s.pcb = &%s;\n", shell_var, svrvar);
                fprintf(fout, "\n")
                fprintf(fout, "    shell_sta(&%s);\n", shell_var);
                fprintf(fout, "}\n")
            end
        end
    end

    -- End
    fprintf(fout, "/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
