/**
  * @file    DDR_CORTEXR_MPU.h
  * @brief   MPU and Cache management definitions (Cortex-R)
  * @date    2016.02.03
  * @author  Copyright (c)  2016, eForce Co.,Ltd.  All rights reserved.
  *
  * @par     History
  *          - rev 1.0 (2016.02.03) yokota migrate from ds-5 version.
  *            rev 1.1 (2016.02.19) fix typo.
  *            Initial version. 
  */

@
@      Region size
@
        .EQU    REGION_32B,     0x04  @ 32 bytes
        .EQU    REGION_64B,     0x05  @ 64 bytes
        .EQU    REGION_128B,    0x06  @ 128 bytes
        .EQU    REGION_256B,    0x07  @ 256 bytes
        .EQU    REGION_512B,    0x08  @ 512 bytes
        .EQU    REGION_1K,      0x09  @ 1KB
        .EQU    REGION_2K,      0x0A  @ 2KB
        .EQU    REGION_4K,      0x0B  @ 4KB
        .EQU    REGION_8K,      0x0C  @ 8KB
        .EQU    REGION_16K,     0x0D  @ 16KB
        .EQU    REGION_32K,     0x0E  @ 32KB
        .EQU    REGION_64K,     0x0F  @ 64KB
        .EQU    REGION_128K,    0x10  @ 128KB
        .EQU    REGION_256K,    0x11  @ 256KB
        .EQU    REGION_512K,    0x12  @ 512KB
        .EQU    REGION_1M,      0x13  @ 1MB
        .EQU    REGION_2M,      0x14  @ 2MB
        .EQU    REGION_4M,      0x15  @ 4MB
        .EQU    REGION_8M,      0x16  @ 8MB
        .EQU    REGION_16M,     0x17  @ 16MB
        .EQU    REGION_32M,     0x18  @ 32MB
        .EQU    REGION_64M,     0x19  @ 64MB
        .EQU    REGION_128M,    0x1A  @ 128MB
        .EQU    REGION_256M,    0x1B  @ 256MB
        .EQU    REGION_512M,    0x1C  @ 512MB
        .EQU    REGION_1G,      0x1D  @ 1GB
        .EQU    REGION_2G,      0x1E  @ 2GB
        .EQU    REGION_4G,      0x1F  @ 4GB

@
@       Access permissions
@
@                           Privileged permissions      User permissions

        .EQU AP_NA   , 0x00000000  @ No access                 No access
        .EQU AP_RWNA , 0x00000100  @ Read/write                No access
        .EQU AP_RWRO , 0x00000200  @ Read/write                Read-only
        .EQU AP_RW   , 0x00000300  @ Read/write                Read/write
        .EQU AP_RONA , 0x00000500  @ Read-only                 No access
        .EQU AP_RO   , 0x00000600  @ Read-only                 Read-only

@
@       Memory region attributes
@
@           ATR_STRG -----------------------------------------+
@           ATR_SDEV -----------------------------------------+
@           ATR_WTNW -----------------------------------------+
@           ATR_WBNW -----------------------------------------+
@           ATR_NONC -----------------------------------------+-- [ATR_SHRD} -- [ATR_NEXC}
@           ATR_WBAW -----------------------------------------+
@           ATR_NDEV -----------------------------------------+
@           ATR_SELA --+-- ATR_INONC --+---+-- ATR_ONONC --+--+
@                      +-- ATR_IWBAW --+   +-- ATR_OWBAW --+
@                      +-- ATR_IWTNW --+   +-- ATR_OWTNW --+
@                      +-- ATR_IWBNW --+   +-- ATR_OWBNW --+
@                                                                   Memory type         Shareable

        .EQU ATR_STRG, 0x00000000  @ Strongly Ordered                  Strongly Ordered    Shareable
        .EQU ATR_SDEV, 0x00000001  @ Shared Device                     Device              Shareable
        .EQU ATR_WTNW, 0x00000002  @ Outer and Inner write-through,
                                   @ no write-allocate                 Normal              S-bit
        .EQU ATR_WBNW, 0x00000003  @ Outer and Inner write-back,
                                   @ no write-allocate                 Normal              S-bit
        .EQU ATR_NONC, 0x00000008  @ Outer and Inner Non-cachable      Normal              S-bit
        .EQU ATR_WBAW, 0x0000000B  @ Outer and Inner write-back,
                                   @ write-allocate                    Normal              S-bit
        .EQU ATR_NDEV, 0x00000010  @ Non-shared Device                 Device              Non-shareable
        .EQU ATR_SELA, 0x00000020  @ Cacheable memory                  Normal              S-bit

        .EQU ATR_INO,  0x00000000  @ Inner Non-cacheable
        .EQU ATR_IWBA, 0x00000001  @ Inner Write-back, write-allocate
        .EQU ATR_IWTN, 0x00000002  @ Inner Write-through, no write-allocate
        .EQU ATR_IWBN, 0x00000003  @ Inner Write-back, no write-allocate

        .EQU ATR_ONO,  0x00000000  @ Outer No@-cachable
        .EQU ATR_OWBA, 0x00000008  @ Outer Write-back, write-allocate
        .EQU ATR_OWTN, 0x00000010  @ Outer Write-through, no write-allocate
        .EQU ATR_OWBN, 0x00000018  @ Outer Write-back, no write-allocate

        .EQU ATR_NEXC, 0x00000000  @ eXecute @ever attribute
        .EQU ATR_SHRD, 0x00000004  @ Shared attribute

