/**
 * @file    DDR_RZT1_CPG.h
 * @brief   RZ/T1 Clock Pulse Generator unit (Cortex-R core)
 * @date    2015.04.23
 * @author  Copyright (c) 2014-2015, eForce Co.,Ltd.  All rights reserved.
 *
 * @par     History
 *          - rev 1.0 (2014.10.03) i-cho
 *            Initial version. 
 *          - rev 1.1 (2015.04.23) i-cho
 *            modified _ddr_rzt1_cpg_chg_cpuclk function argument.
 *            added ETCLKD and ETCLKE changing function.
 */

#ifndef _DDR_RZT1_CPG_H_
#define _DDR_RZT1_CPG_H_

#ifdef __cplusplus
extern "C"
{
#endif

    
/**
 * PRCR register macros
 */
#define PRCR_CPG_UNLOCK     (0x0000A501)    /* Allow writing for CPG register */
#define PRCR_CPG_LOCK       (0x0000A500)
    
#define PRCR_MSTP_UNLOCK    (0x0000A502)
#define PRCR_MSTP_LOCK      (0x0000A500)
    
#define PRCR_ACTM_UNLOCK    (0x0000A508)
#define PRCR_ACTM_LOCK      (0x0000A500)
    
    
/**
 * PLL1CR CPUCLKSEL bit (CPU clock)
 */
#define CPG_CPUCKSEL_150_MHZ    (0)
#define CPG_CPUCKSEL_300_MHZ    (1)
#define CPG_CPUCKSEL_450_MHZ    (2)
#define CPG_CPUCKSEL_600_MHZ    (3)

/**
 * SCKCR CKIO bit (External bus clock)
 */
#define CPG_CKIO_75_MHZ         (0)
#define CPG_CKIO_50_MHZ         (1)
#define CPG_CKIO_37_5_MHZ       (2)
#define CPG_CKIO_30_MHZ         (3)
#define CPG_CKIO_25_MHZ         (4)
#define CPG_CKIO_21_43_MHZ      (5)
#define CPG_CKIO_18_75_MHZ      (6)

/**
 * SCKCR SERICK bit (High speed serial clock)
 */
#define CPG_SERICK_150_MHZ      (0)
#define CPG_SERICK_120_MHZ      (1)


/**
 * SCKCR ETCLKE bit
 */
#define CPG_ETCLKE_MAIN_CLK     (0)
#define CPG_ETCLKE_PLL0_CLK     (1)

/**
 * SCKCR ETCLKD bit
 */
#define CPG_ETCLKD_12_5_MHZ      (0)
#define CPG_ETCLKD_6_25_MHZ      (1)
#define CPG_ETCLKD_3_125_MHZ     (2)
#define CPG_ETCLKD_1_563_MHZ     (3)


/**
 * Set CPU clock and LOCO clock
 * @param[in] CPUCKSEL
 * @param[in] CKIO
 */
ER _ddr_rzt1_cpg_chg_cpuclk(UINT cpucksel, UINT ckio);

/**
 * Set ETCLKD(Ether MAC) and ETCLKE(Ether-PHY)
 * @param[in] ETCLKD
 * @param[in] ETCLKE
 */
ER _ddr_rzt1_cpg_chg_etclk(UINT d, UINT e);

/**
 * Get high speed serial clock.
 * @return SERICLK
 */
UW _ddr_rzt1_cpg_get_sericlk(void);


/**
 * Get external bus clock
 */
UW _ddr_rzt1_cpg_get_ckio(void);

#ifdef __cplusplus
}
#endif

#endif  /* _DDR_RZT1_CPG_H_ */
