--[[
  @file     http_client_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.01
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/06    1.00        
  2015/05/20    1.01        HTTPSΉ
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    HTTP Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef HTTP_CLIENT_CFG_H\n")
    fprintf(fout, "#define HTTP_CLIENT_CFG_H\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_HTTPC_AUTH_BASIC", 0) == 1 then
        fprintf(fout, "#define ENA_AUTH_BASIC        /* Enable Basic Authentication */\n")
    end
    if MCFGGetParamInteger("CFG_UNET3_HTTPC_AUTH_DIGEST", 0) == 1 then
        fprintf(fout, "#define ENA_AUTH_DIGEST       /* Enable Digest Authentication */\n")
    end
    if MCFGGetParamInteger("CFG_UNET3_HTTPC_SSL", 0) == 1 then
        fprintf(fout, "\n")
        fprintf(fout, "/* Enable HTTPS */\n")
        fprintf(fout, "#define HTTPC_SSL_SUP\n")
    end

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* HTTP_CLIENT_CFG_H */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



