--[[
  @file     shell_cfg.c.c.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/24    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf

-- 
function is_uniq_cmdfunc(func, cur) 
    for i = 0, cur-1 do 
        if func == MCFGGetParamString("CFG_UNET3_TELNETD_CMD_FUNC", i) then
            return false
        end
    end
    return true
end

--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local user_count   = MCFGGetParamInteger("CFG_UNET3_TELNETD_USER_COUNT", 0)
    local cmd_count   = MCFGGetParamInteger("CFG_UNET3_TELNETD_CMD_COUNT", 0)
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    Simple shell for Telnet Server configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"shell.h\"\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Login user table (Max. 256 users) */\n")
    fprintf(fout, "const T_SHELL_USR_TBL shell_usr_tbl[] = {\n")
    for i = 0, user_count-1 do
        fprintf(fout, "    {\"%s\", \"%s\"},\n", MCFGGetParamString("CFG_UNET3_TELNETD_USER_NAME", i), MCFGGetParamString("CFG_UNET3_TELNETD_USER_PASS", i))
    end
    fprintf(fout, "    {0x00, 0x00}    /* Terminate mark (Do not change) */\n")
    fprintf(fout, "};\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Macros */\n")
    fprintf(fout, "#define EXT_FUNC(x)    extern ER (x) (VP ctrl, INT argc, VB *argv[])\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Command functions */\n")
    for i = 0, cmd_count-1 do
        func = MCFGGetParamString("CFG_UNET3_TELNETD_CMD_FUNC", i)
        if func ~= "" then
            if is_uniq_cmdfunc(func, i) == true then
                fprintf(fout, "EXT_FUNC(%s);\n", func)
            end
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Command table  (Max. 256 commands) */\n")
    fprintf(fout, "const T_SHELL_CMD_TBL shell_cmd_tbl[] = {\n")
    for i = 0, cmd_count-1 do
        func = MCFGGetParamString("CFG_UNET3_TELNETD_CMD_FUNC", i)
        if func ~= "" then
            fprintf(fout, "    {%s, \"%s\", \"%s\", \"%s\", %d},\n", func, 
            MCFGGetParamString("CFG_UNET3_TELNETD_CMD_NAME", i), MCFGGetParamString("CFG_UNET3_TELNETD_CMD_DESCR", i), 
            MCFGGetParamString("CFG_UNET3_TELNETD_CMD_USAGE", i), MCFGGetParamInteger("CFG_UNET3_TELNETD_CMD_ARGNUM", i))
        end
    end
    fprintf(fout, "    {0x00, 0x00, 0x00, 0x00, 0}    /* Terminate mark (Do not change) */\n")
    fprintf(fout, "};\n")

    -- End
    fprintf(fout, "\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
