--[[
  @file     snmp_mib_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/07/08    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    descr       = MCFGGetParamString("CFG_UNET3_SNMP_MIB_SYS_DESCR", 0)
    objid       = MCFGGetParamString("CFG_UNET3_SNMP_MIB_SYS_OBJECTID", 0)
    contact     = MCFGGetParamString("CFG_UNET3_SNMP_MIB_SYS_CONTACT", 0)
    name        = MCFGGetParamString("CFG_UNET3_SNMP_MIB_SYS_NAME", 0)
    loc         = MCFGGetParamString("CFG_UNET3_SNMP_MIB_SYS_LOCATION", 0)
    services    = MCFGGetParamInteger("CFG_UNET3_SNMP_MIB_SYS_SERVICES", 0)
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    SNMP MIB definition\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __SNMP_MIB_CFG_H__\n")
    fprintf(fout, "#define __SNMP_MIB_CFG_H__\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* MIB strings */\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysDescr (1.3.6.1.2.1.1.1) */\n")
    fprintf(fout, "/* System name and version */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_DESCR_LEN    (%d + 1)    /* Maximum string size (with null terminator) */\n", string.len(descr))
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_DESCR        \"%s\"\n", descr)
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysObjectID (1.3.6.1.2.1.1.2) */\n")
    fprintf(fout, "/* Vendor object ID (sysObjectID and Enterprise field of trap(v1)) */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_OBJECTID_LEN    (%d + 1)\n", string.len(objid))
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_OBJECTID        \"%s\"\n", objid)
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysContact (1.3.6.1.2.1.1.4) */\n")
    fprintf(fout, "/* Mail address */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_CONTACT_LEN    (%d + 1)\n", string.len(contact))
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_CONTACT        \"%s\"\n", contact)
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysName (1.3.6.1.2.1.1.5) */\n")
    fprintf(fout, "/* Domain name */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_NAME_LEN    (%d + 1)\n", string.len(name))
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_NAME        \"%s\"\n", name)
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysLocation (1.3.6.1.2.1.1.6) */\n")
    fprintf(fout, "/* Physical location */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_LOCATION_LEN    (%d + 1)\n", string.len(loc))
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_LOCATION        \"%s\"\n", loc)
    fprintf(fout, "\n")
    fprintf(fout, "/* System sysServices (1.3.6.1.2.1.1.7) */\n")
    fprintf(fout, "/* Service number */\n")
    fprintf(fout, "#define CFG_SNMP_MIB_SYS_SERVICES   %d    /* Application layer */\n", services)
    fprintf(fout, "\n")
    fprintf(fout, "#endif   /* __SNMP_MIB_CFG_H__ */\n")

    -- End
    fprintf(fout, "\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end


