require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    Support function
--]]

function bytetbl(n, cnt)
    fprintf(fout, "0x%02x, ", n)
    if (cnt % 8) == 7 then
        fprintf(fout, "\n")
    end
end

-- ֐錾֐̂ݒo
-- Ex.) Get "temp_net_ini" from "ER temp_net_ini(UH dev_num)"
function extract_funcname(decl)
    local m = "#err#"
    if decl ~= nil then
        m = string.match(decl, "[^%s]+%s+([^%s(]+).+")
        if m == nil then
          m = decl
        end
    end
    
    return m
end

-- lbg[NC^tF[X̃N^Cv(g)
-- Ex.) "Ethernet0" -> {"Ethernet","0"}, "Loopback" -> {"Loopback", nil}, "PPP0" -> {"PPP","0"}
function netif_linktype_ex(index)
    local name = MCFGGetParamString("CFG_UNET3_IFDEV", index)
    local num
    name, num = string.match(name, "([a-zA-Z]+)([0-9]*)")
    return name, num
end

-- lbg[NC^tF[X̃N^Cv
function netif_linktype(index)
    local name, num
    name, num = netif_linktype_ex(index)
    return name
end

-- w胊N^CvJEg
function netif_linktype_count(name)
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if netif_linktype(i) == name then
            count = count + 1
        end
    end
    return count
end


-- PPPfoCX
function netif_ppp_count()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if netif_linktype(i) == "PPP" then
            count  = count + 1
        end
    end
    return count
end

-- ADC@\gpC^tF[X
function count_adc_all()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 then
            count  = count + 1
        end
    end
    return count
end

function count_adc_static()
    local count = 0
    local nifnum = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, nifnum-1 do
        if MCFGGetParamInteger("CFG_UNET3_IF_CHECKDUP", i) == 1 and MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE", i) == 0 then
            count  = count + 1
        end
    end
    return count
end

-- t@Cϐɕϊ
-- ϐLnbVe[u
resource_hash = {}
function filename2variable(filename, cnt)
    local var = filename
    -- ʂȋ󔒏
    --var = string.match(var, "(%S+)")
    -- t@C擾
    var = uC3.path_basename(var)
    -- Xy[XAhbg̓A_[XRAɕϊ
    var = string.gsub(var, " ", "_")
    var = string.gsub(var, "%.", "_")
    -- t@C͏d邱Ƃ̂
    -- dh߂ɘAԂǉ
    var = var..cnt
    -- tpXL[ƂănbVŊǗ
    resource_hash[filename] = var
    return var
end

-- \PbgIDIPver擾
function socid2ipver(id)
    local ver = 0
    local count = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    for i = 0, count-1 do
        if MCFGGetParamString("CFG_UNET3_SOCID", i) == id then
            ver = MCFGGetParamInteger("CFG_UNET3_SOC_IPVER", i)
            break
        end
    end
    return ver
end

function is_uniq_resource(res, cur) 
    for i = 0, cur-1 do 
        if res == MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i) then
            return false
        end
    end
    return true
end

-- ̍(orE)ɃXy[X߂
function fill_spc(str, cnt, left)
    local fmt = "%" .. ((left == 0) and "" or "-") .. cnt .. "s"
    local s = string.format(fmt, str)
    return s
end

--[[
    main function
--]]
function main()
    -- Variables
    tcp_count   = MCFGGetParamInteger("CFG_UNET3_SOC_TCP_COUNT", 0)
    udp_count   = MCFGGetParamInteger("CFG_UNET3_SOC_UDP_COUNT", 0)
    soc_count   = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    dhcp_count  = MCFGGetParamInteger("CFG_UNET3_IF_DHCP_USE_COUNT", 0)
    httpd_use   = MCFGGetParamInteger("CFG_UNET3_HTTPD_USE", 0)
    ipv6_use    = MCFGGetParamInteger("CFG_UNET3_IPV6_USE", 0)
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local spc_cnt
    
    -- BSD variables
    bsd_tcps = 0
    bsd_udps = 0
    bsd_tsks = 0
    bsd_use     = MCFGGetParamInteger("CFG_UNET3_BSDWRP_USE", 0)
    if bsd_use == 1 then
        bsd_tcps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_TCPS_NUM", 0)
        bsd_udps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_UDPS_NUM", 0)
        bsd_tsks    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_TSKS_NUM", 0)
        
        tcp_count   = tcp_count + bsd_tcps
        udp_count   = udp_count + bsd_udps
        soc_count   = soc_count + bsd_tcps + bsd_udps
    end
    use_hw_os = MCFGGetParamInteger("CFG_UNET3_ETHER_NET_HW_OS", 0)

    dynamic_tcp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_TCP_MAX", 0)
    dynamic_udp_count = MCFGGetParamInteger("CFG_UNET3_DYNAMIC_UDP_MAX", 0)
    static_tcp_count = MCFGGetParamInteger("CFG_UNET3_STATIC_TCP_MAX", 0)
    static_udp_count = MCFGGetParamInteger("CFG_UNET3_STATIC_UDP_MAX", 0)

    tcp_count = tcp_count + dynamic_tcp_count
    udp_count = udp_count + dynamic_udp_count
    soc_count = soc_count + dynamic_tcp_count + dynamic_udp_count

    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / NETWORK\n")
    fprintf(fout, "    User configuration header\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef NETCFG_H\n")
    fprintf(fout, "#define NETCFG_H\n")
    fprintf(fout, "#ifdef __cplusplus\n")
    fprintf(fout, "extern \"C\" {\n")
    fprintf(fout, "#endif\n")
    -- fprintf(fout, "\n")      -- net_def.hɑt@C̈ˑ݂邽߃CN[h͌ʂōs
    -- fprintf(fout, "#include \"net_def.h\"\n")
    fprintf(fout, "\n")
    fprintf(fout, "#define CFG_NET_DEV_MAX         %d\n", netif_count)
    fprintf(fout, "#define CFG_NET_SOC_MAX         %d\n", soc_count)
    fprintf(fout, "#define CFG_NET_TCP_MAX         %d\n", tcp_count)
    fprintf(fout, "#define CFG_NET_DYNAMIC_TCP_MAX %d\n", dynamic_tcp_count)
    fprintf(fout, "#define CFG_NET_DYNAMIC_UDP_MAX %d\n", dynamic_udp_count)
    fprintf(fout, "#define CFG_NET_STATIC_TCP_MAX  %d\n", static_tcp_count)
    fprintf(fout, "#define CFG_NET_STATIC_UDP_MAX  %d\n", static_udp_count)
    fprintf(fout, "#define CFG_NET_ARP_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_ARPMAX", 0)) --DEF_NET_ARP_MAX\n")
    fprintf(fout, "#define CFG_NET_MGR_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_MGRMAX", 0))--DEF_NET_MGR_MAX\n")
    fprintf(fout, "#define CFG_NET_IPR_MAX         %d\n", MCFGGetParamInteger("CFG_UNET3_IPRMAX", 0))--DEF_NET_IPR_MAX\n")
    -- RZ/T̏ꍇABUF_SZl + 40Ȃ΂Ȃ
    if use_hw_os == 0 then
        fprintf(fout, "#define CFG_NET_BUF_SZ          %d\n", MCFGGetParamInteger("CFG_UNET3_NETBUF_SIZE", 0))
    else
        fprintf(fout, "#define CFG_NET_BUF_SZ          %d + 40\n", MCFGGetParamInteger("CFG_UNET3_NETBUF_SIZE", 0))
    end
    fprintf(fout, "#define CFG_NET_BUF_CNT         %d\n", MCFGGetParamInteger("CFG_UNET3_NETBUF_CNT", 0) + MCFGGetParamInteger("CFG_UNET3_RXBUFFER_CNT", 0))
    -- RZ/T̏ꍇAOFFSETl + 40Ȃ΂Ȃ
    if use_hw_os == 0 then
        fprintf(fout, "#define CFG_NET_BUF_OFFSET      DEF_NET_BUF_OFFSET\n")
    else
        fprintf(fout, "#define CFG_NET_BUF_OFFSET      (DEF_NET_BUF_OFFSET + 40)\n")
    end
    fprintf(fout, "#define CFG_PATH_MTU            %d\n", MCFGGetParamInteger("CFG_UNET3_IFMTU_MAX", 0))
    fprintf(fout, "#define CFG_ARP_RET_CNT         %d\n", MCFGGetParamInteger("CFG_UNET3_ARP_RET_CNT", 0)) --DEF_ARP_RET_CNT\n")
    fprintf(fout, "#define CFG_ARP_RET_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_ARP_RET_TMO", 0)) --DEF_ARP_RET_TMO\n")
    fprintf(fout, "#define CFG_ARP_CLR_TMO         %d*60*1000\n", MCFGGetParamInteger("CFG_UNET3_ARP_CLR_TMO", 0)) --DEF_ARP_CLR_TMO\n")
    fprintf(fout, "#define CFG_IP4_TTL             %d\n", MCFGGetParamInteger("CFG_UNET3_IP4_TTL", 0)) --DEF_IP4_TTL\n")
    fprintf(fout, "#define CFG_IP4_TOS             %d\n", MCFGGetParamInteger("CFG_UNET3_IP4_TOS", 0)) --DEF_IP4_TOS\n")
    fprintf(fout, "#define CFG_IP4_IPR_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_IP4_IPR_TMO", 0))--DEF_IP4_IPR_TMO\n")
    fprintf(fout, "#define CFG_IP4_MCAST_TTL       DEF_IP4_MCAST_TTL\n")
    fprintf(fout, "#define CFG_IGMP_V1_TMO         DEF_IGMP_V1_TMO\n")
    fprintf(fout, "#define CFG_IGMP_REP_TMO        DEF_IGMP_REP_TMO\n")
    fprintf(fout, "#define CFG_TCP_MSS             (CFG_PATH_MTU-40)\n")
    fprintf(fout, "#define CFG_TCP_MSS_IPV6        (CFG_PATH_MTU-60)\n")
    fprintf(fout, "#define CFG_TCP_RTO_INI         DEF_TCP_RTO_INI\n")
    fprintf(fout, "#define CFG_TCP_RTO_MIN         DEF_TCP_RTO_MIN\n")
    fprintf(fout, "#define CFG_TCP_RTO_MAX         DEF_TCP_RTO_MAX\n")
    fprintf(fout, "#define CFG_TCP_SND_WND         %d\n", MCFGGetParamInteger("CFG_UNET3_SOC_DEFAULT_SNDBUF", 0))
    fprintf(fout, "#define CFG_TCP_RCV_WND         %d\n", MCFGGetParamInteger("CFG_UNET3_SOC_DEFAULT_RCVBUF", 0))
    fprintf(fout, "#define CFG_TCP_DUP_CNT         DEF_TCP_DUP_CNT\n")
    fprintf(fout, "#define CFG_TCP_CON_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_CON_TMO", 0))--DEF_TCP_CON_TMO\n")
    fprintf(fout, "#define CFG_TCP_SND_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_SND_TMO", 0))--DEF_TCP_SND_TMO\n")
    fprintf(fout, "#define CFG_TCP_CLS_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_CLS_TMO", 0))--DEF_TCP_CLS_TMO\n")
    fprintf(fout, "#define CFG_TCP_CLW_TMO         DEF_TCP_CLW_TMO\n")
    fprintf(fout, "#define CFG_TCP_ACK_TMO         DEF_TCP_ACK_TMO\n")
    fprintf(fout, "#ifdef KEEPALIVE_SUP\n")
    fprintf(fout, "#define CFG_TCP_KPA_CNT         %d\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_CNT", 0)) --DEF_TCP_KPA_CNT\n")
    fprintf(fout, "#define CFG_TCP_KPA_INT         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_INT", 0)) --DEF_TCP_KPA_INT\n")
    fprintf(fout, "#define CFG_TCP_KPA_TMO         %d*1000\n", MCFGGetParamInteger("CFG_UNET3_TCP_KPA_TMO", 0)) --DEF_TCP_KPA_TMO\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "#define CFG_PKT_RCV_QUE         %d\n", MCFGGetParamInteger("CFG_UNET3_PKT_RCV_QUE", 0)) --DEF_PKT_RCV_QUE\n")
    -- CFG_UNET3_PKT_UNREACH:           Bit 0
    -- CFG_UNET3_IP4_IGNORE_CHECKSUM:   Bit 1
    -- CFG_UNET3_TCP_IGNORE_CHECKSUM:   Bit 2
    -- CFG_UNET3_UDP_IGNORE_CHECKSUM:   Bit 3
    local ctlflg = 0
    val0 = MCFGGetParamInteger("CFG_UNET3_PKT_UNREACH", 0)
    val1 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_IP4_IGNORE_CHECKSUM", 0), 1)
    val2 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_TCP_IGNORE_CHECKSUM", 0), 2)
    val3 = bit.lshift(MCFGGetParamInteger("CFG_UNET3_UDP_IGNORE_CHECKSUM", 0), 3)
    ctlflg = bit.bor(val0, val1)
    ctlflg = bit.bor(ctlflg, val2)
    ctlflg = bit.bor(ctlflg, val3)
    fprintf(fout, "#define CFG_PKT_CTL_FLG         0x%04x\n", ctlflg)
    fprintf(fout, "#ifdef ACD_SUP\n")
    fprintf(fout, "#define CFG_ARP_PRB_WAI         DEF_ARP_PRB_WAI\n")
    fprintf(fout, "#define CFG_ARP_PRB_NUM         DEF_ARP_PRB_NUM\n")
    fprintf(fout, "#define CFG_ARP_PRB_MIN         DEF_ARP_PRB_MIN\n")
    fprintf(fout, "#define CFG_ARP_PRB_MAX         DEF_ARP_PRB_MAX\n")
    fprintf(fout, "#define CFG_ARP_ANC_WAI         DEF_ARP_ANC_WAI\n")
    fprintf(fout, "#define CFG_ARP_ANC_NUM         DEF_ARP_ANC_NUM\n")
    fprintf(fout, "#define CFG_ARP_ANC_INT         DEF_ARP_ANC_INT\n")
    fprintf(fout, "#endif\n")
    if ipv6_use == 1 then
        fprintf(fout, "#define CFG_NET6_BUF_SZ         DEF_NET6_BUF_SZ\n")
        fprintf(fout, "#define CFG_NEIGH_CACHE         %d\n", MCFGGetParamInteger("CFG_UNET3_NEIGH_CACHE", 0))
        fprintf(fout, "#define CFG_DST_CACHE           %d\n", MCFGGetParamInteger("CFG_UNET3_DST_CACHE", 0))
        fprintf(fout, "#define CFG_RTR_LST             %d\n", MCFGGetParamInteger("CFG_UNET3_RTR_LST", 0))
        fprintf(fout, "#define CFG_PRFX_LST            %d\n", MCFGGetParamInteger("CFG_UNET3_PRFX_LST", 0))
        fprintf(fout, "#define CFG_PMTU_CACHE          %d\n", MCFGGetParamInteger("CFG_UNET3_PMTU_CACHE", 0))
    end
    fprintf(fout, "#define CFG_NET_TSK_PRI         4\n")        -- 
    fprintf(fout, "#define CFG_NET_TSK_SIZ         1024\n")     -- 
    fprintf(fout, "#define CFG_STS_UPD_RES         %d\n", MCFGGetParamInteger("CFG_UNET3_STS_UPD_RES", 0))

    local rte_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_RTE_COUNT", 0)
    local nat_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_NATTBL_SIZE", 0)
    local flt_num = MCFGGetParamInteger("CFG_UNET3_FORWARDING_FLTTBL_SIZE", 0)
    local use_addr_conv = MCFGGetParamInteger("CFG_UNET3_FORWARDING_NAT_CONVERT", 0)
    if use_addr_conv == 0 then
        nat_num = 0
        flt_num = 0
    end

    fprintf(fout, "#define CFG_RTE_NUM             %u\n", rte_num)
    fprintf(fout, "#define CFG_NAT_NUM             %u\n", nat_num)
    fprintf(fout, "#define CFG_FLT_NUM             %u\n", flt_num)
    if use_addr_conv == 0 then
        fprintf(fout, "#define CFG_NAT_TCP_TTL         0\n")
        fprintf(fout, "#define CFG_NAT_UDP_TTL         0\n")
        fprintf(fout, "#define CFG_NAT_ICMP_TTL        0\n")
    else
        fprintf(fout, "#define CFG_NAT_TCP_TTL         %u\n", MCFGGetParamInteger("CFG_UNET3_FORWARDING_LTIME_TCP", 0))
        fprintf(fout, "#define CFG_NAT_UDP_TTL         %u\n", MCFGGetParamInteger("CFG_UNET3_FORWARDING_LTIME_UDP", 0))
        fprintf(fout, "#define CFG_NAT_ICMP_TTL        %u\n", MCFGGetParamInteger("CFG_UNET3_FORWARDING_LTIME_ICMP", 0))
    end

    fprintf(fout, "\n")
    
	local ppp_ver       = MCFGGetParamInteger("CFG_UNET3_PPP_VER", 0)
	if (1 < ppp_ver) then 	    -- PPP ver2.xx
		fprintf(fout, "#define CFG_PPP_DEV_MAX         %d\n", netif_ppp_count())
		fprintf(fout, "\n")
	end
    
    
    if bsd_use == 1 then
        fprintf(fout, "/* uNet3/BSD wrapper settings */\n")
        -- fprintf(fout, "#define CFG_BSD_SOC_MAX         %d\n", bsd_tcps + bsd_udps)   -- IȊg\
        fprintf(fout, "#define CFG_BSD_TCP_MAX         %d\n", bsd_tcps)
        fprintf(fout, "#define CFG_BSD_TCP_TOP         1\n")
        fprintf(fout, "#define CFG_BSD_TCP_SBUFSZ      1024\n")
        fprintf(fout, "#define CFG_BSD_TCP_RBUFSZ      1024\n")
        fprintf(fout, "#define CFG_BSD_UDP_MAX         %d\n", bsd_udps)
        fprintf(fout, "#define CFG_BSD_UDP_TOP         %d\n", tcp_count + 1)
        fprintf(fout, "#define CFG_TASK_MAX            %d\n", bsd_tsks)
        fprintf(fout, "\n")
    end    
    
    fprintf(fout, "#ifdef __cplusplus\n")
    fprintf(fout, "}\n")
    fprintf(fout, "#endif\n")
    fprintf(fout, "#endif /* NETCFG_H */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
