--[[
/**
 * @file       net_main.tmp.lua
 * @author     Copyright (c) 2012-2015 eForce Co.,Ltd. All Rights Reserved.
 * @brief      main.cuNet3̃XPgR[hǉ
 *
 * @revision   - 1.00 (2012-07-11)
 *                Initial version.
 *             - 1.01 (2013-03-27)
 *                HTTPdgpȂƂCGIt@NVo͂Ȃ悤ɏC
 *             - 1.02 (2013-06-06)
 *                DHCPd̃R[obN֐o
 *             - 1.03 (2014-07-08)
 *                NetDeṽR[obN֐o
 *                SNMP̃R[obN֐o
 *             - 1.04 (2015-03-22)
 *                uNet3/BSD̏R[hǉ
 *             - 1.06 (2015-06-03)
 *                HTTPd̊g@\R[obN֐o
 */
--]]
require("uC3")
-- Alias
fprintf = uC3.fprintf

--[[
    Support function
--]]

-- cgiRec擾
function get_cgi_count()
    local cnt = 0
    local contents_count = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0)
    for i = 0, contents_count-1 do
        if "cgi" == MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_TYPE", i) then
            cnt = cnt +1
        end
    end
    return cnt
end

-- CGIXPg̏o
-- @param fd t@CfBXNv^
function out_cgi_skelton(fd)
    fprintf(fd, "\n/*******************************\n")
    fprintf(fd, "  CGI Script\n")
    fprintf(fd, " ******************************/\n")
    local cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_CONTENT_COUNT", 0)
    for i = 0, (cnt-1) do
        if "cgi" == MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_TYPE", i) then
            func = MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i)
            if is_uniq_resource(func, i) == true then
                fprintf(fd, "void %s(T_HTTP_SERVER *http)\n", func)
                fprintf(fd, "{\n}\n")
            end
        end
    end
end

-- \[X̏d`FbN
function is_uniq_resource(res, cur)
    if cur > 0 then
        for i = 0, (cur-1) do
            if res == MCFGGetParamString("CFG_UNET3_HTTPD_CONTENT_RES", i) then
                return false
            end
        end
    end
    return true
end

-- DHCPd֘A
function is_uniq_altfunc(func, cur) 
    for i = 0, cur-1 do 
        if func == MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i) then
            return false
        end
    end
    return true
end
function out_alt_func_skelton(fd)
    local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
    for i = 0, (session_cnt-1) do
        func = MCFGGetParamString("CFG_UNET3_DHCPD_ALT_CALLBACK", i)
        if func ~= "" then
            if is_uniq_altfunc(func, i) == true then
                fprintf(fd, "\n")
                fprintf(fd, "/*******************************\n")
                fprintf(fd, "    %s\n", func)
                fprintf(fd, " *******************************/\n")
                fprintf(fd, "void %s(ID type, T_DHCP_RESOURCE * dat)\n", func)
                fprintf(fd, "{\n}\n")
            end
        end
    end
end

function out_httpdext_cbk_skelton(fd)
    local cbk = MCFGGetParamString("CFG_UNET3_HTTPD_EXT_CBK", 0)
    if (cbk ~= "") and (cbk ~= nil) then
        fprintf(fd, "\n")
        fprintf(fd, "/*******************************\n")
        fprintf(fd, "  HTTPd Extension Callback\n", cbk)
        fprintf(fd, " *******************************/\n")
        fprintf(fd, "ER %s(T_HTTP_SERVER *http, const T_HTTP_FILE *fp, UB evt)\n", cbk)
        fprintf(fd, "{\n}\n")
    end
end


function out_snmp_cbk_skelton(fd)
    local cbk = MCFGGetParamString("CFG_UNET3_SNMP_CBK", 0)
    if (cbk ~= "") and (cbk ~= nil) then
        fprintf(fd, "\n")
        fprintf(fd, "/*******************************\n")
        fprintf(fd, "    %s\n", cbk)
        fprintf(fd, " *******************************/\n")
        fprintf(fd, "ER %s(T_SNMP_CFG_CBK_DAT* dat)\n", cbk)
        fprintf(fd, "{\n}\n")
    end
end

-- NetDeṽR[obN֐
function ifdev_cbk_count()
    local netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    local count = 0
    for i = 0, netif_count-1 do
        local cbk = MCFGGetParamString("CFG_UNET3_IF_CBK", i)
        if (cbk ~= "") and (cbk ~= "0") then
            count = count + 1
        end
    end
    return count
end

function out_ifdev_cbk_skelton(fd)
    local netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    local ops_map = {}
    for i = 0, netif_count-1 do
        local cbk = MCFGGetParamString("CFG_UNET3_IF_CBK", i)
        if (cbk ~= "") and (cbk ~= "0") then
            if table.contains(ops_map, cbk) == false then
                table.insert(ops_map, cbk)
            end
        end
    end
    -- out
    for _, ops in pairs(ops_map) do
        fprintf(fd, "\n")
        fprintf(fd, "/*******************************\n")
        fprintf(fd, "    %s\n", ops)
        fprintf(fd, " *******************************/\n")
        fprintf(fd, "void %s(UH dev_num, UH evt, VP sts)\n", ops)
        fprintf(fd, "{\n}\n")
    end
end

--[[
    main function
--]]
fullpath = MCFGGetOutputFile()
parent = uC3.path_parent(fullpath)
source =  parent .. "\\main.c"
destination = parent .. "\\net_main.tmp"

function main()
    local fhs, fhd, buf, estr, ecode
    local skey
    local httpd_use = MCFGGetParamInteger("CFG_UNET3_HTTPD_USE", 0)
    local init_tsk  = MCFGGetParamString("CFG_UNET3_INITTSK_NAME", 0) 
    local version   = MCFGGetParamInteger("CFG_UNET3_VERSION", 0)
    local ftpd_use  = 0
    local tftpd_use = 0
    local dhcpd_use = 0
    local sntpd_use = 0
    local httpd_ext_use = 0
    local snmp_use  = 0
    local bsd_use   = 0

    if version >= 300 then
        ftpd_use    = MCFGGetParamInteger("CFG_UNET3_FTPD_USE", 0)
        tftpd_use   = MCFGGetParamInteger("CFG_UNET3_TFTPD_USE", 0)
        dhcpd_use   = MCFGGetParamInteger("CFG_UNET3_DHCPD_USE", 0)
        sntpd_use   = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE", 0)
        httpd_ext_use = MCFGGetParamInteger("CFG_UNET3_HTTPD_EXT_USE", 0)
        snmp_use    = MCFGGetParamInteger("CFG_UNET3_SNMP_USE", 0)
        bsd_use     = MCFGGetParamInteger("CFG_UNET3_BSDWRP_USE", 0)
    end

    -- main.cI[v
    fhs, estr, ecode = io.open(source, "r")
    if fhs == nil then
        return false, estr, ecode
    end

    -- o̓t@C net_main.cI[v
    fhd, estr, ecode = io.open(destination, "w")
    if fhd == nil then
        fhs:close()
        return false, estr, ecode
    end
    
    -- main.c̓enet_main.cɃRs[
    local switch = 0  -- 0 = normal, 1 = init taskǂ݃[h
    for line in fhs:lines() do
        -- wb_̃GhZNVoANetwork֘Awb_[}
        skey = string.match(line, "%s*/%*%s*}}(%S+)%s*%*/")
        if skey == "UC3_INCLUDE" then
            fprintf(fhd, "#include \"net_hdr.h\"\n")
            fprintf(fhd, "#include \"net_id.h\"\n")
            if httpd_use == 1 then
                fprintf(fhd, "#include \"http_server.h\"\n")
            end
            if dhcpd_use == 1 then
                fprintf(fhd, "#include \"dhcp_server.h\"\n")
            end
            if snmp_use == 1 then
                fprintf(fhd, "#include \"snmp.h\"\n")
                fprintf(fhd, "#include \"snmp_cfg.h\"\n")
            end
        end
        
        -- Network֐}
        if init_tsk ~= "" then
            if switch == 0 then   
            -- ^XN̊JnZNVo
                skey = string.match(line, "%s*/%*%s*{{%S+%((%S+)%)%s*%*/")
                if skey == init_tsk then
                    if snmp_use == 1 and version >= 300 then
                        fprintf(fhd, "extern ER net_setup(VP);\n")
                    else
                        fprintf(fhd, "extern ER net_setup(void);\n")
                    end
                    if bsd_use == 1 then
                        fprintf(fhd, "extern ER unet3_bsd_init(void);\n")
                    end
                    
                    fprintf(fhd, "%s\n", line)
                    fprintf(fhd, "void %s(VP_INT exinf)\n", init_tsk)
                    fprintf(fhd, "{\n");
                    fprintf(fhd, "    ER ercd;\n")
                    if snmp_use == 1 and version >= 300 then
                        fprintf(fhd, "    UH nod_cnt;\n")
                    end
                    fprintf(fhd, "\n")
                    fprintf(fhd, "    /* Initialize uNet3 */\n");
                    if snmp_use == 1 and version >= 300 then
                        fprintf(fhd, "    ercd = net_setup(&nod_cnt);\n")
                    else
                        fprintf(fhd, "    ercd = net_setup();\n")
                    end
                    fprintf(fhd, "    if (ercd != E_OK) {\n")
                    fprintf(fhd, "        return;\n")
                    fprintf(fhd, "    }\n")
                    if bsd_use == 1 then
                        fprintf(fhd, "\n")
                        fprintf(fhd, "    /* Initialize uNet3/BSD */\n");
                        fprintf(fhd, "    ercd = unet3_bsd_init();\n")
                        fprintf(fhd, "    if (ercd != E_OK) {\n")
                        fprintf(fhd, "        return;\n")
                        fprintf(fhd, "    }\n")
                    end
                    fprintf(fhd, "\n")
                    fprintf(fhd, "    for (;;) {\n")
                    fprintf(fhd, "        /* TODO: */\n");
                    fprintf(fhd, "        dly_tsk(1000);\n")
                    fprintf(fhd, "    }\n")
                    fprintf(fhd, "}\n")
                    --fprintf(fhd, "/* }}UC3_TASK */\n\n") 
                    switch = 1 -- ZNVGh܂ŋǂ݂
                end
            elseif switch == 1 then
                skey = string.match(line, "%s*/%*%s*}}(%S+)%s*%*/")
                if skey == "UC3_TASK" then
                    switch = 0
                end
            end
        end

        -- uC3R[hIoACGI֐o
        if (httpd_use == 1 and ((get_cgi_count() > 0) or (httpd_ext_use == 1))) or (dhcpd_use == 1) or (snmp_use == 1) or (ifdev_cbk_count() > 0) then
            if switch == 2 then
                switch = 0
            elseif switch == 0 then
                skey = string.match(line, "%s*/%*%s*}}(%S+)%s*%*/")
                if skey == "UC3_CODE" then
                    fprintf(fhd, "%s\n", line)
                    fprintf(fhd, "\n\n")
                    fprintf(fhd, "/* {{UNET3_CODE */\n")
                    if httpd_use == 1 and get_cgi_count() > 0 then
                        fprintf(fhd, "\n")
                        out_cgi_skelton(fhd)
                    end
                    if dhcpd_use == 1 then
                        out_alt_func_skelton(fhd)
                    end
                    if httpd_ext_use == 1 then
                        out_httpdext_cbk_skelton(fhd)
                    end
                    out_ifdev_cbk_skelton(fhd)
                    if snmp_use == 1 then
                        out_snmp_cbk_skelton(fhd)
                    end

                    fprintf(fhd, "\n")
                    fprintf(fhd, "/* }}UNET3_CODE */\n")
                    switch = 2 -- JgsXLbv
                end
            end
        end
        
        -- ȑÕobt@ۑ
        pline = line
        
        if switch == 0 then
            fprintf(fhd, "%s\n", line)
        end
    end

    fhd:close()
    fhs:close()
    return true, "", 0
end

-- Start
do
    --local ret, estr, ecode = pcall(main())
    --if pcall(foo) then
    --    -- no error
    --else
    --    -- few error
    --end
    local ret, estr, ecode = main()
    if ret == true then
        os.remove(source)
        os.rename(destination, source)
    else
        os.remove(destination)
    end
end
