/**
 * @file    DDR_RZT1_SCIF.h
 * @brief   RZ/T1 Serial communication interface
 * @date    2015.04.15
 * @author  Copyright (c) 2014-2015, eForce Co.,Ltd.  All rights reserved.
 *
 * @par     History
 *          - rev 1.0 (2014.10.03) i-cho
 *            Initial version.
 *          - rev 1.1 (2015.04.15) i-cho
 *            Corresponding to iodefine.h V0.8.
 */
#ifndef _DDR_RZT1_SCIF_H_
#define _DDR_RZT1_SCIF_H_

#ifdef __cplusplus
extern "C"
{
#endif

typedef union t_rzt1_scif_msts {
    UH          word;
    struct {
        UH                  init_flg:1;
        UH                  ena_tx:1;
        UH                  ena_rx:1;
        UH                  sft_flw:1;
        UH                  hrd_flw:1;
        UH                  sns_brk:1;
        UH                  tx_xoff:1;
        UH                  rx_xoff:1;
        UH                  req_xon_xoff:1;
        UH                  er_buf_ovr:1;
        UH                  dummy:6;
    } bit;
} T_RZT1_SCIF_MSTS;

typedef struct t_rzt1_scif_mng {
    T_RZT1_SCIF_MSTS        status;
    UH                      flgid;
    UH                      sndp;
    UH                      rcvp;
    UH                      tcnt;
    UH                      rcnt;
    UH                      tsize;
    UH                      rsize;
    UH                      tlockid;
    UH                      rlockid;
    UH                      xoff_size;
    UH                      xon_size;
    UH                      isrid[4];
    FP                      devhdr;
    volatile struct st_scifa *port;
    UW                      rxi_picbit;    /* Interrupt edge detection bit */
    UW                      txi_picbit;    /* Interrupt edge detection bit */
    T_COM_SND               *SndData;
    T_COM_RCV               *RcvData;
    VB                      *tbuf;
    VB                      *rbuf;
    UB                      *sbuf;
    UH                      aux[2];
} T_RZT1_SCIF_MNG;

#define TXI_FLG     0x00000001
#define RXI_FLG     0x00000002
#define TEI_FLG     0x00000004

ER _ddr_rzt1_scif_init(ID, volatile struct st_scifa *);

#ifdef __cplusplus
}
#endif

#endif  /* _DDR_RZT1_SCIF_H_ */
