/***************************************************************************
    Micro C Cube Standard, KERNEL
    ARMv7-R dependent internal edefinitions

    Copyright (c) 2014, eForce Co.,Ltd.  All rights reserved.

    Version Information
            2014.09.30: Created.
 ***************************************************************************/

#ifndef _UC3CPU_H_
#define _UC3CPU_H_


typedef struct t_intpara {
    UW      *savedt;
    UW      intinfo;
    FP      intfunc;
    T_ISR   *next;
} T_INTPARA;

typedef struct t_vinftbl {
    UW      intinfo;
    FP      intfunc;
    T_ISR   *next;
    T_ISR   *prev;
} T_VINFTBL;

typedef struct t_cortexr_defint {
    UW          cmd[11];
    FP          entry;
    T_VINFTBL   vinftbl;
} T_CORTEXR_DEFINT;

extern IMASK _kernel_get_imask(void);
extern IMASK _kernel_set_imask(IMASK imask);
extern void _kernel_start_multi_task(void);

#endif
