require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

--
function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Hardware dependent header\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _HW_DEP_H_\n")
    fprintf(fout, "#define _HW_DEP_H_\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"RZT1_UC3.h\"\n")
    fprintf(fout, "#include \"DDR_RZT1_VIC.h\"\n")
    fprintf(fout, "#include \"DDR_RZT1_CPG.h\"\n")
    if uC3Std.is_use_com() == true then
        fprintf(fout, "#include \"DDR_COM.h\"\n")
        fprintf(fout, "#include \"DDR_RZT1_SCIF.h\"\n")
    end
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* _HW_DEP_H_ */\n")
    fprintf(fout, "\n/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
