<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- CPUエントリ --> 
  <xsl:template match="CPU">
    <p><hr/></p>
    <h3>[CPU Configuration]</h3>
    <h4>CPU</h4>
    <table>
    <tr>
    <th>Vendor</th>
    <th>Model</th>
    <th>Target</th>
    </tr>
    <tr>
    <td><xsl:value-of select="chip/@vendor"/></td>
    <td><xsl:value-of select="chip/@name"/></td>
    <td><xsl:value-of select="chip/@target"/></td>
    </tr>
    </table>
    <xsl:apply-templates select="MPCore" />
    <h4>Clock</h4>
    <xsl:apply-templates select="Clock" />
    <xsl:apply-templates select="UART" />
    <h4>I/O Port &amp; MPC</h4>
    <xsl:apply-templates select="IO" />
  </xsl:template>

  <!-- MPCore -->
  <xsl:template match="MPCore">
    <xsl:apply-templates select="Core" />
  </xsl:template>

  <!-- Core -->
  <xsl:template match="Core">
    <h4><xsl:value-of select="@id"/></h4>
    <table>
      <tr>
        <th>Low Power Mode</th>
      </tr>
      <tr>
        <td>
          <xsl:choose>
            <xsl:when test="CFG_LOWPOWER_SLEEP=1">Enable</xsl:when>
            <xsl:when test="CFG_LOWPOWER_SLEEP='true'">Enable</xsl:when>
            <xsl:when test="CFG_LOWPOWER_SLEEP=0">Disable</xsl:when>
            <xsl:when test="CFG_LOWPOWER_SLEEP='false'">Disable</xsl:when>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <h4>Exception Handler</h4>
    <table>
      <tr>
        <th>Exception Number</th>
        <th>Exception Type</th>
        <th>Function Name</th>
      </tr>
      <xsl:apply-templates select="Exception" />
    </table>
  </xsl:template>

  <!-- 例外ハンドラ -->
  <xsl:template match="Exception">
    <tr>
      <td><xsl:value-of select="@no"/></td>
      <td><xsl:value-of select="@type"/></td>
      <td><xsl:value-of select="@hdr"/></td>
    </tr>
  </xsl:template>

  <!-- クロック -->
  <xsl:template match="Clock">
    <table>
      <tr>
        <th>Main Clock</th>
        <th>AUDIO_CLK</th>
        <th>CPUCKSEL</th>
        <th>CKIO</th>
      </tr>
      <tr>
        <td><xsl:value-of select="CFG_CLK_MAINCLK"/>Hz</td>
        <td><xsl:value-of select="CFG_CLK_AUDIOCLK"/>Hz</td>
        <td><xsl:value-of select="CFG_CLK_CPUCKSEL"/></td>
        <td><xsl:value-of select="CFG_CLK_CKIO"/></td>
      </tr>
    </table>
  </xsl:template>

  <!-- UART -->
  <xsl:template match="UART">
    <h4><xsl:value-of select="@name"/></h4>
    <table>
    <tr>
    <th>Use</th>
    <th>Device ID</th>
    <th>Interrupt level</th>
    <th>Tx buffer size</th>
    <th>Rx buffer size</th>
    <th>XOFF transmit level</th>
    <th>XON transmit level</th>
    <th>Rx FIFO Trigger</th>
    <th>Tx FIFO Trigger</th>
    <th>RTS Output Active Trigger</th>
    </tr>
    <tr>
    <td>
    <xsl:choose>
      <xsl:when test="@enable=1">Yes</xsl:when>
      <xsl:when test="@enable='true'">Yes</xsl:when>
      <xsl:when test="@enable=0">No</xsl:when>
      <xsl:when test="@enable='false'">No</xsl:when>
    </xsl:choose>
    </td>
    <td><xsl:value-of select="CFG_UARTID"/></td>
    <td><xsl:value-of select="CFG_UART_IPL"/></td>
    <td><xsl:value-of select="CFG_UART_TXBUFSZ"/></td>
    <td><xsl:value-of select="CFG_UART_RXBUFSZ"/></td>
    <td><xsl:value-of select="CFG_UART_XOFF"/></td>
    <td><xsl:value-of select="CFG_UART_XON"/></td>
    <td><xsl:value-of select="CFG_UART_RTRG"/></td>
    <td><xsl:value-of select="CFG_UART_TTRG"/></td>
    <td><xsl:value-of select="CFG_UART_RSTRG"/></td>
    </tr>
    </table>
  </xsl:template>


  <!-- IO -->
  <xsl:template match="PORT">
    <h4>PORT<xsl:value-of select="@m"/></h4>
    <table>
    <tr>
    <th>PDR</th>
    <th>PCR</th>
    <th>DSCR</th>
    <th>PODR</th>
    <th>PMR</th>
    </tr>
    <tr>
    <td><xsl:value-of select="CFG_PDR"/></td>
    <td><xsl:value-of select="CFG_PCR"/></td>
    <td><xsl:value-of select="CFG_DSCR"/></td>
    <td><xsl:value-of select="CFG_PMR"/></td>
    </tr>
    </table>
    <xsl:apply-templates select="MPC" />
  </xsl:template>
  
  <xsl:template match="IO">
    <xsl:apply-templates select="PORT" />
  </xsl:template>

  <xsl:template match="MPC">
    <h4>PFS</h4>
    <xsl:apply-templates select="CFG_PFS" />
  </xsl:template>
  
  <xsl:template match="CFG_PFS">
    <table>
    <tr>
    <th><xsl:value-of select="@name"/></th>
    <td><xsl:value-of select="."/></td>
    </tr>
    </table>
  </xsl:template>
  
  
</xsl:stylesheet>
