--[[
#===============================================================================
#
#       FILE:  kernel_cfg.c.lua
#
#       COMPANY: Copyright(c) 2014, eForce Co.,Ltd. All rights reserved.
#       HISTORY:
#       1. Date        : 2014.08.22
#          Author      : IlHun CHO
#          Description : Create. Supported GCC.
#                        VXȅkernel_cfg.cɈړ
#
#===============================================================================
--]]

require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

-- main entry
function main()
    local kernel = MCFGGetKernelStdCfg()
    local all_tsk_count = MCFGGetParamInteger("CFG_TSK_COUNT", 0)
    local usr_tsk_count = uC3Std.task_count_usr()
    local all_dtq_cnt = MCFGGetParamInteger("CFG_DTQ_COUNT", 0)
    local usr_dtq_cnt = uC3Std.dtq_count_usr()
    local all_mbx_cnt = MCFGGetParamInteger("CFG_MBX_COUNT", 0)
    local usr_mbx_cnt = uC3Std.mbx_count_usr()
    local all_mbf_cnt = MCFGGetParamInteger("CFG_MBF_COUNT", 0)
    local usr_mbf_cnt = uC3Std.mbf_count_usr()
    local all_mpf_cnt = MCFGGetParamInteger("CFG_MPF_COUNT", 0)
    local usr_mpf_cnt = uC3Std.mpf_count_usr()
    local all_mpl_cnt = MCFGGetParamInteger("CFG_MPL_COUNT", 0)
    local usr_mpl_cnt = uC3Std.mpl_count_usr()
    local all_sem_cnt = MCFGGetParamInteger("CFG_SEM_COUNT", 0)
    local usr_sem_cnt = uC3Std.sem_count_usr()
    local all_flg_cnt = MCFGGetParamInteger("CFG_FLG_COUNT", 0)
    local usr_flg_cnt = uC3Std.flg_count_usr()
    local all_dtq_cnt = MCFGGetParamInteger("CFG_DTQ_COUNT", 0)
    local usr_dtq_cnt = uC3Std.dtq_count_usr()
    local all_mbx_cnt = MCFGGetParamInteger("CFG_MBX_COUNT", 0)
    local usr_mbx_cnt = uC3Std.mbx_count_usr()
    local all_mtx_cnt = MCFGGetParamInteger("CFG_MTX_COUNT", 0)
    local usr_mtx_cnt = uC3Std.mtx_count_usr()
    local all_mbf_cnt = MCFGGetParamInteger("CFG_MBF_COUNT", 0)
    local usr_mbf_cnt = uC3Std.mbf_count_usr()
    local all_por_cnt = MCFGGetParamInteger("CFG_POR_COUNT", 0)
    local usr_por_cnt = uC3Std.por_count_usr()
    local all_mpf_cnt = MCFGGetParamInteger("CFG_MPF_COUNT", 0)
    local usr_mpf_cnt = uC3Std.mpf_count_usr()
    local all_mpl_cnt = MCFGGetParamInteger("CFG_MPL_COUNT", 0)
    local usr_mpl_cnt = uC3Std.mpl_count_usr()
    local all_cyc_cnt = MCFGGetParamInteger("CFG_CYC_COUNT", 0)
    local usr_cyc_cnt = uC3Std.cyc_count_usr()
    local all_alm_cnt = MCFGGetParamInteger("CFG_ALM_COUNT", 0)
    local usr_alm_cnt = uC3Std.alm_count_usr()
    local all_inh_cnt = MCFGGetParamInteger("CFG_INH_COUNT", 0)
    local usr_inh_cnt = uC3Std.inh_count_usr()
    local all_isr_cnt = MCFGGetParamInteger("CFG_ISR_COUNT", 0)
    local usr_isr_cnt = uC3Std.isr_count_usr()
    local all_dev_cnt = MCFGGetParamInteger("CFG_DEV_COUNT", 0)
    local usr_dev_cnt = uC3Std.dev_count_usr()
    local all_exc_cnt = MCFGGetParamInteger("CFG_EXC_COUNT", 0)
    local usr_exc_cnt = uC3Std.exc_count_usr()

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Kernel Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"kernel_cfg.h\"\n")
    fprintf(fout, "#include \"kernel_id.h\"\n")
    -- ǉwb_[
    if kernel:addheader() ~= "" and kernel:addheader() ~= nil then
        fprintf(fout, "#include \"%s\"\n", kernel:addheader())
    end
    fprintf(fout, "\n")

    -- System memory
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "        System memory allocate\n")
    fprintf(fout, " ******************************************************************/\n")
    fprintf(fout, "#ifdef __GNUC__\n")
    fprintf(fout, "long long SYSMEM[CFG_SYSMEM_SIZE/sizeof(long long)] __attribute__ ((section (\".sysmem\")));\n")
    fprintf(fout, "#endif\n")

    -- Stack memory
    if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "\n")
        fprintf(fout, "/******************************************************************\n")
        fprintf(fout, "        Stack memory allocate\n")
        fprintf(fout, " ******************************************************************/\n")
        fprintf(fout, "#ifdef __GNUC__\n")
        fprintf(fout, "long long STKMEM[CFG_STKMEM_SIZE/sizeof(long long)] __attribute__ ((section (\".stkmem\")));\n")
        fprintf(fout, "#endif\n")
    end

    -- Pool memory
    if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "\n")
        fprintf(fout, "/******************************************************************\n")
        fprintf(fout, "        Pool memory allocate\n")
        fprintf(fout, " ******************************************************************/\n")
        fprintf(fout, "#ifdef __GNUC__\n")
        fprintf(fout, "long long MPLMEM[CFG_MPLMEM_SIZE/sizeof(long long)] __attribute__ ((section (\".mplmem\")));\n")
        fprintf(fout, "#endif\n")
    end

    -- Local stack for Task
    if usr_tsk_count > 0 then
        fprintf(fout, "\n")
        fprintf(fout, "/******************************************************************\n")
        fprintf(fout, "        Local Stack allocate\n")
        fprintf(fout, " ******************************************************************/\n")
        fprintf(fout, "#ifdef __GNUC__\n")
        for i = 0, (all_tsk_count-1) do
            local tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false then
                fprintf(fout, "long long _%s_%d_stk[0x%X/sizeof(long long)] __attribute__ ((section (\".localstkmem\")));\n", tsk:task(), i, tsk:stksz())
            end
        end
        fprintf(fout, "#endif\n")
    end

    -- Local memory pool
    -- f[^L[A[{bNXAbZ[Wobt@AŒ蒷v[Aϒv[A
    if (usr_dtq_cnt+usr_mbx_cnt+usr_mbf_cnt+usr_mpf_cnt+usr_mpl_cnt) > 0 then
        fprintf(fout, "\n")
        fprintf(fout, "/******************************************************************\n")
        fprintf(fout, "        Local Pool Memory allocate\n")
        fprintf(fout, " ******************************************************************/\n")
        -- for DS-5
        fprintf(fout, "#ifdef __GNUC__\n")
        -- f[^L[
        if usr_dtq_cnt > 0 then
            fprintf(fout, "/* DataQueue */\n")
            for i = 0, all_dtq_cnt-1 do
                dtq = MCFGGetKernelStdDataQueue(i)
                if dtq:externaluse() == false and dtq:dtqcnt() > 0 then
                    fprintf(fout, "VP_INT _kernel_dtq%d_buf[%d] __attribute__ ((section (\".localmplmem\")));\n", i, dtq:dtqcnt())
                end
            end
        end
        -- [{bNX
        -- TA_MPRIw肳ꂽꍇAVXep͎̈gpȂBp̗̈kernel_cfg.cɒ`B
        if usr_mbx_cnt > 0 then
            fprintf(fout, "/* Mailbox */\n")
            for i = 0, all_mbx_cnt-1 do
                mbx = MCFGGetKernelStdMailbox(i)
                if mbx:externaluse() == false and bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
                    fprintf(fout, "VP _kernel_mbx%d_mprihd[TSZ_MPRIHD(%d)] __attribute__ ((section (\".localmplmem\")));\n", i, mbx:mbxmpri())
                end
            end
        end
        -- bZ[Wobt@
        if usr_mbf_cnt > 0 then
            fprintf(fout, "/* Message buffer */\n")
            for i = 0, all_mbf_cnt-1 do
                mbf = MCFGGetKernelStdMessageBuffer(i)
                if mbf:externaluse() == false and mbf:mbfsz() > 0 then
                    fprintf(fout, "UB _kernel_mbf%d_buf[%d] __attribute__ ((section (\".localmplmem\")));\n", i, mbf:mbfsz())
                end
            end
        end
        -- Œ蒷v[
        if usr_mpf_cnt > 0 then
            fprintf(fout, "/* Fixed-Sized Memory Pool */\n")
            for i = 0, all_mpf_cnt-1 do
                mpf = MCFGGetKernelStdFixedMemPool(i)
                if mpf:externaluse() == false then
                    if mpf:direct() == true then
                        fprintf(fout, "long long _kernel_mpf%d_buf[(%d*%d)/sizeof(long long)] __attribute__ ((section (\".localmplmem\")));\n", i, mpf:blkcnt(), mpf:blksz())
                    else 
                        fprintf(fout, "long long _kernel_mpf%d_buf[(%d*TSZ_MPF(1, (%s)))/sizeof(long long)] __attribute__ ((section (\".localmplmem\")));\n", i, mpf:blkcnt(), mpf:expression())
                    end
                end
            end
        end
        -- ϒv[
        if usr_mpl_cnt > 0 then
            fprintf(fout, "/* Variable-Sized Memory Pool */\n")
            for i = 0, all_mpl_cnt-1 do
                mpl = MCFGGetKernelStdVariableMemPool(i)
                if mpl:externaluse() == false then
                    fprintf(fout, "long long _kernel_mpl%d_buf[(%d)/sizeof(long long)] __attribute__ ((section (\".localmplmem\")));\n", i, mpl:mplsz())
                end
            end
        end
        fprintf(fout, "#endif\n")
    end
    
    --[[
        IuWFNg̐
    --]]
    fprintf(fout, "\n")
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "        Object Creation Information\n")
    fprintf(fout, " ******************************************************************/\n")
    -- Task
    if usr_tsk_count > 0 then
        for i = 0, (all_tsk_count-1) do
            local tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false then
                fprintf(fout, "extern void %s(VP_INT exinf);\n", tsk:task())
                fprintf(fout, "T_CTSK const _kernel_ctsk%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.tskatr2str(bit.bor(tsk:tskatr1(), tsk:tskatr2())))
                -- g
                if tsk:exinf() == nil or tsk:exinf() == "" then
                    fprintf(fout, "(VP_INT)0, ")
                else
                   fprintf(fout, "(VP_INT)%s, ", tsk:exinf())
                end
                -- ֐
                fprintf(fout, "(FP)%s, ", tsk:task())
                -- Dx
                fprintf(fout, "%d, ", tsk:itskpri())
                -- X^bNTCY
                fprintf(fout, "0x%X, ", tsk:stksz())
                -- X^bN̈
                fprintf(fout, "(VP)_%s_%d_stk, ", tsk:task(), i)
                -- IuWFNg
                if tsk:name() == nil or tsk:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", tsk:name())
                end
            end
        end
    end

    -- SEMAFORE
    if usr_sem_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_sem_cnt-1 do
            sem = MCFGGetKernelStdSemaphore(i)
            if sem:externaluse() == false then
                fprintf(fout, "T_CSEM const _kernel_csem%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.sematr2str(sem:sematr()))
                -- ̏l
                fprintf(fout, "%d, ", sem:isemcnt())
                -- ̍ől
                fprintf(fout, "%d, ", sem:maxsem())
                -- IuWFNg
                if sem:name() == nil or sem:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", sem:name())
                end
            end
        end
    end

    -- EVENT FLAG
    if usr_flg_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_flg_cnt-1 do
            flg = MCFGGetKernelStdEventFlage(i)
            if flg:externaluse() == false then
                fprintf(fout, "T_CFLG const _kernel_cflg%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.flgatr2str(flg:flgatr()))
                -- rbgp^[
                fprintf(fout, "0x%X, ", flg:iflgptn())
                -- IuWFNg
                if flg:name() == nil or flg:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", flg:name())
                end
            end
        end
    end
    
    -- DATA QUEUE
    if usr_dtq_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_dtq_cnt-1 do
            dtq = MCFGGetKernelStdDataQueue(i)
            if dtq:externaluse() == false then
                fprintf(fout, "T_CDTQ const _kernel_cdtq%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.dtqatr2str(dtq:dtqatr()))
                -- f[^
                fprintf(fout, "%d, ", dtq:dtqcnt())
                if dtq:dtqcnt() == 0 then
                    fprintf(fout, "(VP)0, ")
                else
                    fprintf(fout, "(VP)_kernel_dtq%d_buf, ", i)
                end
                -- IuWFNg
                if dtq:name() == nil or dtq:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", dtq:name())
                end
            end
        end
    end

    -- Mailbox
    if usr_mbx_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_mbx_cnt-1 do
            mbx = MCFGGetKernelStdMailbox(i)
            if mbx:externaluse() == false then
                fprintf(fout, "T_CMBX const _kernel_cmbx%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.mbxatr2str(mbx:mbxatr()))
                -- M郁bZ[W̗Dx̍ől
                fprintf(fout, "%d, ", mbx:mbxmpri())
                -- bZ[WL[wb_
                if bit.band(mbx:mbxatr(), uC3Std.TA_MPRI) ~= 0 then
                    fprintf(fout, "_kernel_mbx%d_mprihd, ", i)
                else 
                    fprintf(fout, "(VP)0, ")
                end
                -- IuWFNg
                if mbx:name() == nil or mbx:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", mbx:name())
                end
            end
        end
    end

    -- Mutex
    if usr_mtx_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_mtx_cnt-1 do
            mtx = MCFGGetKernelStdMutex(i)
            if mtx:externaluse() == false then
                fprintf(fout, "T_CMTX const _kernel_cmtx%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.mtxatr2str(mtx:mtxatr()))
                -- Dx
                fprintf(fout, "%d, ", mtx:ceilpri())
                -- IuWFNg
                if mtx:name() == nil or mtx:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", mtx:name())
                end
            end
        end
    end

    -- Message Buffer
    if usr_mbf_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_mbf_cnt-1 do
            mbf = MCFGGetKernelStdMessageBuffer(i)
            if mbf:externaluse() == false then
                fprintf(fout, "T_CMBF const _kernel_cmbf%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.mbfatr2str(mbf:mbfatr()))
                -- őTCY
                fprintf(fout, "%d, ", mbf:maxmsz())
                -- ̈̃TCY
                fprintf(fout, "%d, ", mbf:mbfsz())
                -- ̈̐擪AhX
                if mbf:mbfsz() > 0 then
                    fprintf(fout, "(VP)_kernel_mbf%d_buf, ", i)
                else
                    fprintf(fout, "(VP)0, ")
                end
                -- IuWFNg
                if mbf:name() == nil or mbf:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                    fprintf(fout, "\"%s\"};\n", mbf:name())
                end
            end
        end
    end

    -- Rendezvous
    if usr_por_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_por_cnt-1 do
            por = MCFGGetKernelStdRendezvous(i)
            if por:externaluse() == false then
                fprintf(fout, "T_CPOR const _kernel_cpor%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.poratr2str(por:poratr()))
                -- ďobZ[W̍őTCY
                fprintf(fout, "%d, ", por:maxcmsz())
                -- ԓbZ[W̍őTCY
                fprintf(fout, "%d, ", por:maxrmsz())
                -- IuWFNg
                if por:name() == nil or por:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                    fprintf(fout, "\"%s\"};\n", por:name())
                end
            end
        end
    end

    -- Fixed-Sized Memory Pools
    if usr_mpf_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_mpf_cnt-1 do
            mpf = MCFGGetKernelStdFixedMemPool(i)
            if mpf:externaluse() == false then
                fprintf(fout, "T_CMPF const _kernel_cmpf%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.mpfatr2str(mpf:mpfatr()))
                -- ubN
                fprintf(fout, "%d, ", mpf:blkcnt())
                -- ubNTCY
                if mpf:direct() == true then
                    fprintf(fout, "%d, ", mpf:blksz())
                else
                    fprintf(fout, "TSZ_MPF(1, (%s)), ", mpf:expression())
                end
                -- v[̈̐擪Ԓn
                fprintf(fout, "(VP)_kernel_mpf%d_buf, ", i)
                -- IuWFNg
                if mpf:name() == nil or mpf:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                    fprintf(fout, "\"%s\"};\n", mpf:name())
                end
            end
        end
    end

    -- Variable-Sized Memory Pools
    if usr_mpl_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_mpl_cnt-1 do
            mpl = MCFGGetKernelStdVariableMemPool(i)
            if mpl:externaluse() == false then
                fprintf(fout, "T_CMPL const _kernel_cmpl%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.mplatr2str(mpl:mplatr()))
                -- TCY
                fprintf(fout, "%d, ", mpl:mplsz())
                -- v[̈̐擪Ԓn
                fprintf(fout, "(VP)_kernel_mpl%d_buf, ", i)
                -- IuWFNg
                if mpl:name() == nil or mpl:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                    fprintf(fout, "\"%s\"};\n", mpl:name())
                end
            end
        end
    end

    -- Cyclic Handlers
    if usr_cyc_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_cyc_cnt-1 do
            cyc = MCFGGetKernelStdCyclicHandler(i)
            if cyc:externaluse() == false then
                fprintf(fout, "extern void %s(VP_INT exinf);\n", cyc:cychdr())
                fprintf(fout, "T_CCYC const _kernel_ccyc%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.cycatr2str(cyc:cycatr()))
                -- g
                if cyc:exinf() == nil or cyc:exinf() == "" then
                    fprintf(fout, "(VP_INT)0, ")
                else
                   fprintf(fout, "(VP_INT)%s, ", cyc:exinf())
                end
                -- ֐
                fprintf(fout, "(FP)%s, ", cyc:cychdr())
                -- N
                fprintf(fout, "%d, ", cyc:cyctim())
                -- Nʑ
                fprintf(fout, "%d, ", cyc:cycphs())
                -- IuWFNg
                if cyc:name() == nil or cyc:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", cyc:name())
                end
            end
        end
    end

    -- Alarm Handlers
    if usr_alm_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_alm_cnt-1 do
            alm = MCFGGetKernelStdAlarmHandler(i)
            if alm:externaluse() == false then
                fprintf(fout, "extern void %s(VP_INT exinf);\n", alm:almhdr())
                fprintf(fout, "T_CALM const _kernel_calm%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.cycatr2str(alm:almatr()))
                -- g
                if alm:exinf() == nil or alm:exinf() == "" then
                    fprintf(fout, "(VP_INT)0, ")
                else
                   fprintf(fout, "(VP_INT)%s, ", alm:exinf())
                end
                -- ֐
                fprintf(fout, "(FP)%s, ", alm:almhdr())
                -- IuWFNg
                if alm:name() == nil or alm:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", alm:name())
                end
            end
        end
    end

    -- Overrun Handlers
    if kernel:enable_ovr() == true then
        fprintf(fout, "\n")
        ovr = MCFGGetKernelStdOverrunHandler(0)
        if ovr:externaluse() == false then
            fprintf(fout, "extern void %s(ID tskid, VP_INT exinf);\n", ovr:ovrhdr())
            fprintf(fout, "T_DOVR const _kernel_dovr = {")
            -- 
            fprintf(fout, "%s, ", uC3Std.ovratr2str(ovr:ovratr()))
            -- ֐
            fprintf(fout, "(FP)%s};\n", ovr:ovrhdr())
        
        end
    end

    -- Int Handlers
    if usr_inh_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_inh_cnt-1 do
            inh = MCFGGetKernelStdInh(i)
            if inh:externaluse() == false then
                fprintf(fout, "extern void %s(void);\n", inh:inthdr())
                fprintf(fout, "T_DINH const _kernel_dinh%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.inhatr2str(inh:inhatr()))
                -- ֐
                fprintf(fout, "(FP)%s, ", inh:inthdr())
                -- ݃x
                fprintf(fout, "%d};\n", inh:imask())
            end
        end
    end

    -- Interrupt Service Routine
    if usr_isr_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_isr_cnt-1 do
            isr = MCFGGetKernelStdIsr(i)
            if isr:externaluse() == false then
                fprintf(fout, "extern void %s(VP_INT exinf);\n", isr:isr())
                fprintf(fout, "T_CISR const _kernel_cisr%d = {", i)
                -- 
                fprintf(fout, "%s, ", uC3Std.isratr2str(isr:isratr()))
                -- g
                if isr:exinf() == nil or isr:exinf() == "" then
                    fprintf(fout, "(VP_INT)0, ")
                else
                   fprintf(fout, "(VP_INT)%s, ", isr:exinf())
                end
                -- ݔԍ
                fprintf(fout, "%d, ", isr:intno())
                -- ֐
                fprintf(fout, "(FP)%s, ", isr:isr())
                -- ݃x
                fprintf(fout, "%d};\n", isr:imask())
            end
        end
    end

    -- Device
    if usr_dev_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_dev_cnt-1 do
            dev = MCFGGetKernelStdDev(i)
            if dev:externaluse() == false then
                fprintf(fout, "extern void %s(ID funcid, VP ctrdev, VP ctrblk);\n", dev:devhdr())
                fprintf(fout, "T_CDEV const _kernel_cdev%d = {", i)
                -- pPbg
                if dev:ctrblk() == nil or dev:ctrblk() == "" then
                    fprintf(fout, "(VP)0, ")
                else
                   fprintf(fout, "%s, ", dev:ctrblk())
                end
                -- ֐
                fprintf(fout, "(FP)%s, ", dev:devhdr())
                -- IuWFNg
                if dev:name() == nil or dev:name() == "" then
                    fprintf(fout, "NULL};\n")
                else
                   fprintf(fout, "\"%s\"};\n", dev:name())
                end
            end
        end
    end
   
    -- CPU Exception Handler
    if usr_exc_cnt > 0 then
        fprintf(fout, "\n")
        for i = 0, all_exc_cnt-1 do
            exc = MCFGGetKernelStdExc(i)
            if exc:externaluse() == false and exc:exchdr() ~= nil and exc:exchdr() ~= "" then
                if exc:excno() == 2 then -- EXC_SVC
                    fprintf(fout, "extern void %s(UW svcno, UW *reg);\n", exc:exchdr())
                else 
                    fprintf(fout, "extern void %s(UW *reg, UW psr);\n", exc:exchdr())
                end
                fprintf(fout, "T_DEXC const _kernel_dexc%d = {TA_NULL, ", i)
                fprintf(fout, "(FP)%s};\n", exc:exchdr())
            end
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "        Initialize system creation information\n")
    fprintf(fout, " ******************************************************************/\n")
    -- O֐̐錾
    -- ACh֐
    if kernel:sysidl() ~= nil and kernel:sysidl() ~= "" then
        fprintf(fout, "extern void %s(void);\n", kernel:sysidl())
    end
    if MCFGGetParamInteger("CFG_LOWPOWER_SLEEP", 0) == 1 then
        fprintf(fout, "extern void lowpower_idle(void);\n")
    end
    -- X^bN
    if kernel:inistk() ~= nil and kernel:inistk() ~= "" and uC3Std.is_user_init(kernel:inistk()) == true then
        fprintf(fout, "extern void %s(INT* stk, SIZE size, ID id);\n", kernel:inistk())
    end
    fprintf(fout, "\n")
    fprintf(fout, "void init_csys(T_CSYS* pk_csys)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    /* Dummy access */\n")
    fprintf(fout, "    SYSMEM[0] = 0;\n")
    if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "    STKMEM[0] = 0;\n")
    end
    if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "    MPLMEM[0] = 0;\n")
    end
    fprintf(fout, "\n")
    fprintf(fout, "    pk_csys->tskpri_max = CFG_TSKPRI_MAX;\n")
    fprintf(fout, "    pk_csys->tskid_max = CFG_TSKID_MAX;\n")
    fprintf(fout, "    pk_csys->semid_max = CFG_SEMID_MAX;\n")
    fprintf(fout, "    pk_csys->flgid_max = CFG_FLGID_MAX;\n")
    fprintf(fout, "    pk_csys->dtqid_max = CFG_DTQID_MAX;\n")
    fprintf(fout, "    pk_csys->mbxid_max = CFG_MBXID_MAX;\n")
    fprintf(fout, "    pk_csys->mtxid_max = CFG_MTXID_MAX;\n")
    fprintf(fout, "    pk_csys->mbfid_max = CFG_MBFID_MAX;\n")
    fprintf(fout, "    pk_csys->porid_max = CFG_PORID_MAX;\n")
    fprintf(fout, "    pk_csys->mpfid_max = CFG_MPFID_MAX;\n")
    fprintf(fout, "    pk_csys->mplid_max = CFG_MPLID_MAX;\n")
    fprintf(fout, "    pk_csys->almid_max = CFG_ALMID_MAX;\n")
    fprintf(fout, "    pk_csys->cycid_max = CFG_CYCID_MAX;\n")
    fprintf(fout, "    pk_csys->isrid_max = CFG_ISRID_MAX;\n")
    fprintf(fout, "    pk_csys->devid_max = CFG_DEVID_MAX;\n")
    fprintf(fout, "    pk_csys->tick = CFG_TICK;\n")
    fprintf(fout, "    pk_csys->ssb_num = CFG_SSB_NUM;\n")
    fprintf(fout, "    pk_csys->sysmem_top = (VP)&SYSMEM[0];\n")
    fprintf(fout, "    pk_csys->sysmem_end = (VP)((ADDR)&SYSMEM[0]+sizeof(SYSMEM));\n")
    if MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "    pk_csys->stkmem_top = (VP)&STKMEM[0];\n")
        fprintf(fout, "    pk_csys->stkmem_end = (VP)((ADDR)&STKMEM[0]+sizeof(STKMEM));\n")
    else
        fprintf(fout, "    pk_csys->stkmem_top = (VP)0;\n")
        fprintf(fout, "    pk_csys->stkmem_end = (VP)0;\n")
    end
    if MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0) > 0 then
        fprintf(fout, "    pk_csys->mplmem_top = (VP)&MPLMEM[0];\n")
        fprintf(fout, "    pk_csys->mplmem_end = (VP)((ADDR)&MPLMEM[0]+sizeof(MPLMEM));\n")
    else
        fprintf(fout, "    pk_csys->mplmem_top = (VP)0;\n")
        fprintf(fout, "    pk_csys->mplmem_end = (VP)0;\n")
    end
    if MCFGGetParamInteger("CFG_LOWPOWER_SLEEP", 0) == 1 then
        fprintf(fout, "    pk_csys->sysidl = USER_IDLE(lowpower_idle);\n")
    else
        if kernel:sysidl() ~= nil and kernel:sysidl() ~= "" then
            fprintf(fout, "    pk_csys->sysidl = USER_IDLE(%s);\n", kernel:sysidl())
        else
            fprintf(fout, "    pk_csys->sysidl = SYSTEM_IDLE;\n")
        end
    end
    if kernel:inistk() == nil or kernel:inistk() == "" then
        fprintf(fout, "    pk_csys->inistk = STACK_ID_INIT;\n")
    elseif uC3Std.is_user_init(kernel:inistk()) == true then
        fprintf(fout, "    pk_csys->inistk = STACK_USER_INIT(%s);\n", kernel:inistk())
    else
        fprintf(fout, "    pk_csys->inistk = %s;\n", kernel:inistk())
    end
    fprintf(fout, "    pk_csys->trace = %s;\n", kernel:trace())
    fprintf(fout, "    pk_csys->agent = %s;\n", kernel:agent())
    fprintf(fout, "}\n")

    -- nh
    fprintf(fout, "\n")
    fprintf(fout, "/******************************************************************\n")
    fprintf(fout, "        OS Initialization Handler\n")
    fprintf(fout, " ******************************************************************/\n")
    fprintf(fout, "extern void _ddr_init(void);\n")
    fprintf(fout, "void initpr(void)\n")
    fprintf(fout, "{\n")

    -- CPUOnh
    if usr_exc_cnt > 0 then
        for i = 0, all_exc_cnt-1 do
            exc = MCFGGetKernelStdExc(i)
            if exc:externaluse() == false and exc:exchdr() ~= nil and exc:exchdr() ~= "" then
                fprintf(fout, "    def_exc(%s, (T_DEXC *)&_kernel_dexc%d);\n", uC3Std.excno2str(exc:excno()), i) 
            end
        end
    end

    -- ݃nh
    if usr_inh_cnt > 0 then
        for i = 0, all_inh_cnt-1 do
            inh = MCFGGetKernelStdInh(i)
            if inh:externaluse() == false then
                fprintf(fout, "    def_inh(%d, (T_DINH *)&_kernel_dinh%d);\n", inh:inhno(), i) 
            end
        end
    end

    -- I[onh
    if kernel:enable_ovr() == true then
        ovr = MCFGGetKernelStdOverrunHandler(0)
        if ovr:externaluse() == false then
            fprintf(fout, "    def_ovr((T_DOVR *)&_kernel_dovr);\n") 
        end
    end

    -- hCȍ
    fprintf(fout, "    _ddr_init();\n")

    -- eIuWFNg̐
    -- Task
    if usr_tsk_count > 0 then
        for i = 0, (all_tsk_count-1) do
            local tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false then
                fprintf(fout, "    %s = acre_tsk((T_CTSK *)&_kernel_ctsk%d);\n", tsk:tskid(), i) 
            end
        end
    end
    -- SEMAFORE
    if usr_sem_cnt > 0 then
        for i = 0, all_sem_cnt-1 do
            sem = MCFGGetKernelStdSemaphore(i)
            if sem:externaluse() == false then
                fprintf(fout, "    %s = acre_sem((T_CSEM *)&_kernel_csem%d);\n", sem:semid(), i) 
            end
        end
    end
    -- EVENT FLAG
    if usr_flg_cnt > 0 then
        for i = 0, all_flg_cnt-1 do
            flg = MCFGGetKernelStdEventFlage(i)
            if flg:externaluse() == false then
                fprintf(fout, "    %s = acre_flg((T_CFLG *)&_kernel_cflg%d);\n", flg:flgid(), i) 
            end
        end
    end
    -- DATA QUEUE
    if usr_dtq_cnt > 0 then
        for i = 0, all_dtq_cnt-1 do
            dtq = MCFGGetKernelStdDataQueue(i)
            if dtq:externaluse() == false then
                fprintf(fout, "    %s = acre_dtq((T_CDTQ *)&_kernel_cdtq%d);\n", dtq:dtqid(), i) 
            end
        end
    end
    -- Mailbox
    if usr_mbx_cnt > 0 then
        for i = 0, all_mbx_cnt-1 do
            mbx = MCFGGetKernelStdMailbox(i)
            if mbx:externaluse() == false then
                fprintf(fout, "    %s = acre_mbx((T_CMBX *)&_kernel_cmbx%d);\n", mbx:mbxid(), i) 
            end
        end
    end
    -- Mutex
    if usr_mtx_cnt > 0 then
        for i = 0, all_mtx_cnt-1 do
            mtx = MCFGGetKernelStdMutex(i)
            if mtx:externaluse() == false then
                fprintf(fout, "    %s = acre_mtx((T_CMTX *)&_kernel_cmtx%d);\n", mtx:mtxid(), i) 
            end
        end
    end
    -- Message Buffer
    if usr_mbf_cnt > 0 then
        for i = 0, all_mbf_cnt-1 do
            mbf = MCFGGetKernelStdMessageBuffer(i)
            if mbf:externaluse() == false then
                fprintf(fout, "    %s = acre_mbf((T_CMBF *)&_kernel_cmbf%d);\n", mbf:mbfid(), i) 
            end
        end
    end
    -- Rendezvous
    if usr_por_cnt > 0 then
        for i = 0, all_por_cnt-1 do
            por = MCFGGetKernelStdRendezvous(i)
            if por:externaluse() == false then
                fprintf(fout, "    %s = acre_por((T_CPOR *)&_kernel_cpor%d);\n", por:porid(), i) 
            end
        end
    end
    -- Fixed-Sized Memory Pools
    if usr_mpf_cnt > 0 then
        for i = 0, all_mpf_cnt-1 do
            mpf = MCFGGetKernelStdFixedMemPool(i)
            if mpf:externaluse() == false then
                fprintf(fout, "    %s = acre_mpf((T_CMPF *)&_kernel_cmpf%d);\n", mpf:mpfid(), i) 
            end
        end
    end
    -- Variable-Sized Memory Pools
    if usr_mpl_cnt > 0 then
        for i = 0, all_mpl_cnt-1 do
            mpl = MCFGGetKernelStdVariableMemPool(i)
            if mpl:externaluse() == false then
                fprintf(fout, "    %s = acre_mpl((T_CMPL *)&_kernel_cmpl%d);\n", mpl:mplid(), i) 
            end
        end
    end
    -- Cyclic Handlers
    if usr_cyc_cnt > 0 then
        for i = 0, all_cyc_cnt-1 do
            cyc = MCFGGetKernelStdCyclicHandler(i)
            if cyc:externaluse() == false then
                fprintf(fout, "    %s = acre_cyc((T_CCYC *)&_kernel_ccyc%d);\n", cyc:cycid(), i) 
            end
        end
    end
    -- Alarm Handlers
    if usr_alm_cnt > 0 then
        for i = 0, all_alm_cnt-1 do
            alm = MCFGGetKernelStdAlarmHandler(i)
            if alm:externaluse() == false then
                fprintf(fout, "    %s = acre_alm((T_CALM *)&_kernel_calm%d);\n", alm:almid(), i) 
            end
        end
    end
    -- Interrupt Service Routine
    if usr_isr_cnt > 0 then
        for i = 0, all_isr_cnt-1 do
            isr = MCFGGetKernelStdIsr(i)
            if isr:externaluse() == false then
                fprintf(fout, "    %s = acre_isr((T_CISR *)&_kernel_cisr%d);\n", isr:isrid(), i) 
            end
        end
    end
    -- Device
    if usr_dev_cnt > 0 then
        for i = 0, all_dev_cnt-1 do
            dev = MCFGGetKernelStdDev(i)
            if dev:externaluse() == false then
                fprintf(fout, "    vdef_dev(%s, (T_CDEV *)&_kernel_cdev%d);\n", dev:devid(), i) 
            end
        end
    end

    fprintf(fout, "}\n")
    
    fprintf(fout, "\n")
    fprintf(fout, "/* end */\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
