require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf


--[[
ドライバで使用している資源のIDは他で参照することはないので出力しない
--]]
function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Object ID definitions\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "\n")

    -- Task
    usr_cnt = uC3Std.task_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_TSK_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Task ID's */\n")
        for i = 0, all_cnt-1 do
            tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false then
                fprintf(fout, "ID %s;\n", tsk:tskid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Semaphore
    usr_cnt = uC3Std.sem_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_SEM_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Semaphore ID's */\n")
        for i = 0, all_cnt-1 do
            sem = MCFGGetKernelStdSemaphore(i)
            if sem:externaluse() == false then
                fprintf(fout, "ID %s;\n", sem:semid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Event Flag
    usr_cnt = uC3Std.flg_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_FLG_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Event Flag ID's */\n")
        for i = 0, all_cnt-1 do
            flg = MCFGGetKernelStdEventFlage(i)
            if flg:externaluse() == false then
                fprintf(fout, "ID %s;\n", flg:flgid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Data Queue
    usr_cnt = uC3Std.dtq_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_DTQ_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* DataQueue ID's */\n")
        for i = 0, all_cnt-1 do
            dtq = MCFGGetKernelStdDataQueue(i)
            if dtq:externaluse() == false then
                fprintf(fout, "ID %s;\n", dtq:dtqid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Mailbox
    usr_cnt = uC3Std.mbx_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_MBX_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Mailbox ID's */\n")
        for i = 0, all_cnt-1 do
            mbx = MCFGGetKernelStdMailbox(i)
            if mbx:externaluse() == false then
                fprintf(fout, "ID %s;\n", mbx:mbxid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Mutex
    usr_cnt = uC3Std.mtx_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_MTX_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Mutex ID's */\n")
        for i = 0, all_cnt-1 do
            mtx = MCFGGetKernelStdMutex(i)
            if mtx:externaluse() == false then
                fprintf(fout, "ID %s;\n", mtx:mtxid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Message Buffer
    usr_cnt = uC3Std.mbf_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_MBF_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Message buffer ID's */\n")
        for i = 0, all_cnt-1 do
            mbf = MCFGGetKernelStdMessageBuffer(i)
            if mbf:externaluse() == false then
                fprintf(fout, "ID %s;\n", mbf:mbfid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Rendezvous
    usr_cnt = uC3Std.por_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_POR_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Rendezvous ID's */\n")
        for i = 0, all_cnt-1 do
            por = MCFGGetKernelStdRendezvous(i)
            if por:externaluse() == false then
                fprintf(fout, "ID %s;\n", por:porid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Fixed-Sized Memory Pools
    usr_cnt = uC3Std.mpf_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_MPF_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Fixed-Sized Memory Pool ID's */\n")
        for i = 0, all_cnt-1 do
            mpf = MCFGGetKernelStdFixedMemPool(i)
            if mpf:externaluse() == false then
                fprintf(fout, "ID %s;\n", mpf:mpfid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Variable-Sized Memory Pools
    usr_cnt = uC3Std.mpl_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_MPL_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Variable-Sized Memory Pool ID's */\n")
        for i = 0, all_cnt-1 do
            mpl = MCFGGetKernelStdVariableMemPool(i)
            if mpl:externaluse() == false then
                fprintf(fout, "ID %s;\n", mpl:mplid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Cyclic Handlers
    usr_cnt = uC3Std.cyc_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_CYC_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Cyclic Handler ID's */\n")
        for i = 0, all_cnt-1 do
            cyc = MCFGGetKernelStdCyclicHandler(i)
            if cyc:externaluse() == false then
                fprintf(fout, "ID %s;\n", cyc:cycid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Alarm Handlers
    usr_cnt = uC3Std.alm_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_ALM_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Alarm Handler ID's */\n")
        for i = 0, all_cnt-1 do
            alm = MCFGGetKernelStdAlarmHandler(i)
            if alm:externaluse() == false then
                fprintf(fout, "ID %s;\n", alm:almid())
            end
        end
        fprintf(fout, "\n")
    end

    -- Interrupt Service Routine
    usr_cnt = uC3Std.isr_count_usr()
    all_cnt = MCFGGetParamInteger("CFG_ISR_COUNT", 0)
    if usr_cnt > 0 then
        fprintf(fout, "/* Interrupt Service Routine ID's */\n")
        for i = 0, all_cnt-1 do
            isr = MCFGGetKernelStdIsr(i)
            if isr:externaluse() == false then
                fprintf(fout, "ID %s;\n", isr:isrid())
            end
        end
        fprintf(fout, "\n")
    end

    fprintf(fout, "\n/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
