--[[
  @file     bootp_client_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/30    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    BOOTP Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __BOOTP_CLIENT_CFG_H__\n")
    fprintf(fout, "#define __BOOTP_CLIENT_CFG_H__\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* array size */\n")
    fprintf(fout, "#define BOOTPC_DNS_NUM      %d\n", MCFGGetParamInteger("CFG_UNET3_BOOTPC_DNS_NUM", 0))
    fprintf(fout, "#define BOOTPC_GW_NUM       %d\n", MCFGGetParamInteger("CFG_UNET3_BOOTPC_GW_NUM", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __BOOTP_CLIENT_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



