--[[
  @file     dhcp_server_cfg.h.lua
  @brief    
  
  @author   t-nakamura
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/10/30    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")

    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    DHCP Server Configuration\n")
    fprintf(fout, "    Copyright (c) 2014, eForce Co., Ltd. All rights reserved.\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __DHCP_SERVER_CFG_H__\n")
    fprintf(fout, "#define __DHCP_SERVER_CFG_H__\n")

    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"dhcp_server.h\"\n")
    fprintf(fout, "\n")


    if MCFGGetParamInteger("CFG_UNET3_DHCPD_USE", 0) == 1 then
        fprintf(fout, "/* Configuration                                                             */\n")
        fprintf(fout, "#define DHCP_POOL_SIZE    %d            /* DHCP Address Pool Size            */\n",MCFGGetParamInteger("CFG_UNET3_DHCPD_LEASE_NUM", 0))
        fprintf(fout, "#define DHCP_LEASE_PERIOD %d         /* DHCP lease period(sec)            */\n",MCFGGetParamInteger("CFG_UNET3_DHCPD_LEASE_PERIOD", 0))
    end

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __DHCP_SERVER_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



