--[[
  @file     ffsys_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/05/29    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    Simple File System Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __FFSYS_CFG_H__\n")
    fprintf(fout, "#define __FFSYS_CFG_H__\n")
    
    fprintf(fout, "\n")
    fprintf(fout, "#define CFG_FFS_DRV_NAME     '%s'     /* Drive name */\n", MCFGGetParamString("CFG_UNET3_FFSYS_DRV", 0))
    fprintf(fout, "#define CFG_FFS_FILE_CNT     %d       /* Number of files */\n", MCFGGetParamInteger("CFG_UNET3_FFSYS_FILE_CNT", 0))
    fprintf(fout, "#define CFG_FFS_FILE_LEN     %d    /* Maximum file size */\n", MCFGGetParamInteger("CFG_UNET3_FFSYS_FILE_LEN", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __FFSYS_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
