--[[
  @file     ftp_server_cfg.c.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/05/29    1.00        
  2014/08/05    1.04        /**/RgɃZ~R(;)̂ō폜
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local user_count   = MCFGGetParamInteger("CFG_UNET3_FTPD_USER_COUNT", 0)
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    FTP Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"net_hdr.h\"\n")
    fprintf(fout, "#include \"ftp_server.h\"\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Login user table (Max. 256 users) (DEV_ANY: All device is allowed) */\n")
    fprintf(fout, "const T_FTP_USR_TBL ftp_usr_tbl[] = {\n")
    for i = 0, user_count-1 do
        fprintf(fout, "    {DEV_ANY, \"%s\", \"%s\"},\n", MCFGGetParamString("CFG_UNET3_FTPD_USER_NAME", i), MCFGGetParamString("CFG_UNET3_FTPD_USER_PASS", i))
    end
    fprintf(fout, "    {0x00, 0x00, 0x00}    /* Terminate mark (Do not change) */\n")
    fprintf(fout, "};\n")

    -- End
    fprintf(fout, "\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
