--[[
  @file     ftp_server_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/05/29    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    FTP Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __FTP_SERVER_CFG_H__\n")
    fprintf(fout, "#define __FTP_SERVER_CFG_H__\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_FFSYS_USE", 0) == 1 then
        fprintf(fout, "/* File system */\n")
        if MCFGGetParamInteger("CFG_UNET3_FFSYS_SEL", 0) == 0 then
            fprintf(fout, "#include \"%s\"\n",  MCFGGetParamString("CFG_UNET3_FFSYS_OTHER_INC", 0))
        else
            fprintf(fout, "#include \"ffsys.h\"\n")
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "#define CFG_FTPS_DRV_NAME        '%s'                 /* Drive name */\n", MCFGGetParamString("CFG_UNET3_FTPD_DRV", 0))
    fprintf(fout, "#define CFG_FTPS_PATH_MAX        PATH_MAX            /* Maximum length of file path */\n")
    fprintf(fout, "#define CFG_FTPS_CMD_TMO         %d\n", MCFGGetParamInteger("CFG_UNET3_FTPD_CMD_TMO", 0))
    fprintf(fout, "#define CFG_FTPS_DAT_TMO         %d\n", MCFGGetParamInteger("CFG_UNET3_FTPD_DAT_TMO", 0))
    fprintf(fout, "#define CFG_FTPS_IDLE_TMO        (%d*1000)\n", MCFGGetParamInteger("CFG_UNET3_FTPD_IDLE_TMO", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __FTP_SERVER_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



