--[[
  @file     pop3_client_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.01
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/10/21    1.00
  2015/08/07    1.01        Support the operation without file system. (POP3_FSYS_NONE)
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    POP3 Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __POP3_CLIENT_CFG_H__\n")
    fprintf(fout, "#define __POP3_CLIENT_CFG_H__\n")

    fprintf(fout, "\n")
    local inc_file = ""
    if MCFGGetParamInteger("CFG_UNET3_FFSYS_USE", 0) == 1 then
        if MCFGGetParamInteger("CFG_UNET3_FFSYS_SEL", 0) == 0 then
            inc_file = MCFGGetParamString("CFG_UNET3_FFSYS_OTHER_INC", 0)   -- CӃt@CVXegp
        else
            inc_file = "ffsys.h"                        -- ȈՃt@CVXegp
        end
    end
    fprintf(fout, "/* File system */\n")
    if inc_file ~= "" then
        fprintf(fout, "#include \"%s\"\n", inc_file)
    else
        fprintf(fout, "#define POP3_FSYS_NONE      /* not use filesystem */\n")
    end

    fprintf(fout, "\n")

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __POP3_CLIENT_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



