--[[
  @file     shell_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/24    1.00        
  2014/08/05    1.04        CFG_SH_USE_COM͏1ŏo͂
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    Simple shell for Telnet Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __SHELL_CFG_H__\n")
    fprintf(fout, "#define __SHELL_CFG_H__\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Configurations */\n")
    fprintf(fout, "#define CFG_SH_MAX_USR_LEN     %d          /* Maximum length of user name */\n", MCFGGetParamInteger("CFG_UNET3_SH_MAX_USR_LEN", 0))
    fprintf(fout, "#define CFG_SH_MAX_PWD_LEN     %d          /* Maximum length of password */\n", MCFGGetParamInteger("CFG_UNET3_SH_MAX_PWD_LEN", 0))
    fprintf(fout, "#define CFG_SH_LOGIN_RETRY     %d           /* Maximum retry number of login */\n", MCFGGetParamInteger("CFG_UNET3_SH_LOGIN_RETRY", 0))
    fprintf(fout, "#define CFG_SH_HISTORY_NUM     (1 << %d)    /* Number of history (Must power of 2) */\n", MCFGGetParamInteger("CFG_UNET3_SH_HISTORY_NUM", 0))
    fprintf(fout, "#define CFG_SH_CMD_BUF_LEN     128         /* Command buffer size */\n")     -- ŒlH
    fprintf(fout, "#define CFG_SH_TMP_BUF_LEN     128         /* Temporary buffer size */\n")   -- ŒlH
    lf_ptn = MCFGGetParamInteger("CFG_UNET3_SH_LF", 0)
    if lf_ptn == 0 then
        fprintf(fout, "#define CFG_SH_LF               \"\\r\"      /* Line feed string to be used in the shell */\n")
    elseif lf_ptn == 1 then
        fprintf(fout, "#define CFG_SH_LF               \"\\r\\n\"      /* Line feed string to be used in the shell */\n")
    else
        fprintf(fout, "#define CFG_SH_LF               \"\\n\"      /* Line feed string to be used in the shell */\n")
    end
    fprintf(fout, "#define CFG_SH_ENA_ERCD         %d          /* Display error code (0: No, other: Yes) */\n", MCFGGetParamInteger("CFG_UNET3_SH_ENA_ERCD", 0))
    fprintf(fout, "#define CFG_SH_ENA_WELLCOME     %d          /* Display Welcome message (0: No, other: Yes) */\n", MCFGGetParamInteger("CFG_UNET3_SH_ENA_WELCOME", 0))
    fprintf(fout, "#define CFG_SH_ENA_LOGIN        %d          /* Display Login prompt (0: No, other: Yes) */\n", MCFGGetParamInteger("CFG_UNET3_SH_ENA_LOGIN", 0))
    fprintf(fout, "#define CFG_SH_USE_TELNET       1          /* Use shell on telnet (0: No, other: Yes) */\n") -- ŒlH
    fprintf(fout, "#ifndef UNDEF_CFG_SH_USE_COM\n")
    fprintf(fout, "#define CFG_SH_USE_COM          1          /* Use shell on UART   (0: No, other: Yes) */\n") -- ŒlH
    fprintf(fout, "#endif\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Messages */\n")
    fprintf(fout, "#define CFG_SH_MSG_WELCOME     \"%s\" CFG_SH_LF    /* Welcome message */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_WELCOME", 0))
    fprintf(fout, "#define CFG_SH_MSG_USR_PRMPT   CFG_SH_LF \"%s\"          /* Login prompt */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_USR_PRMPT", 0))
    fprintf(fout, "#define CFG_SH_MSG_PWD_PRMPT   CFG_SH_LF \"%s\"       /* Password prompt */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_PWD_PRMPT", 0))
    fprintf(fout, "#define CFG_SH_MSG_LOGIN_OK    CFG_SH_LF \"%s\"   /* Login correct */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_LOGIN_OK", 0))
    fprintf(fout, "#define CFG_SH_MSG_LOGIN_NG    CFG_SH_LF \"%s\" /* Login incorrect */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_LOGIN_NG", 0))
    fprintf(fout, "#define CFG_SH_MSG_CMD_PRMPT   CFG_SH_LF \"%s\"          /* Command prompt */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_CMD_PRMPT", 0))
    fprintf(fout, "#define CFG_SH_MSG_CMD_LONG    \"%s\"               /* Command is too long (COM) */\n", MCFGGetParamString("CFG_UNET3_SH_MSG_CMD_LONG", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __SHELL_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



