--[[
  @file     smtp_client_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.02
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/17    1.00        
  2014/10/21    1.01        Add symbol. (ENA_AUTH_PBS)
  2015/08/07    1.02        Support the operation without file system. (SMTP_FSYS_NONE)
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    SMTP Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __SMTP_CLIENT_CFG_H__\n")
    fprintf(fout, "#define __SMTP_CLIENT_CFG_H__\n")

    fprintf(fout, "\n")
    local inc_file = ""
    if MCFGGetParamInteger("CFG_UNET3_FFSYS_USE", 0) == 1 then
        if MCFGGetParamInteger("CFG_UNET3_FFSYS_SEL", 0) == 0 then
            inc_file = MCFGGetParamString("CFG_UNET3_FFSYS_OTHER_INC", 0)   -- CӃt@CVXegp
        else
            inc_file = "ffsys.h"                        -- ȈՃt@CVXegp
        end
    end
    fprintf(fout, "/* File system */\n")
    if inc_file ~= "" then
        fprintf(fout, "#include \"%s\"\n", inc_file)
    else
        fprintf(fout, "#define SMTP_FSYS_NONE      /* not use filesystem */\n")
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* SMTP Mail settings */\n")
    fprintf(fout, "#define SMTP_MIME_BND_HEAD  \"%s\"\n", MCFGGetParamString("CFG_UNET3_SMTPUA_MIME_BND_HEAD", 0))

    fprintf(fout, "\n")
    fprintf(fout, "/* SMTP Timeout settings */\n")
    fprintf(fout, "#define SMTP_TMO_CMD    %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_CMD", 0))
    fprintf(fout, "#define SMTP_TMO_INIT   %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_INIT", 0))
    fprintf(fout, "#define SMTP_TMO_MAIL   %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_MAIL", 0))
    fprintf(fout, "#define SMTP_TMO_RCPT   %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_RCPT", 0))
    fprintf(fout, "#define SMTP_TMO_DATA1  %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_DATA1", 0))
    fprintf(fout, "#define SMTP_TMO_DATA2  %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_DATA2", 0))
    fprintf(fout, "#define SMTP_TMO_DATA3  %d\n", MCFGGetParamInteger("CFG_UNET3_SMTPUA_TMO_DATA3", 0))
    
    if MCFGGetParamInteger("CFG_UNET3_POP3_AUTH_PBS", 0) == 1 then
        fprintf(fout, "\n")
        fprintf(fout, "#define ENA_AUTH_PBS     /* Enable POP before SMTP Authentication */\n")
    end
    
    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __SMTP_CLIENT_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



