--[[
  @file     sntp_server_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/18    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    SNTP Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __SNTP_SERVER_CFG_H__\n")
    fprintf(fout, "#define __SNTP_SERVER_CFG_H__\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_SNTPD_DATERANGE", 0) == 1 then
        fprintf(fout, "#define SNTP_DATERANGE_RFC2030  /* 1968/01/20 03:14:08 - 2104/02/26 09:42:23 */\n")
    end
    
    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0) == 1 then
        fprintf(fout, "#define SNTP_MULTICAST_VALID\n")
        if MCFGGetParamInteger("CFG_UNET3_SNTPD_MULTICAST_FUNC", 0) == 0 then
            fprintf(fout, "#define SNTP_BROCAST_SEND\n")
        end
    end
    
    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __SNTP_SERVER_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



