--[[
  @file     telnet_server_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/05/29    1.00        
  2014/08/05    1.04        ZbV`̒ǉ(TELNETD_SES_NUM)
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    Telnet Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __TELNET_SERVER_CFG_H__\n")
    fprintf(fout, "#define __TELNET_SERVER_CFG_H__\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Return string of AYT command reception */\n")
    fprintf(fout, "#define MSG_TC_AYT      \"\\r\\n%s\\r\\n\"\n", MCFGGetParamString("CFG_UNET3_TELNETD_MSG_TC_AYT", 0))
    fprintf(fout, "\n")
    fprintf(fout, "/* Specify sessions in Telnet server */\n")
    fprintf(fout, "#define TELNETD_SES_NUM     %d\n", MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0))

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __TELNET_SERVER_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



