require("uC3")

-- uC3 module alias
fprintf = uC3.fprintf

function main()
    -- Variables
    version     = MCFGGetParamInteger("CFG_UNET3_VERSION", 0)
    httpd_use   = MCFGGetParamInteger("CFG_UNET3_HTTPD_USE", 0)
    httpc_use   = MCFGGetParamInteger("CFG_UNET3_HTTPC_USE", 0)
    -- ver3ȍ~̕ϐ
    ftpd_use    = 0
    tftpd_use   = 0
    dhcpd_use   = 0
    sntpd_use   = 0
    telnetd_use = 0
    if version >= 300 then
        ftpd_use    = MCFGGetParamInteger("CFG_UNET3_FTPD_USE", 0)
        tftpd_use   = MCFGGetParamInteger("CFG_UNET3_TFTPD_USE", 0)
        dhcpd_use   = MCFGGetParamInteger("CFG_UNET3_DHCPD_USE", 0)
        sntpd_use   = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE", 0)
        telnetd_use = MCFGGetParamInteger("CFG_UNET3_TELNETD_USE", 0)
    end
    -- BSD variables
    bsd_tcps = 0
    bsd_udps = 0
    bsd_use     = MCFGGetParamInteger("CFG_UNET3_BSDWRP_USE", 0)
    if bsd_use == 1 then
        bsd_tcps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_TCPS_NUM", 0)
        bsd_udps    = MCFGGetParamInteger("CFG_UNET3_BSDWRP_UDPS_NUM", 0)
    end

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    TCP/IP Protocol Stack Object ID defnitions \n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _NET_ID_H_\n")
    fprintf(fout, "#define _NET_ID_H_\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"net_hdr.h\"\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Socket ID's */\n")
--    soc_id = 1 + bsd_tcps;			-- BSD\Pbg(TCP)ZiStandardcre_socID܂邽ߕsvj
    -- Socket
    -- TCPŏo͂
    cnt = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    for i = 0, cnt-1 do
        if MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i) == 6 then   -- TCP
            id = MCFGGetParamString("CFG_UNET3_SOCID", i)
            fprintf(fout, "extern SID %s;\n", id)
        end
    end
--    soc_id = soc_id + bsd_udps;		-- BSD\Pbg(UDP)ZiStandardcre_socID܂邽ߕsvj
    for i = 0, cnt-1 do
        if MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i) == 17 then  -- UDP
            id = MCFGGetParamString("CFG_UNET3_SOCID", i)
            fprintf(fout, "extern SID %s;\n", id)
        end
    end
    -- TCP,UDPȊO
    for i = 0, cnt-1 do
        if (MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i) ~= 6) and (MCFGGetParamInteger("CFG_UNET3_SOCPROTO", i) ~= 17) then
            id = MCFGGetParamString("CFG_UNET3_SOCID", i)
            fprintf(fout, "extern SID %s;\n", id)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Task ID's */\n")
    if httpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_HTTPD_TSKID", 0), i+1)
        end
    end
    if ftpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_FTPD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_FTPD_TSKID", 0), i+1)
        end
    end
    if tftpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TFTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TFTPD_TSKID", 0), i+1)
        end
    end
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_TSKID", 0), i+1)
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_RCV_TSKID", 0), i+1)
        end
    end
    if sntpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 0), i+1)
            local mc_use = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0)
            if mc_use == 1 then
                fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 1), i+1)
            end
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 0), i+1)
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 1), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Semaphore ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Event Flag ID's */\n")
    if sntpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_FLGID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_FLGID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* DataQueue ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Mailbox ID's */\n")
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MBXID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_MBXID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Mutex ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Message buffer ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Rendezvous ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Fixed-Sized Memory Pool ID's */\n")
    if httpc_use == 1 then
        fprintf(fout, "extern ID %s;\n", MCFGGetParamString("CFG_UNET3_HTTPC_MPFID", 0))
    end
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MPFID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "extern ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_MPFID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Variable-Sized Memory Pool ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Cyclic Handler ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Alarm Handler ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Interrupt Service Routine ID's */\n")
    if sntpd_use == 1 then
        fprintf(fout, "extern ID %s;\n", MCFGGetParamString("CFG_UNET3_SNTPD_ISRID", 0))
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Network interface ID's */\n")
    netif_id = 1;
    -- Network interface
    cnt = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)
    for i = 0, cnt-1 do
        id = MCFGGetParamString("CFG_UNET3_IFID", i)
        fprintf(fout, "#define %s\t %d\n", id, netif_id)
        netif_id = netif_id + 1
    end

    fprintf(fout, "\n")
    fprintf(fout, "#endif   /* _NET_ID_H_ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
