/**
 * @file    RZT1_UC3.h
 * @brief   Renesas RZ/T1 (ARM Cortex-R4) processor register definitions
 * @date    2014.10.03
 * @author  Copyright (c) 2014, eForce Co.,Ltd.  All rights reserved.
 *
 * @par     History
 *          - rev 1.0 (2014.10.03) i-cho
 *            Referenced Datasheet, Rev.0.50, 2014/8
 *            Initial version. 
 */
#ifndef _RZT1_UC3_H_
#define _RZT1_UC3_H_

#ifdef __cplusplus
extern "C"
{
#endif
     
#include "itron.h"

/**
 * Peripheral IO definitions (RZ/T1)
 */

#ifndef uint32_t
#define uint32_t    UW
#endif
#ifndef uint16_t
#define uint16_t    UH
#endif
#ifndef uint8_t
#define uint8_t     UB
#endif
#ifndef int32_t
#define int32_t     W
#endif
#ifndef int16_t
#define int16_t     H
#endif
#ifndef int8_t
#define int8_t      B
#endif

union iodefine_reg32_t
{
    uint32_t  UINT32;                                  /*  32-bit Access   */
    uint16_t  UINT16[2];                               /*  16-bit Access   */
    uint8_t   UINT8[4];                                /*  8-bit Access    */
};

union iodefine_reg32_16_t
{
    uint32_t  UINT32;                                  /*  32-bit Access   */
    uint16_t  UINT16[2];                               /*  16-bit Access   */
};

/* This is provided from Renesas */
#include "rz_t1/iodefine.h"

#define IRQ_TYPE_LEVEL  0
#define IRQ_TYPE_EDGE   1

#define IRQ_DETECT_LOW          (0x00)
#define IRQ_DETECT_FALL         (0x04)
#define IRQ_DETECT_RISE         (0x08)
#define IRQ_DETECT_RISE_FALL    (0x0C)

#define IRQ_FLTC_CLK_1          (0)  /* PCLKB       */
#define IRQ_FLTC_CLK_8          (1)  /* PCLKB/8     */
#define IRQ_FLTC_CLK_32         (2)  /* PCLKB/32    */
#define IRQ_FLTC_CLK_64         (3)  /* PCLKB/64    */
#define IRQ_FLTC_CLK_NONE       (4)  /* Disable noise fileter   */


/**
 * Interrupt vector
 */
#define INT_CPUINT              1   /* System CPUINT                    */
#define INT_CTI                 2   /*        CTI                       */
#define INT_FPUEXC              3   /*        FPU Exception             */
#define INT_IRQ0                4   /* IRQ 0                            */
#define INT_IRQ1                5   /* IRQ 1                            */
#define INT_IRQ2                6   /* IRQ 2                            */
#define INT_IRQ3                7   /* IRQ 3                            */
#define INT_IRQ4                8   /* IRQ 4                            */
#define INT_IRQ5                9   /* IRQ 5                            */
#define INT_IRQ6                10  /* IRQ 6                            */
#define INT_IRQ7                11  /* IRQ 7                            */
#define INT_IRQ8                12  /* IRQ 8                            */
#define INT_IRQ9                13  /* IRQ 9                            */
#define INT_IRQ10               14  /* IRQ 10                           */
#define INT_IRQ11               15  /* IRQ 11                           */
#define INT_IRQ12               16  /* IRQ 12                           */
#define INT_IRQ13               17  /* IRQ 13                           */
#define INT_IRQ14               18  /* IRQ 14                           */
#define INT_IRQ15               19  /* IRQ 15                           */
#define INT_ECM                 20  /* ECM error                        */
#define INT_CMT_CMI0            21  /* CMT Uint0 ch0                    */
#define INT_CMT_CMI1            22  /*           ch1                    */
#define INT_CMT_CMI2            23  /* CMT Uint1 ch0                    */
#define INT_CMT_CMI3            24  /*           ch1                    */
#define INT_CMTW0_CMWI          25  /* CMTW Uint0 CMWI                  */
#define INT_CMTW0_IC01          26  /*            IC0I                  */
#define INT_CMTW0_IC11          27  /*            IC1I                  */
#define INT_CMTW0_OC0I          28  /*            OC0I                  */
#define INT_CMTW0_OC1I          29  /*            OC1I                  */
#define INT_CMTW1_CMWI          30  /* CMTW Uint1 CMWI                  */
#define INT_CMTW1_IC01          31  /*            IC0I                  */
#define INT_CMTW1_IC11          32  /*            IC1I                  */
#define INT_CMTW1_OC0I          33  /*            OC0I                  */
#define INT_CMTW1_OC1I          34  /*            OC1I                  */
#define INT_ADC0_S12ADI         35  /* ADC Uint0 S12ADI                 */
#define INT_ADC0_S12GBADI       36  /*           S12GBADI               */
#define INT_ADC0_S12CMPI        37  /*           S12CMPI                */
#define INT_ADC1_S12ADI         38  /* ADC Uint1 S12ADI                 */
#define INT_ADC1_S12GBADI       39  /*           S12GBADI               */
#define INT_ADC1_S12CMPI        40  /*           S12CMPI                */
#define INT_USBH                41  /* USB Host                         */
#define INT_USBF                42  /*     Function                     */
#define INT_USBF_DREQ0          43  /*     Function DREQ0               */
#define INT_USBF_DREQ1          44  /*     Function DREQ1               */
#define INT_ETHSW               45  /* Switch with IEEE1588 SWITCH      */
#define INT_ETHSW_DLR           46  /*                      DLR         */
#define INT_ETHSW_SYNCOUT       47  /*                      SYNCOUT     */
#define INT_ETHPHY0             48  /*  Ether PHY0                      */
#define INT_ETHPHY1             49  /*  Ether PHY1                      */
#define INT_ETHPHY2             50  /*  Ether PHY2                      */
#define INT_ETHERC_DMAR         51  /*  Ether MAC DMA recevie           */
#define INT_ETHERC_DMAT         52  /*            DMA trans             */
#define INT_ETHERC_RXI          53  /*            Receive normal interrupt  */
#define INT_MTU_TGIA6           54  /*  MTU6 TGIA6                      */
#define INT_MTU_TGIB6           55  /*       TGIB6                      */
#define INT_MTU_TGIC6           56  /*       TGIC6                      */
#define INT_MTU_TGID6           57  /*       TGID6                      */
#define INT_MTU_TCIV6           58  /*       TCIV6                      */
#define INT_MTU_TGIA7           59  /*  MTU7 TGIA7                      */
#define INT_MTU_TGIB7           60  /*       TGIB7                      */
#define INT_MTU_TGIC7           61  /*       TGIC7                      */
#define INT_MTU_TGID7           62  /*       TGID7                      */
#define INT_MTU_TCIV7           63  /*       TCIV7                      */
#define INT_ETHERC_MII          64  /*  Ether MAC MII                   */
#define INT_ETHERC_PAUSPKT      65  /*            Pause packet          */
#define INT_ETHERC_TXI          66  /*            TX                    */
#define INT_ETHERC_RXFIFO_OF    67  /*            RX FIFO Overflow      */
#define INT_ETHERC_TXFIFO_UF    68  /*            TX FIFO Underflow     */
#define INT_ETHERC_TXFIFO_ER    69  /*            TX FIFO Error         */
#define INT_ETHERC_REI          70  /*            Receive Error         */
#define INT_RESERVED_71         71  /* Reserved                         */
#define INT_RESERVED_72         72  /* Reserved                         */
#define INT_ECAT_SYNC0          73  /* EtherCAT Sync0                   */
#define INT_ECAT_SYNC1          74  /*          Sync1                   */
#define INT_ECAT                75  /*                                  */
#define INT_ECAT_SOF            76  /* EtherCAT SOF                     */
#define INT_ECAT_EOF            77  /*          EOF                     */
#define INT_ECAT_WDT            78  /*          WDT                     */
#define INT_ECAT_RESET          79  /*          RESET                   */
#define INT_SPRI0               80  /* RSPI Unit0 SPRI0                 */
#define INT_SPTI0               81  /*            SPTI0                 */
#define INT_SPEI0               82  /*            SPEI0                 */
#define INT_SPII0               83  /*            SPII0                 */
#define INT_SPRI1               84  /* RSPI Unit1 SPRI1                 */
#define INT_SPTI1               85  /*            SPTI1                 */
#define INT_SPEI1               86  /*            SPEI1                 */
#define INT_SPII1               87  /*            SPII1                 */
#define INT_SPRI2               88  /* RSPI Unit2 SPRI2                 */
#define INT_SPTI2               89  /*            SPTI2                 */
#define INT_SPEI2               90  /*            SPEI2                 */
#define INT_SPII2               91  /*            SPII2                 */
#define INT_SPRI3               92  /* RSPI Unit3 SPRI3                 */
#define INT_SPTI3               93  /*            SPTI3                 */
#define INT_SPEI3               94  /*            SPEI3                 */
#define INT_SPII3               95  /*            SPII3                 */
#define INT_SCIFA_BRI_ERI0      96  /* SCIFA0 BRI0/ERI0                 */
#define INT_SCIFA_RXI0          97  /*       RXI0                       */
#define INT_SCIFA_TXI0          98  /*       TXI0                       */
#define INT_SCIFA_TEI_DRI0      99  /*       TEI0/DRI0                  */
#define INT_SCIFA_BRI_ERI1      100 /* SCIFA1 BRI1/ERI1                 */
#define INT_SCIFA_RXI1          101 /*       RXI1                       */
#define INT_SCIFA_TXI1          102 /*       TXI1                       */
#define INT_SCIFA_TEI_DRI1      103 /*       TEI1/DRI1                  */
#define INT_RSCANG_RFIF         104 /* RSCAN RFIF                       */
#define INT_RSCAN0_CFRXIF       105 /*       CAN0 CFRXIF                */
#define INT_RSCAN0_TX           106 /*       CAN0 TX                    */
#define INT_RSCAN1_CFRXIF       107 /*       CAN1 CFRXIF                */
#define INT_RSCAN1_TX           108 /*       CAN1 TX                    */
#define INT_SCIFA_BRI_ERI2      109 /* SCIFA2 BRI2/ERI2                 */
#define INT_SCIFA_RXI2          110 /*       RXI2                       */
#define INT_SCIFA_TXI2          111 /*       TXI2                       */
#define INT_SCIFA_TEI_DRI2      112 /*       TEI2/DRI2                  */
#define INT_SCIFA_BRI_ERI3      113 /* SCIFA3 BRI3/ERI3                 */
#define INT_SCIFA_RXI3          114 /*       RXI3                       */
#define INT_SCIFA_TXI3          115 /*       TXI3                       */
#define INT_SCIFA_TEI_DRI3      116 /*       TEI3/DRI3                  */
#define INT_SCIFA_BRI_ERI4      117 /* SCIFA4 BRI4/ERI4                 */
#define INT_SCIFA_RXI4          118 /*       RXI4                       */
#define INT_SCIFA_TXI4          119 /*       TXI4                       */
#define INT_SCIFA_TEI_DRI4      120 /*       TEI4/DRI4                  */
#define INT_RIIC_TEI0           121 /* RIIC0 TEI0                       */
#define INT_RIIC_RXI0           122 /*       RXI0                       */
#define INT_RIIC_TXI0           123 /*       TXI0                       */
#define INT_RIIC_TEI1           124 /* RIIC1 TEI1                       */
#define INT_RIIC_RXI1           125 /*       RXI                        */
#define INT_RIIC_TXI1           126 /*       TXI1                       */
#define INT_SSIRXI              127 /* SSI SSIRXI                       */
#define INT_SSITXI              128 /*     SSITXI                       */
#define INT_RESERVED_129        129 /* Reserved                         */
#define INT_RESERVED_130        130 /* Reserved                         */
#define INT_RESERVED_131        131 /* Reserved                         */
#define INT_RESERVED_132        132 /* Reserved                         */
#define INT_RESERVED_133        133 /* Reserved                         */
#define INT_RESERVED_134        134 /* Reserved                         */
#define INT_RESERVED_135        135 /* Reserved                         */
#define INT_RESERVED_136        136 /* Reserved                         */
#define INT_RESERVED_137        137 /* Reserved                         */
#define INT_RESERVED_138        138 /* Reserved                         */
#define INT_RESERVED_139        139 /* Reserved                         */
#define INT_RESERVED_140        140 /* Reserved                         */
#define INT_RESERVED_141        141 /* Reserved                         */
#define INT_RESERVED_142        142 /* Reserved                         */
#define INT_RESERVED_143        143 /* Reserved                         */
#define INT_RESERVED_144        144 /* Reserved                         */
#define INT_MTU_TGIA0           145 /*  MTU0 TGIA0                      */
#define INT_MTU_TGIB0           146 /*       TGIB0                      */
#define INT_MTU_TGIC0           147 /*       TGIC0                      */
#define INT_MTU_TGID0           148 /*       TGID0                      */
#define INT_MTU_TGIE0           149 /*       TGIE0                      */
#define INT_MTU_TGIF0           150 /*       TGIF0                      */
#define INT_MTU_TCIV0           151 /*       TCIV0                      */
#define INT_MTU_TGIA1           152 /*  MTU1 TGIA1                      */
#define INT_MTU_TGIB1           153 /*       TGIB1                      */
#define INT_MTU_TCIV1           154 /*       TCIV1                      */
#define INT_MTU_TCIU1           155 /*       TCIU1                      */
#define INT_MTU_TGIA2           156 /*  MTU2 TGIA2                      */
#define INT_MTU_TGIB2           157 /*       TGIB2                      */
#define INT_MTU_TCIV2           158 /*       TCIV2                      */
#define INT_MTU_TCIU2           159 /*       TCIU2                      */
#define INT_MTU_TGIA3           160 /*  MTU3 TGIA3                      */
#define INT_MTU_TGIB3           161 /*       TGIB3                      */
#define INT_MTU_TGIC3           162 /*       TGIC3                      */
#define INT_MTU_TGID3           163 /*       TGID3                      */
#define INT_MTU_TCIV3           164 /*       TCIV3                      */
#define INT_MTU_TGIA4           165 /*  MTU3 TGIA4                      */
#define INT_MTU_TGIB4           166 /*       TGIB4                      */
#define INT_MTU_TGIC4           167 /*       TGIC4                      */
#define INT_MTU_TGID4           168 /*       TGID4                      */
#define INT_MTU_TCIV4           169 /*       TCIV4                      */
#define INT_MTU_TGIU5           170 /*  MTU3 TGIU5                      */
#define INT_MTU_TGIV5           171 /*       TGIV5                      */
#define INT_MTU_TGIW5           172 /*       TGIW5                      */
#define INT_MTU_TGIA8           173 /*  MTU3 TGIA8                      */
#define INT_MTU_TGIB8           174 /*       TGIB8                      */
#define INT_MTU_TGIC8           175 /*       TGIC8                      */
#define INT_MTU_TGID8           176 /*       TGID8                      */
#define INT_MTU_TCIV8           177 /*       TCIV8                      */
#define INT_GTCIA0              178 /* GPTA GTCIA0                      */
#define INT_GTCIB0              179 /*      GTCIB0                      */
#define INT_GTCIC0              180 /*      GTCIC0                      */
#define INT_GTCID0              181 /*      GTCID0                      */
#define INT_GTCIE0              182 /*      GTCIE0                      */
#define INT_GTCIF0              183 /*      GTCIF0                      */
#define INT_GDTE0               184 /*      GDTE0                       */
#define INT_GTCIV0              185 /*      GTCIV0                      */
#define INT_GTCIU0              186 /*      GTCIU0                      */
#define INT_GTCIA1              187 /* GPTA GTCIA1                      */
#define INT_GTCIB1              188 /*      GTCIB1                      */
#define INT_GTCIC1              189 /*      GTCIC1                      */
#define INT_GTCID1              190 /*      GTCID1                      */
#define INT_GTCIE1              191 /*      GTCIE1                      */
#define INT_GTCIF1              192 /*      GTCIF1                      */
#define INT_GDTE1               193 /*      GDTE1                       */
#define INT_GTCIV1              194 /*      GTCIV1                      */
#define INT_GTCIU1              195 /*      GTCIU1                      */
#define INT_GTCIA2              196 /* GPTA GTCIA2                      */
#define INT_GTCIB2              197 /*      GTCIB2                      */
#define INT_GTCIC2              198 /*      GTCIC2                      */
#define INT_GTCID2              199 /*      GTCID2                      */
#define INT_GTCIE2              200 /*      GTCIE2                      */
#define INT_GTCIF2              201 /*      GTCIF2                      */
#define INT_GDTE2               202 /*      GDTE2                       */
#define INT_GTCIV2              203 /*      GTCIV2                      */
#define INT_GTCIU2              204 /*      GTCIU2                      */
#define INT_GTCIA3              205 /* GPTA GTCIA3                      */
#define INT_GTCIB3              206 /*      GTCIB3                      */
#define INT_GTCIC3              207 /*      GTCIC3                      */
#define INT_GTCID3              208 /*      GTCID3                      */
#define INT_GTCIE3              209 /*      GTCIE3                      */
#define INT_GTCIF3              210 /*      GTCIF3                      */
#define INT_GDTE3               211 /*      GDTE3                       */
#define INT_GTCIV3              212 /*      GTCIV3                      */
#define INT_GTCIU3              213 /*      GTCIU3                      */
#define INT_ETGIP               214 /* GPTA ETGIP                       */
#define INT_ETGIN               215 /*      ETGIN                       */
#define INT_TPU_TGI0A           216 /* TPU0 TGI0A                       */
#define INT_TPU_TGI0B           217 /*      TGI0B                       */
#define INT_TPU_TGI0C           218 /*      TGI0C                       */
#define INT_TPU_TGI0D           219 /*      TGI0D                       */
#define INT_TPU_TCI0V           220 /*      TCI0V                       */
#define INT_TPU_TGI1A           221 /* TPU1 TGI1A                       */
#define INT_TPU_TGI1B           222 /*      TGI1B                       */
#define INT_TPU_TCI1V           223 /*      TCI1V                       */
#define INT_TPU_TCI1U           224 /*      TCI1U                       */
#define INT_TPU_TGI2A           225 /* TPU2 TGI2A                       */
#define INT_TPU_TGI2B           226 /*      TGI2B                       */
#define INT_TPU_TCI2V           227 /*      TCI2V                       */
#define INT_TPU_TCI2U           228 /*      TCI2U                       */
#define INT_TPU_TGI3A           229 /* TPU3 TGI3A                       */
#define INT_TPU_TGI3B           230 /*      TGI3B                       */
#define INT_TPU_TGI3C           231 /*      TGI3C                       */
#define INT_TPU_TGI3D           232 /*      TGI3D                       */
#define INT_TPU_TCI3V           233 /*      TCI3V                       */
#define INT_TPU_TGI4A           234 /* TPU4 TGI4A                       */
#define INT_TPU_TGI4B           235 /*      TGI4B                       */
#define INT_TPU_TCI4V           236 /*      TCI4V                       */
#define INT_TPU_TCI4U           237 /*      TCI4U                       */
#define INT_TPU_TGI5A           238 /* TPU5 TGI5A                       */
#define INT_TPU_TGI5B           239 /*      TGI5B                       */
#define INT_TPU_TCI5V           240 /*      TCI5V                       */
#define INT_TPU_TCI5U           241 /*      TCI5U                       */
#define INT_ECL_REQ1            242 /* ELC REQ1                         */
#define INT_ECL_REQ2            243 /*     REQ2                         */
#define INT_RESERVED_244        244 /* Reserved                         */
#define INT_RESERVED_245        245 /* Reserved                         */
#define INT_ETHERC_MACDMARE     246 /*  Ether MAC MACDMARE              */
#define INT_ETHERC_MACDMATE     247 /*            MACDMATE              */
#define INT_DMAINT0             248 /* DMA INT0                         */
#define INT_DMAINT1             249 /*     INT1                         */
#define INT_DMAINT2             250 /*     INT2                         */
#define INT_DMASW0              251 /*     SW0                          */
#define INT_DMASW1              252 /*     SW1                          */
#define INT_RESERVED_253        253 /* Reserved                         */
#define INT_CM3_RESET           254 /* CM3 Reset                        */
#define INT_RESERVED_255        255 /* Reserved                         */
#define INT_OEI1                256 /* POE3 POE0#Hi-Z                   */
#define INT_OEI2                257 /*      POE4#Hi-Z                   */
#define INT_OEI3                258 /*      POE8#Hi-Z                   */
#define INT_OEI4                259 /*      POE10 or POE11#Hi-Z         */
#define INT_RIIC_EEI0           260 /* RIIC0 EEI0                       */
#define INT_RIIC_EEI1           261 /* RIIC1 EEI1                       */
#define INT_RSCANG_ERR          262 /* RSCANG ERR                       */
#define INT_RSCAN0_ERR          263 /* RSCAN0 ERR                       */
#define INT_RSCAN1_ERR          264 /* RSCAN1 ERR                       */
#define INT_BSC_CMI             265 /* BSC CMI                          */
#define INT_SSIF                266 /* SSI SSIF                         */
#define INT_TPU_TGI6A           267 /* TPU6 TGI6A                       */
#define INT_TPU_TGI6B           268 /*      TGI6B                       */
#define INT_TPU_TGI6C           269 /*      TGI6C                       */
#define INT_TPU_TGI6D           270 /*      TGI6D                       */
#define INT_TPU_TCI6V           271 /*      TCI6V                       */
#define INT_TPU_TGI7A           272 /* TPU7 TGI7A                       */
#define INT_TPU_TGI7B           273 /*      TGI7B                       */
#define INT_TPU_TCI7V           274 /*      TCI7V                       */
#define INT_TPU_TCI7U           275 /*      TCI7U                       */
#define INT_TPU_TGI8A           276 /* TPU8 TGI8A                       */
#define INT_TPU_TGI8B           277 /*      TGI8B                       */
#define INT_TPU_TCI8V           278 /*      TCI8V                       */
#define INT_TPU_TCI8U           279 /*      TCI8U                       */
#define INT_TPU_TGI9A           280 /* TPU9 TGI6A                       */
#define INT_TPU_TGI9B           281 /*      TGI9B                       */
#define INT_TPU_TGI9C           282 /*      TGI9C                       */
#define INT_TPU_TGI9D           283 /*      TGI9D                       */
#define INT_TPU_TCI9V           284 /*      TCI9V                       */
#define INT_TPU_TGI10A          285 /* TPU10 TGI10A                     */
#define INT_TPU_TGI10B          286 /*       TGI10B                     */
#define INT_TPU_TCI10V          287 /*       TCI10V                     */
#define INT_TPU_TCI10U          288 /*       TCI10U                     */
#define INT_TPU_TGI11A          289 /* TPU11 TGI11A                     */
#define INT_TPU_TGI11B          290 /*       TGI11B                     */
#define INT_TPU_TCI11V          291 /*       TCI11V                     */
#define INT_TPU_TCI11U          292 /*       TCI11U                     */
#define INT_DMAERR0             293 /* DMA ERR0                         */
#define INT_DMAERR1             294 /*     ERR1                         */
#define INT_RESERVED_295        295 /* Reserved                         */
#define INT_RESERVED_296        296 /* Reserved                         */
#define INT_RESERVED_297        297 /* Reserved                         */
#define INT_RESERVED_298        298 /* Reserved                         */
#define INT_CMT_CMI4            299 /* CMT Uint2 ch0                    */
#define INT_CMT_CMI5            300 /*           ch1                    */

#ifdef __cplusplus
}
#endif

#endif  /* _RZT1_UC3_H_ */

