/***************************************************************************
    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application
    HTTP Server header file
    Copyright (c)  2009-2014, eForce Co., Ltd. All rights reserved.

    Version Information
      2009.01.09: Created
      2010.03.08: Support for query in URI
      2012.08.09: Add HttpSendFile(), HttpSendErrorResponse().
      2012.08.14: Expanded TX/RX buffer length 16 -> 32bit
      2013.02.13: Changed variable type to pointer path, ctype
      2014.11.05: Add an API of http_server_stop
      2015.02.25: Supported to HTTP Keep-Alive feature.
      2015.03.26: Delete HttpSendImage, Add HttpSendResponse, Modify HttpSendText
      2015.06.05: Published the following function as API.
        HttpSetContent, HttpSetContentLen, HttpSetContentKpa HttpSendBuffer
      2015.06.22: Supported to Cookie Header Received.
      2015.12.14: The socket ID replaced SID types
                  Add Safety version of the function CgiGetParam.
      2016.02.10: Add include files for warning avoidance
      2016.02.17: Corrected to not disable HttpSetContentKpa().
      2016.03.30: Support receive multipart data.
 ***************************************************************************/

#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H
#ifdef __cplusplus
extern "C" {
#endif

#include "kernel.h"
#include "net_hdr.h"

#define HTTP_PORT           80
#define HTTP_BUF_SIZ        1500
#define HTTP_SERVER_RETRY_WAIT  100     /* wait retrying(ms)                 */
#define HTTP_SERVER_BOOT        1       /* http server boot flag             */
#define HTTP_SERVER_STOP        0       /* http server stop flag             */

#include "http_server_cfg.h"

typedef struct t_http_header {
    char *method;   /* GET or HEAD or POST  */
    char *url;      /* URL / File Name      */
    char *url_q;    /* URL query            */
    char *ver;      /* 1.0 or 1.1           */
    char *host;     /* Client Host          */
    char *ctype;    /* Content-Type         */
    char *Content;  /* Content              */
    int  ContentLen;/* Content length       */
    char kpa;
#ifdef ENA_USER_EXT
    char *auth;     /* Authorization        */
    char *cookie;   /* Cookie */
#endif
}T_HTTP_HEADER;

typedef struct t_http_server {
    UW sbufsz;
    UW rbufsz;
    UW txlen;
    UW rxlen;
    UW rdlen;
    UW len;     /* temp */
    UB *rbuf;
    UB *sbuf;
    UB *req;
    UH Port;
    SID SocketID;
    T_HTTP_HEADER hdr;
    UB NetChannel;
    UB ver;     /* Added for IPV6 support */
    UB server_tsk_stat; /* http server status flag                           */
    ID server_tsk_id;   /* http server task id                               */
    struct t_http_server *next;
#ifdef ENA_KEEP_ALIVE
    UH kpa_max;
#endif
}T_HTTP_SERVER;

#define HTTPD_EXT_AUTH          0x01
#define HTTPD_EXT_UHDR          0x02

#define HTTPD_EXT_SMCGI         0x40    /* Streaming CGI */
#define HTTPD_EXT_MPCGI         0x80    /* Multipart CGI */

typedef struct t_http_file {
    const char *path;
    const char *ctype;
    const char *file;
    int   len;
    void (*cbk)(T_HTTP_SERVER *http);
#ifdef ENA_USER_EXT
    UB ext;
#endif
}T_HTTP_FILE;

/* API CGI */
/* CgiGetParam is not api recommended */
void CgiGetParam(char *msg, int clen, char *cgi_var[], char *cgi_val[], int *cgi_cnt);
void CgiGetParamN(char *msg, int clen, char *cgi_var[], char *cgi_val[], int *cgi_cnt);

/* API HTTP */
ER http_server(T_HTTP_SERVER *http);
ER http_server_stop( UW retry );

/* API for callback function */
ER HttpSendText(T_HTTP_SERVER *http, char *str, int len);
ER HttpSendResponse(T_HTTP_SERVER *http, char *str, int len, char *type);
ER HttpSendFile(T_HTTP_SERVER *http, char *str, int len, char *name, char *type);
ER HttpSendErrorResponse(T_HTTP_SERVER *http, char *str);

ER HttpSetContent(T_HTTP_SERVER *http, char *str);
ER HttpSetContentLen(T_HTTP_SERVER *http, char *str, int len);
ER HttpSetContentKpa(T_HTTP_SERVER *http);
ER HttpSendBuffer(T_HTTP_SERVER *http, char *str, int len);

extern T_HTTP_FILE  *gHTTP_FILE;
#ifdef ENA_USER_EXT
extern ER (*gHTTP_EXT_CBK)(T_HTTP_SERVER *http, const T_HTTP_FILE *fp, UB evt);
ER HttpSetContentCookie(T_HTTP_SERVER *http, char *name, char *val, char *opt);
UB CookieGetItem(char **cookie, char **name, char **value);
#endif


#ifdef ENA_DIVRECV_CGI
#include "httpd_mp_cgi.h"
#endif
 

#ifdef __cplusplus
}
#endif
#endif /* HTTP_SERVER_H */
