/****************************************************************************/
/*                                                                          */
/*      AP-RZA1H-0A �T���v���v���O����                                      */
/*          SDRAM������                                                     */
/*                                                                          */
/*          Copyright   :: ���A���t�@�v���W�F�N�g                           */
/*          File Name   :: sdram.c                                          */
/*                                                                          */
/****************************************************************************/

/* Include */
#include "common.h"
#include "iodefine.h"
#include "r_typedefs.h"
#include "sdram.h"

/****************************************************************************/
/*     SDRAM������                                                          */
/****************************************************************************/
void sdram_init(void)
{
    volatile unsigned long ulDummy;

    /* PORT Setting */

    MPC.PWPR.BYTE = 0x00;
    MPC.PWPR.BYTE = 0x40;
    
    MPC.P00PFS.BYTE = 0x22;     /* P00 D0 */
    MPC.P01PFS.BYTE = 0x22;     /* P01 D1 */
    MPC.P02PFS.BYTE = 0x22;     /* P02 D2 */
    MPC.P03PFS.BYTE = 0x22;     /* P03 D3 */
    MPC.P04PFS.BYTE = 0x22;     /* P04 D4 */
    MPC.P05PFS.BYTE = 0x22;     /* P05 D5 */
    MPC.P06PFS.BYTE = 0x22;     /* P06 D6 */
    MPC.P07PFS.BYTE = 0x22;     /* P07 D7 */
    
    MPC.P10PFS.BYTE = 0x22;     /* P10 CKIO */
    MPC.P15PFS.BYTE = 0x22;     /* P15 CS3# */

    MPC.P24PFS.BYTE = 0x22;     /* P24 RD/WR# */
    
    MPC.P36PFS.BYTE = 0x22;     /* P36 DQMLL */
    MPC.P37PFS.BYTE = 0x22;     /* P37 DQMLU */

    MPC.P46PFS.BYTE = 0x22;     /* P46 CKE */

    MPC.P90PFS.BYTE = 0x23;     /* P90 RAS# */
    
    MPC.PE0PFS.BYTE = 0x22;     /* PE0 D8 */
    MPC.PE1PFS.BYTE = 0x22;     /* PE1 D9 */
    MPC.PE2PFS.BYTE = 0x22;     /* PE2 D10 */
    MPC.PE3PFS.BYTE = 0x22;     /* PE3 D11 */
    MPC.PE4PFS.BYTE = 0x22;     /* PE4 D12 */
    MPC.PE5PFS.BYTE = 0x22;     /* PE5 D13 */
    MPC.PE6PFS.BYTE = 0x22;     /* PE6 D14 */
    MPC.PE7PFS.BYTE = 0x22;     /* PE7 D15 */

    MPC.PG0PFS.BYTE = 0x22;     /* PG0 A1 */
    MPC.PG1PFS.BYTE = 0x22;     /* PG1 A2 */
    MPC.PG2PFS.BYTE = 0x22;     /* PG2 A3 */
    MPC.PG3PFS.BYTE = 0x22;     /* PG3 A4 */
    MPC.PG4PFS.BYTE = 0x22;     /* PG4 A5 */
    MPC.PG5PFS.BYTE = 0x22;     /* PG5 A6 */
    MPC.PG6PFS.BYTE = 0x22;     /* PG6 A7 */
    MPC.PG7PFS.BYTE = 0x22;     /* PG7 A8 */
    
    MPC.PH0PFS.BYTE = 0x22;     /* PH0 A9 */
    MPC.PH1PFS.BYTE = 0x22;     /* PH1 A10 */
    MPC.PH2PFS.BYTE = 0x22;     /* PH2 A11 */
    MPC.PH3PFS.BYTE = 0x22;     /* PH3 A12 */
    MPC.PH4PFS.BYTE = 0x22;     /* PH4 A13 */
    MPC.PH5PFS.BYTE = 0x22;     /* PH5 A14 */
    MPC.PH6PFS.BYTE = 0x22;     /* PH6 A15 */
    MPC.PH7PFS.BYTE = 0x22;     /* PH7 A16 */
 
    MPC.PK0PFS.BYTE = 0x23;     /* PK0 CAS# */

    MPC.PWPR.BYTE = 0x80;

    PORT0.PMR.BYTE = 0xFF;
    PORT1.PMR.BYTE = 0x21;
    PORT2.PMR.BYTE = 0x10;
    PORT3.PMR.BYTE = 0xD8;
    PORT4.PMR.BYTE = 0x40;
    PORT9.PMR.BYTE = 0x01;
    PORTE.PMR.BYTE = 0xFF;
    PORTG.PMR.BYTE = 0xFF;
    PORTH.PMR.BYTE = 0xFF;
    PORTK.PMR.BYTE = 0x01;
    
    PORT1.DSCR.WORD = 0x0001;
    
    
    /* BSC Setting */
    SYSTEM.PRCR.LONG = 0x0000A502;
    ulDummy = SYSTEM.PRCR.LONG;
#ifdef RAM_DBG
    SYSTEM.MSTPCRC.LONG = 0x00007E7E;
#endif
#ifdef ROM_DBG
    SYSTEM.MSTPCRC.LONG = 0x00007C7E;
#endif
#ifdef WRITE_SFLASH
    SYSTEM.MSTPCRC.LONG = 0x00007E7E;
#endif
    ulDummy = SYSTEM.MSTPCRC.LONG;
    SYSTEM.PRCR.LONG = 0x0000A500;
    ulDummy = SYSTEM.PRCR.LONG;
    
    BSC.CS3BCR.LONG = 0x00004C00;
    BSC.CS3WCR.CS3WCR_1.LONG = 0x00004892;

    BSC.SDCR.LONG = 0x00000809;
    BSC.RTCSR.LONG = 0xA55A0010;                /* CKIO/16 = 75MHz/16 = 4.6875MHz */
    BSC.RTCNT = 0xA55A0000;
    BSC.RTCOR = 0xA55A0049;                     /* 4.6875MHz �� 213.33...ns */
                                                /* 64ms/4096 = 15.625us (cycle) */
                                                /* 15.625 / 0.21333 = 73.242... �� 73(0x49) */
    
    (*(volatile unsigned short *)0xA0004040) = 0x0000;	/* SDRAM Mode Register */ 
}

