/***********************************************************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
* other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
* applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
* EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
* SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS
* SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
* this software. By using this software, you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2014(2015) Renesas Electronics Corporation. All rights reserved.
***********************************************************************************************************************/
/***********************************************************************************************************************
* File Name    : r_usb_hmsc_if.h
* Description  : Interface file for USB HMSC API
***********************************************************************************************************************/
/**********************************************************************************************************************
* History : DD.MM.YYYY Version Description
*         : 31.08.2015 1.00    First Release
***********************************************************************************************************************/

#ifndef _USB_HMSC_IF_H
#define _USB_HMSC_IF_H

/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/
#include "r_usb_basic_if.h"
#include "r_usb_hmsc_config.h"

/*****************************************************************************
Enum definitions
******************************************************************************/
enum
{
    /*--- SFF-8070i command define ---*/
    USB_ATAPI_TEST_UNIT_READY       = 0x00u,
    USB_ATAPI_REQUEST_SENSE         = 0x03u,
    USB_ATAPI_FORMAT_UNIT           = 0x04u,
    USB_ATAPI_INQUIRY               = 0x12u,
    USB_ATAPI_MODE_SELECT6          = 0x15u,
    USB_ATAPI_MODE_SENSE6           = 0x1Au,
    USB_ATAPI_START_STOP_UNIT       = 0x1Bu,
    USB_ATAPI_PREVENT_ALLOW         = 0x1Eu,
    USB_ATAPI_READ_FORMAT_CAPACITY  = 0x23u,
    USB_ATAPI_READ_CAPACITY         = 0x25u,
    USB_ATAPI_READ10                = 0x28u,
    USB_ATAPI_WRITE10               = 0x2Au,
    USB_ATAPI_SEEK                  = 0x2Bu,
    USB_ATAPI_WRITE_AND_VERIFY      = 0x2Eu,
    USB_ATAPI_VERIFY10              = 0x2Fu,
    USB_ATAPI_MODE_SELECT10         = 0x55u,
    USB_ATAPI_MODE_SENSE10          = 0x5Au,
};

/******************************************************************************
Exported global functions (to be accessed by other files)
******************************************************************************/
void        R_usb_hmsc_task(void);
void        R_usb_hmsc_driver_start(void);
void        R_usb_hmsc_ClassCheck(uint16_t **table);
uint16_t    R_usb_hmsc_Read10(uint16_t side, uint8_t *buff, uint32_t secno, uint16_t seccnt, uint32_t trans_byte);
uint16_t    R_usb_hmsc_Write10(uint16_t side, const uint8_t *buff, uint32_t secno, uint16_t seccnt, uint32_t trans_byte);
uint16_t    R_usb_hmsc_TestUnit(uint16_t side);
uint16_t    R_usb_hmsc_RequestSense(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_Inquiry(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_ReadCapacity(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_ReadFormatCapacity(uint16_t side, uint8_t *buff);
USB_ER_t    R_usb_hmsc_GetMaxUnit(uint16_t addr, uint8_t *buff, USB_UTR_CB_t complete);
USB_ER_t    R_usb_hmsc_MassStorageReset(uint16_t addr, USB_UTR_CB_t complete);
uint16_t    R_usb_hmsc_PreventAllow(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_ModeSense10(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_ModeSelect6(uint16_t side, uint8_t *buff);
uint16_t    R_usb_hmsc_GetDevSts(uint16_t side);
uint16_t    R_usb_hmsc_alloc_drvno(uint16_t *side, uint16_t devadr);
uint16_t    R_usb_hmsc_free_drvno(uint16_t side);
uint16_t    R_usb_hmsc_ref_drvno(uint16_t *side, uint16_t devadr);

void        R_usb_hmsc_StrgDriveTask( void );
uint16_t    R_usb_hmsc_StrgDriveSearch(uint16_t addr, USB_UTR_CB_t complete);
uint16_t    R_usb_hmsc_StrgDriveOpen(uint16_t *side, uint16_t addr);
uint16_t    R_usb_hmsc_StrgDriveClose(uint16_t side);
uint16_t    R_usb_hmsc_StrgReadSector(uint16_t side, uint8_t *buff, uint32_t secno, uint16_t seccnt, uint32_t trans_byte);
uint16_t    R_usb_hmsc_StrgWriteSector(uint16_t side, const uint8_t *buff, uint32_t secno, uint16_t seccnt, uint32_t trans_byte);
uint16_t    R_usb_hmsc_StrgUserCommand(uint16_t side, uint16_t command, uint8_t *buff, USB_UTR_CB_t complete);
uint16_t    R_usb_hmsc_StrgCheckEnd(void);

#endif /* _USB_HMSC_IF_H */
