--[[
  @file     prst.s79.lua
  @brief    Zbgnh
  
  @author   i-cho
  @version  1.01
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2015/04/30    1.00        IOݒCōs
  2015/11/04    1.01        Disables MPU background region.
                            Remove unused region.
  2016/02/05    1.01        
  -------------------------------------------------------
--]]
require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

-- main
function main()
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, " * Reset handler\n")
    fprintf(fout, " *\n")
    fprintf(fout, " *  File name : prst.S\n")
    fprintf(fout, " *\n")
    fprintf(fout, " ****************************************************************************/\n")
    
    fprintf(fout, "\n")
    fprintf(fout, "/* Program Status Register */\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .EQU I_BIT,     0x80\n")
    fprintf(fout, "        .EQU F_BIT,     0x40\n")
    fprintf(fout, "        .EQU T_BIT,     0x20\n")
    fprintf(fout, "        .EQU USR_MOD,   0x10\n")
    fprintf(fout, "        .EQU FIQ_MOD,   0x11\n")
    fprintf(fout, "        .EQU IRQ_MOD,   0x12\n")
    fprintf(fout, "        .EQU SVC_MOD,   0x13\n")
    fprintf(fout, "        .EQU ABT_MOD,   0x17\n")
    fprintf(fout, "        .EQU UND_MOD,   0x1B\n")
    fprintf(fout, "        .EQU SYS_MOD,   0x1F\n")
    fprintf(fout, "        .EQU MON_MOD,   0x16\n")

    fprintf(fout, "\n")
    fprintf(fout, "@ Peripheral register offset\n")

    fprintf(fout, "\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .text\n")
    fprintf(fout, "        .code 32\n")

    fprintf(fout, "\n")
    fprintf(fout, "        .align 2\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .globl  Reset_Handler\n")
    fprintf(fout, "        .type   Reset_Handler, %%function\n")

    fprintf(fout, "\n")
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, "        Power On Reset Handler                                              *\n")
    fprintf(fout, "                                                                            *\n")
    fprintf(fout, " ***************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .extern main\n")
    fprintf(fout, "        .extern _ddr_cortexr_mpu_init\n")
    fprintf(fout, "        .extern _kernel_invalid_cache\n")

    fprintf(fout, "\n")
    fprintf(fout, "Reset_Handler:\n")
    fprintf(fout, "        cpsid   if,  #SYS_MOD\n")
    fprintf(fout, "        ldr     sp,  =_sys_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * Disable MPU anc caches\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        mrc     p15, 0,  r2,  c1,  c0,  0\n")
    fprintf(fout, "        bic     r2,  r2, #0x00000001        @ Clear MPU (M bit  0)\n")
    fprintf(fout, "        bic     r2,  r2, #0x00000004        @ Clear D-Cache Control (C bit  2)\n")
    fprintf(fout, "        orr     r2,  r2, #0x00000008        @ Branch prediction enable bit.\n")
    fprintf(fout, "        bic     r2,  r2, #0x00001000        @ Clear I-Cache Control (I bit 12)\n")
    fprintf(fout, "        mcr     p15, 0,  r2,  c1,  c0,   0\n")
    fprintf(fout, "        dsb\n")
    fprintf(fout, "        isb\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * cache initialization\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        bl      _kernel_invalid_cache\n")
    --fprintf(fout, "\n")
    --fprintf(fout, "        ;*------------------------------------------------------\n")
    --fprintf(fout, "        ; Adopt default memory map as background map.\n")
    --fprintf(fout, "        ;*------------------------------------------------------\n")
    --fprintf(fout, "        mrc     p15, 0, r2, c1, c0, 0\n")
    --fprintf(fout, "        orr     r2, r2, #0x00020000\n")
    --fprintf(fout, "        dsb\n")
    --fprintf(fout, "        mcr     p15, 0, r2, c1, c0, 0\n")
    --fprintf(fout, "        isb\n")

    -- fprintf(fout, "\n")
    -- fprintf(fout, "        ;*------------------------------------------------------\n")
    -- fprintf(fout, "        ;* hardware initialization\n")
    -- fprintf(fout, "        ;*------------------------------------------------------\n")
    -- fprintf(fout, "        bl      _io_init\n")
    -- fprintf(fout, "skip_init:\n")

    fprintf(fout, "\n")
    fprintf(fout, "#ifdef __VFP_FP__\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * setup privileged and user mode access to coprocessors\n")
    fprintf(fout, "         * 10 and 11, required to enable neon/vfp\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        mrc     p15, #0, r0, c1, c0, #2\n")
    fprintf(fout, "        mov     r3,  #0x00f00000\n")
    fprintf(fout, "        orr     r0,  r0, r3\n")
    fprintf(fout, "        mcr     p15, #0, r0, c1, c0, #2\n")
    fprintf(fout, "        mov     r0,  #0x40000000\n")
    fprintf(fout, "        fmxr    fpexc, r0\n")
    fprintf(fout, "#endif\n")
    
    fprintf(fout, "\n")
    fprintf(fout, "abs_addr:\n")
    fprintf(fout, "\n")
    fprintf(fout, "        @* Disable Branch prediction\n")
    fprintf(fout, "        mrc     p15, 0,  r2, c1, c0, 1\n")
    fprintf(fout, "        orr     r2,  r2, #(0x1 << 17)\n")
    fprintf(fout, "        orr     r2,  r2, #(0x1 << 16)\n")
    fprintf(fout, "        bic     r2,  r2, #(0x1 << 15)\n")
    fprintf(fout, "        mcr     p15, 0,  r2, c1, c0, 1\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * mpu initialization and address map setup\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        adr     r0,  mpu_cfgtbl2\n")
    fprintf(fout, "        bl      _ddr_cortexr_mpu_init\n")
    fprintf(fout, "\n")
    fprintf(fout, "        @* Enable Branch prediction\n")
    fprintf(fout, "        mrc     p15, 0,  r2, c1, c0, 1\n")
    fprintf(fout, "        bic     r2,  r2, #(0x1 << 17)\n")
    fprintf(fout, "        bic     r2,  r2, #(0x1 << 16)\n")
    fprintf(fout, "        bic     r2,  r2, #(0x1 << 15)\n")
    fprintf(fout, "        mcr     p15, 0,  r2, c1, c0, 1\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * Set low vector\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        mrc     p15, 0,  r0,  c1,  c0,  0\n")
    fprintf(fout, "        bic     r0,  r0, #(0x1 << 13)\n")
    fprintf(fout, "        mcr     p15, 0,  r0,  c1,  c0,  0\n")
    fprintf(fout, "        isb\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * Initialize stack pointer\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "        mov     r0,  #FIQ_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "        ldr     sp,  =_fiq_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        mov     r0,  #UND_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "        ldr     sp,  =_und_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        mov     r0,  #ABT_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "        ldr     sp,  =_abt_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        mov     r0,  #SVC_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "        ldr     sp,  =_svc_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        mov     r0,  #IRQ_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "        ldr     sp,  =_irq_stack\n")
    fprintf(fout, "\n")
    fprintf(fout, "        mov     r0,  #SYS_MOD|I_BIT|F_BIT\n")
    fprintf(fout, "        msr     cpsr_c, r0\n")
    fprintf(fout, "/* clear sbss */\n")
    fprintf(fout, "        mov     r0,  #0\n")
    fprintf(fout, "        ldr     r1,  =_bss\n")
    fprintf(fout, "        ldr     r2,  =_ebss\n")
    fprintf(fout, "1:\n")
    fprintf(fout, "        cmp     r1, r2\n")
    fprintf(fout, "        bge     2f\n")
    fprintf(fout, "        str     r0,  [r1],  #4\n")
    fprintf(fout, "        b       1b\n")
    fprintf(fout, "\n")
    fprintf(fout, "        /*------------------------------------------------------\n")
    fprintf(fout, "         * Jump to main\n")
    fprintf(fout, "         *----------------------------------------------------*/\n")
    fprintf(fout, "2:\n")
    fprintf(fout, "        ldr     r12,  =main\n")
    fprintf(fout, "        mov     lr, pc\n")
    fprintf(fout, "        bx      r12\n")

    fprintf(fout, "\n")
    fprintf(fout, "_err_loop:\n")
    fprintf(fout, "        b     _err_loop\n")

    fprintf(fout, "\n")
    fprintf(fout, "\n")
    fprintf(fout, "/*****************************************************************************/\n")
    fprintf(fout, "#include \"DDR_CORTEXR_MPU.sh\"\n")
    fprintf(fout, "/******************************************************************************\n")
    fprintf(fout, "        Target dependent MPU configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "        Memory region attributes\n")
    fprintf(fout, "\n")
    fprintf(fout, "            ATR_STRG -----------------------------------------+\n")
    fprintf(fout, "            ATR_SDEV -----------------------------------------+\n")
    fprintf(fout, "            ATR_WTNW -----------------------------------------+\n")
    fprintf(fout, "            ATR_WBNW -----------------------------------------+\n")
    fprintf(fout, "            ATR_NONC -----------------------------------------+-- [ATR_SHRD} -- [ATR_NEXC}\n")
    fprintf(fout, "            ATR_WBAW -----------------------------------------+\n")
    fprintf(fout, "            ATR_NDEV -----------------------------------------+\n")
    fprintf(fout, "            ATR_SELA --+-- ATR_INONC --+---+-- ATR_ONONC --+--+\n")
    fprintf(fout, "                       +-- ATR_IWBAW --+   +-- ATR_OWBAW --+\n")
    fprintf(fout, "                       +-- ATR_IWTNW --+   +-- ATR_OWTNW --+\n")
    fprintf(fout, "                       +-- ATR_IWBNW --+   +-- ATR_OWBNW --+\n")
    fprintf(fout, " *****************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* Default memory map */\n")
    fprintf(fout, "mpu_cfgtbl1:\n")
    fprintf(fout, "/*      .long   Region size,    PADDR,      AP,     ATR*/\n")
    fprintf(fout, "        .long   REGION_4G,      0x00000000, AP_RW,  ATR_WBNW\n")
    fprintf(fout, "        .long   REGION_1M,      0xA0000000, AP_RW,  ATR_STRG | ATR_NEXC\n")
    fprintf(fout, "        .long   0x00000000,     0x00000000, 0,      0                   @ termination.\n")
    fprintf(fout, "\n")
    fprintf(fout, "/* Actual memory map example\n")
    fprintf(fout, "    ATCM 0x00000000 is adopted default memory.\n")
    fprintf(fout, "    BTCM 0x00080000 is adopted default memory.\n")
    fprintf(fout, " */\n")
    fprintf(fout, "mpu_cfgtbl2:\n")
    fprintf(fout, "/*       .long    Region size,    PADDR,      AP,     ATR */\n")
    fprintf(fout, "        .long    REGION_512K,    0x00000000, AP_RW,  ATR_NONC @ ATCM\n")
    fprintf(fout, "        .long    REGION_32K,     0x00800000, AP_RW,  ATR_NONC @ BTCM\n")
    fprintf(fout, "        .long    REGION_512K,    0x04000000, AP_RW,  ATR_NONC @ Instruction RAM\n")
    fprintf(fout, "        .long    REGION_128M,    0x08000000, AP_RW,  ATR_NONC @ Buffer RAM\n")
    fprintf(fout, "        .long    REGION_64M,     0x10000000, AP_RW,  ATR_NONC @ SPI Flash\n")
    fprintf(fout, "        .long    REGION_512K,    0x20000000, AP_RW,  ATR_NONC @ Data RAM\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .long    REGION_512K,    0x22000000, AP_RW,  ATR_WBNW @ Data RAM (mirror)\n")
    fprintf(fout, "        .long    REGION_512K,    0x24000000, AP_RW,  ATR_WBNW @ Instruction RAM (mirror)\n")
    fprintf(fout, "        .long    REGION_64M,     0x30000000, AP_RO,  ATR_WBNW @ SPI Flash (mirror)\n")
    fprintf(fout, "        .long    REGION_128M,    0x40000000, AP_RO,  ATR_WBNW @ NOR Flash1,2 (mirror)\n")
    fprintf(fout, "        .long    REGION_128M,    0x48000000, AP_RW,  ATR_WBNW @ SDRAM 1,2 (mirror)\n")
    --fprintf(fout, "      .long    REGION_128M,    0x50000000, AP_RW,  ATR_SDEV | ATR_NEXC  @ CS4,CS5 (mirror)\n")
    fprintf(fout, "\n")
    --fprintf(fout, "      .long    REGION_128M,    0x60000000, AP_RW,  ATR_NONC @ CS0, CS1\n")
    --fprintf(fout, "      .long    REGION_128M,    0x68000000, AP_RW,  ATR_NONC @ CS2, CS3\n")
    --fprintf(fout, "      .long    REGION_128M,    0x70000000, AP_RW,  ATR_SDEV | ATR_NEXC @ CS4, CS5\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .long    REGION_2G,      0x80000000, AP_RW,  ATR_SDEV | ATR_NEXC @ Peripheral, Debug, Boot ..\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .long    0x00000000,     0x00000000, 0,      0                   @ termination\n")

    fprintf(fout, "\n")
    fprintf(fout, "\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
