--[[
  @file     vect.S.lua
  @brief    xN^e[u(in low vector)
  
  @author   yokota
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2015/04/23    1.00        xN^ʒu̓[xN^K{
                            xN^.intvecɔzuȂB
  -------------------------------------------------------
--]]
require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

-- main
function main()
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, " * vector table(in low vector)\n")
    fprintf(fout, " *\n")
    fprintf(fout, " *  File name : vect.S\n")
    fprintf(fout, " *\n")
    fprintf(fout, " ***************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .section .fvectors, \"ax\"\n")
    fprintf(fout, "        .code 32\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .globl  _vector_table\n")
    fprintf(fout, "        .type   _vector_table, %%function\n")
    fprintf(fout, "\n")
    fprintf(fout, "        .extern Reset_Handler\n")
    fprintf(fout, "        .extern _kernel_undhdr\n")
    fprintf(fout, "        .extern _kernel_svchdr\n")
    fprintf(fout, "        .extern _kernel_inthdr\n")
    fprintf(fout, "\n")
    fprintf(fout, "_vector_table:\n")
    fprintf(fout, "        ldr     pc, _ResetHandler   @ 0x0000_0000 : Reset exception\n")
    fprintf(fout, "        ldr     pc, _UndHandler     @ 0x0000_0004 : Undefined instructions exception\n")
    fprintf(fout, "        ldr     pc, _SwiHandler     @ 0x0000_0008 : Software interrupts exceptions\n")
    fprintf(fout, "        ldr     pc, _PreHandler     @ 0x0000_000c : Prefetch abort exception\n")
    fprintf(fout, "        ldr     pc, _AbtHandler     @ 0x0000_0010 : Data abort exception\n")
    fprintf(fout, "        nop                         @ 0x0000_0014 : Reserved\n")
    fprintf(fout, "        ldr     pc, _IrqHandler     @ 0x0000_0018 : IRQ exception\n")
    fprintf(fout, "        ldr     pc, _FiqHandler     @ 0x0000_001c : FIQ exception\n")
    fprintf(fout, "\n")
    fprintf(fout, "_ResetHandler:   .long     Reset_Handler\n")
    fprintf(fout, "_UndHandler:     .long     _kernel_undhdr\n")
    fprintf(fout, "_SwiHandler:     .long     _kernel_svchdr\n")
    fprintf(fout, "_PreHandler:     .long     PreHandler\n")
    fprintf(fout, "_AbtHandler:     .long     AbtHandler\n")
    fprintf(fout, "                 .long     0\n")
    fprintf(fout, "_IrqHandler:     .long     _kernel_inthdr\n")
    fprintf(fout, "_FiqHandler:     .long     FiqHandler\n")
    fprintf(fout, "\n")

    fprintf(fout, "        .text\n")
    fprintf(fout, "        .align 2\n")

    fprintf(fout, "        \n")
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, "        Fiq Handler\n")
    fprintf(fout, " ***************************************************************************/\n")
    fprintf(fout, "FiqHandler:\n")
    fprintf(fout, "        b       FiqHandler\n")

    fprintf(fout, "        \n")
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, "        Prefetch Handler\n")
    fprintf(fout, " ***************************************************************************/\n")
    fprintf(fout, "PreHandler:\n")
    fprintf(fout, "        b       PreHandler\n")

    fprintf(fout, "        \n")
    fprintf(fout, "/****************************************************************************\n")
    fprintf(fout, "        Abort Handler\n")
    fprintf(fout, " ***************************************************************************/\n")
    fprintf(fout, "AbtHandler:\n")
    fprintf(fout, "        b       AbtHandler\n")
    fprintf(fout, "\n")
    fprintf(fout, "\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
