require("uC3")
require("uC3Std")

-- uC3 module alias
fprintf = uC3.fprintf

-- main
function main()
    local cpuclksel = MCFGGetParamInteger("CFG_RZT1_CLK_CPUCKSEL", 0)
    local ckio = MCFGGetParamInteger("CFG_RZT1_CLK_CKIO", 0)

    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Initialization of the hardware-dependent\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "#include \"kernel_cfg.h\"\n")
    fprintf(fout, "#include \"kernel_id.h\"\n")
    fprintf(fout, "#include \"hw_dep.h\"\n")
    fprintf(fout, "\n")
    
    -- Extern
    if MCFGGetParamInteger("CFG_TIM_USE", 0) == 1 then
        fprintf(fout, "extern void %s(UINT tick);\n", MCFGGetParamString("CFG_TIM_INIT", 0))
    end
    
    -- IO|[g̏
    -- [_[fobK}NŐݒ肵e㏑Ȃ悤
    -- sPʂŏ
    fprintf(fout, "\n")
    fprintf(fout, "/***********************************************\n")
    fprintf(fout, "  Initialize port setting\n")
    fprintf(fout, " ***********************************************/\n")
    fprintf(fout, "void init_port(void)\n")
    fprintf(fout, "{\n")
    fprintf(fout, "    volatile UB dummy;\n")
    fprintf(fout, "\n")
    fprintf(fout, "    /* Enables writing to the PmnPFS register */\n")
    fprintf(fout, "    MPC.PWPR.BYTE   = 0x00;\n")
    fprintf(fout, "    dummy           = MPC.PWPR.BYTE;\n")
    fprintf(fout, "    MPC.PWPR.BYTE   = 0x40;\n")
    fprintf(fout, "    dummy           = MPC.PWPR.BYTE;\n")

    port_base = {
        "PORT0", "PORT1", "PORT2", "PORT3", "PORT4", -- PORT0 ~ PORT4
        "PORT5", "PORT6", "PORT7", "PORT8", "PORT9", -- PORT5 ~ PORT9
        "PORTA", "PORTB", "PORTC", "PORTD", "PORTE", -- PORTA ~ PORTE
        "PORTF", "PORTG", "PORTH", "",      "PORTJ", -- PORTF ~ PORTJ
        "PORTK", "PORTL", "PORTM", "PORTN", "",      -- PORTK ~ PORTO
        "PORTP", "",      "PORTR", "PORTS", "PORTT", -- PORTP ~ PORTT
        "PORTU" -- PORTU
    }
    pfs_base = {
        "P0%dPFS", "P1%dPFS", "P2%dPFS", "P3%dPFS", "P4%dPFS", -- P0nPFS ~ P4nPFS
        "P5%dPFS", "P5%dPFS", "P7%dPFS", "P8%dPFS", "P9%dPFS", -- P5nPFS ~ P9nPFS
        "PA%dPFS", "PB%dPFS", "PC%dPFS", "PD%dPFS", "PE%dPFS", -- PAnPFS ~ PEnPFS
        "PF%dPFS", "PG%dPFS", "PH%dPFS", "",        "PJ%dPFS", -- PFnPFS ~ PJnPFS
        "PK%dPFS", "PL%dPFS", "PM%dPFS", "PN%dPFS", "",        -- PKnPFS ~ POnPFS
        "PP%dPFS", "",        "PR%dPFS", "PS%dPFS", "PT%dPFS", -- PPnPFS ~ PTnPFS
        "PU%dPFS" -- PUnPFS
    }

    fprintf(fout, "\n")
    local port_cnt = MCFGGetParamInteger("CFG_RZT1_PORT_COUNT", 0)
    -- 8bitF0`30PORT0 ~ PORTU
    -- 8bitF0`7 Pinԍ
    for i = 0, port_cnt-1 do
        -- |[g݂邩ۂmF
        exist = 0
        for j = 0, 7 do
            index = bit.lshift(i, 8) + j
            exist = bit.bor(MCFGGetParamInteger("CFG_RZT1_PORT_PIN_EXIST", index), exist)
        end
        if exist ~= 0 and port_base[i+1] ~= "" then
            -- ZbglƈقȂꍇ
            -- Zbg (PDR=0->PMR=0->)PCR->DSCR->(PSEL->PMR)->PODR->PDR
            -- ͎Ӌ@\[qƂĎgpꍇKv
            fprintf(fout, "    /* %s setting */\n", port_base[i+1])

            index = bit.lshift(i, 8) + 0
            pdr = MCFGGetParamInteger("CFG_RZT1_PORT_PDR", index)
            pcr = MCFGGetParamInteger("CFG_RZT1_PORT_PCR", index)
            podr = MCFGGetParamInteger("CFG_RZT1_PORT_PODR", index)
            pmr = MCFGGetParamInteger("CFG_RZT1_PORT_PMR", index)

            -- Ӌ@\[q̏ꍇ͐PDR,PMR0ŃZbg
            -- |[g3PMRWX^̃Zbg̒l0x18(b4=1, b3=1)
            for j = 0, 7 do
                pmr_n = bit.band(bit.rshift(pmr, j), 0x1) -- PMR
                if i == 3 and (j == 3 or j == 4) then
                    if pmr_n ~= 1 then
                        fprintf(fout, "    %s.PDR.BIT.B%d = 0;\n", port_base[i+1], j)
                        fprintf(fout, "    %s.PMR.BIT.B%d = 0;\n", port_base[i+1], j)
                    end
                else 
                    if pmr_n ~= 0 then
                        fprintf(fout, "    %s.PDR.BIT.B%d = 0;\n", port_base[i+1], j)
                        fprintf(fout, "    %s.PMR.BIT.B%d = 0;\n", port_base[i+1], j)
                    end
                end
            end
            
            -- PCR
            -- P30APC0 ` PC7 [qɂ́A{@\͂Ȃ
            if i ~= 12 and pcr ~= 0 then
                for j = 0, 7 do
                    pcr_n = bit.band(bit.rshift(pcr, j*2), 0x3)
                    if pcr_n ~= 0 then
                        fprintf(fout, "    %s.PCR.BIT.B%d = %d;\n", port_base[i+1], j, pcr_n)
                    end
                end
            end

            -- PSEL, PMR
            for j = 0, 7 do
                pfs_index = bit.lshift(i, 8) + j
                pfs = MCFGGetParamInteger("CFG_RZT1_PORT_PIN_PFS", pfs_index)
                -- P33PFS, P34PFS̏l0x27CȊO 0x00
                pfsname = string.format(pfs_base[i+1], j)
                if i == 3 and (j == 3 or j == 4) then
                    if pfs ~= 0x27 then
                        fprintf(fout, "    MPC.%s.BYTE = 0x%02X;\n", pfsname, pfs)
                    end
                else 
                    if pfs ~= 0 then
                        fprintf(fout, "    MPC.%s.BYTE = 0x%02X;\n", pfsname, pfs)
                    end
                end
            end
            -- |[g3PMRWX^̃Zbg̒l0x18
            for j = 0, 7 do
                pmr_n = bit.band(bit.rshift(pmr, j), 0x1) -- PMR
                if i == 3 and (j == 3 or j == 4) then
                    if pmr_n ~= 1 then
                        fprintf(fout, "    %s.PMR.BIT.B%d = %d;\n", port_base[i+1], j, pmr_n)
                    end
                else 
                    if pmr_n ~= 0 then
                        fprintf(fout, "    %s.PMR.BIT.B%d = %d;\n", port_base[i+1], j, pmr_n)
                    end
                end
            end

            -- PODR
            for j = 0, 7 do
                podr_n = bit.band(bit.rshift(podr, j), 0x1)
                if podr_n ~= 0 then
                    fprintf(fout, "    %s.PODR.BIT.B%d = %d;\n", port_base[i+1], j, podr_n)
                end
            end
            -- PDR
            for j = 0, 7 do
                pdr_n = bit.band(bit.rshift(pdr, j*2), 0x3)
                if pdr_n ~= 0 then
                    fprintf(fout, "    %s.PDR.BIT.B%d = %d;\n", port_base[i+1], j, pdr_n)
                end
            end

        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "    /* Write disabling of PFS register */\n")
    fprintf(fout, "    MPC.PWPR.BYTE = 0x80;\n")
    fprintf(fout, "    dummy    = MPC.PWPR.BYTE;\n")
    
    -- PORT1.DSCR
    -- SDRAM ڑꍇ́A쓮o͂ɐݒ肵Ă
    index = bit.lshift(1, 8) + 0
    dscr = MCFGGetParamInteger("CFG_RZT1_PORT_DSCR", index)
    if dscr ~= 0 then
        fprintf(fout, "\n")
        fprintf(fout, "    /* PORT1 high drive setting */\n")
        fprintf(fout, "    PORT1.DSCR.WORD = 1;\n")
    end
    
    fprintf(fout, "\n")
    fprintf(fout, "}\n")

    
    -- NbN̏
    fprintf(fout, "\n")
    fprintf(fout, "/***********************************************\n")
    fprintf(fout, "  H/W Initialize entry\n")
    fprintf(fout, " ***********************************************/\n")
    fprintf(fout, "void hw_init(void)\n")
    fprintf(fout, "{\n")
    local cpuclksel_bit = "CPG_CPUCKSEL_150_MHZ"
    local ckio_bit = "CPG_CKIO_50_MHZ"

    if cpuclksel == 0 then
        cpuclksel_bit = "CPG_CPUCKSEL_150_MHZ"
    elseif cpuclksel == 1 then
        cpuclksel_bit = "CPG_CPUCKSEL_300_MHZ"
    elseif cpuclksel == 2 then
        cpuclksel_bit = "CPG_CPUCKSEL_450_MHZ"
    elseif cpuclksel == 3 then
        cpuclksel_bit = "CPG_CPUCKSEL_600_MHZ"
    end

    if ckio == 0 then
        ckio_bit = "CPG_CKIO_75_MHZ"
    elseif ckio == 1 then
        ckio_bit = "CPG_CKIO_50_MHZ"
    elseif ckio == 2 then
        ckio_bit = "CPG_CKIO_37_5_MHZ"
    elseif ckio == 3 then
        ckio_bit = "CPG_CKIO_30_MHZ"
    elseif ckio == 4 then
        ckio_bit = "CPG_CKIO_25_MHZ"
    elseif ckio == 5 then
        ckio_bit = "CPG_CKIO_21_43_MHZ"
    elseif ckio == 6 then
        ckio_bit = "CPG_CKIO_18_75_MHZ"
    end
    
    fprintf(fout, "    _ddr_rzt1_cpg_chg_cpuclk(%s, %s);\n", cpuclksel_bit, ckio_bit)
    -- [UH/W֐R[
    fprintf(fout, "    init_port();\n")

    fprintf(fout, "}\n")

    -- Device driver init entry
    fprintf(fout, "\n")
    fprintf(fout, "/***********************************************\n")
    fprintf(fout, "  Device Driver Initialize entry\n")
    fprintf(fout, " ***********************************************/\n")
    fprintf(fout, "void _ddr_init(void)\n")
    fprintf(fout, "{\n")
    if MCFGGetParamInteger("CFG_TIM_USE", 0) == 1 then
        fprintf(fout, "    %s(CFG_TICK);\n", MCFGGetParamString("CFG_TIM_INIT", 0))
    end
    local uart_cnt = MCFGGetParamInteger("CFG_PERIPH_UART", 0)
    for i = 0, uart_cnt-1 do
        if MCFGGetParamInteger("CFG_PERIPH_UART_USE", i) == 1 then
            fprintf(fout, "    %s(%s, &%s);\n", MCFGGetParamString("CFG_UART_INIT", 0), MCFGGetParamString("CFG_UARTID", i), MCFGGetParamString("CFG_UART_REG", i))
        end
    end
    fprintf(fout, "}\n")
    
    fprintf(fout, "\n/* end */\n")
end

-- sJn 
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
