require("uC3")

-- uC3 module alias
fprintf = uC3.fprintf

function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    Kernel Configurations\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef _KERNEL_CFG_H_\n")
    fprintf(fout, "#define _KERNEL_CFG_H_\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")
    fprintf(fout, "\n")

    -- ID数 = 手動生成オブジェクト数 + 自動生成オブジェクト数
    fprintf(fout, "#define CFG_TSKPRI_MAX        (%d)\n", MCFGGetParamInteger("CFG_TSKPRI_MAX", 0))
    fprintf(fout, "#define CFG_TSKID_MAX         (%d)\n", MCFGGetParamInteger("CFG_TSKID_MAX", 0))
    fprintf(fout, "#define CFG_SEMID_MAX         (%d)\n", MCFGGetParamInteger("CFG_SEMID_MAX", 0))
    fprintf(fout, "#define CFG_FLGID_MAX         (%d)\n", MCFGGetParamInteger("CFG_FLGID_MAX", 0))
    fprintf(fout, "#define CFG_DTQID_MAX         (%d)\n", MCFGGetParamInteger("CFG_DTQID_MAX", 0))
    fprintf(fout, "#define CFG_MBXID_MAX         (%d)\n", MCFGGetParamInteger("CFG_MBXID_MAX", 0))
    fprintf(fout, "#define CFG_MTXID_MAX         (%d)\n", MCFGGetParamInteger("CFG_MTXID_MAX", 0))
    fprintf(fout, "#define CFG_MBFID_MAX         (%d)\n", MCFGGetParamInteger("CFG_MBFID_MAX", 0))
    fprintf(fout, "#define CFG_PORID_MAX         (%d)\n", MCFGGetParamInteger("CFG_PORID_MAX", 0))
    fprintf(fout, "#define CFG_MPFID_MAX         (%d)\n", MCFGGetParamInteger("CFG_MPFID_MAX", 0))
    fprintf(fout, "#define CFG_MPLID_MAX         (%d)\n", MCFGGetParamInteger("CFG_MPLID_MAX", 0))
    fprintf(fout, "#define CFG_ALMID_MAX         (%d)\n", MCFGGetParamInteger("CFG_ALMID_MAX", 0))
    fprintf(fout, "#define CFG_CYCID_MAX         (%d)\n", MCFGGetParamInteger("CFG_CYCID_MAX", 0))
    fprintf(fout, "#define CFG_ISRID_MAX         (%d)\n", MCFGGetParamInteger("CFG_ISRID_MAX", 0))
    fprintf(fout, "#define CFG_DEVID_MAX         (%d)\n", MCFGGetParamInteger("CFG_DEVID_MAX", 0))
    fprintf(fout, "#define CFG_TICK              (%d)\n", MCFGGetParamInteger("CFG_TICK", 0))
    fprintf(fout, "#define CFG_SSB_NUM           (%d)\n", MCFGGetParamInteger("CFG_SSB_NUM", 0))
    fprintf(fout, "#define CFG_SYSMEM_SIZE       (0x%X)\n", MCFGGetParamInteger("CFG_SYSMEM_SIZE", 0))
    -- 下記は手動生成用メモリ(コンフィグレーター登録分はローカルで確保済み)
    fprintf(fout, "#define CFG_STKMEM_SIZE       (0x%X)\n", MCFGGetParamInteger("CFG_STKMEM_SIZE_USR", 0))
    fprintf(fout, "#define CFG_MPLMEM_SIZE       (0x%X)\n", MCFGGetParamInteger("CFG_MPLMEM_SIZE_USR", 0))

    fprintf(fout, "\n")
    fprintf(fout, "#endif /* _KERNEL_CFG_H_ */\n")
    fprintf(fout, "\n/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
