<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="Kernel">
    <p><hr/></p>
    <h3>[カーネルの設定値]</h3>

    <h4>カーネル全般</h4>
    <xsl:apply-templates select="General" />
    <h4>IDの最大値</h4>
    <xsl:apply-templates select="IDMAX" />
    <h4>その他</h4>
    <xsl:apply-templates select="Misc" />
    <h4>オーバランハンドラ</h4>
    <table>
	    <tr>
	    <th>関数名</th>
	    <th>オーバランハンドラ属性</th>
	    </tr>
	    <xsl:apply-templates select="OverrunHandler" />
    </table>

    <h4>タスク</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>関数名</th>
    <th>優先度の初期値</th>
    <th>拡張情報</th>
    <th>タスク属性</th>
    <th>スタックサイズ</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Task" />
    </table>

    <h4>セマフォ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>資源数の初期値</th>
    <th>最大資源数</th>
    <th>セマフォ属性</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Semaphore" />
    </table>

    <h4>イベントフラグ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>ビットパターン初期値(HEX)</th>
    <th>イベントフラグ属性</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="EventFlag" />
    </table>

    <h4>データキュー</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>データの個数</th>
    <th>データキュー属性</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="DataQueue" />
    </table>

    <h4>メールボックス</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>メールボックス属性</th>
    <th>メッセージ優先度の最大値</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Mailbox" />
    </table>

    <h4>ミューテックス</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>ミューテックス属性</th>
    <th>上限優先度</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Mutex" />
    </table>

    <h4>メッセージバッファ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>メッセージバッファ属性</th>
    <th>メッセージの最大サイズ</th>
    <th>メッセージバッファ領域のサイズ</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="MessageBuffer" />
    </table>

    <h4>ランデブ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>ランデブポート属性</th>
    <th>呼出しメッセージの最大サイズ</th>
    <th>返答メッセージの最大サイズ</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Rendezvous" />
    </table>

    <h4>固定長メモリプール</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>固定長メモリプール属性</th>
    <th>メモリブロック数</th>
    <th>メモリブロックのサイズ</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="FixedMemPool" />
    </table>

    <h4>可変長メモリプール</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>可変長メモリプール属性</th>
    <th>メモリサイズ</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="VariableMemPool" />
    </table>

    <h4>周期ハンドラ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>関数名</th>
    <th>拡張情報</th>
    <th>起動周期</th>
    <th>起動位相</th>
    <th>周期ハンドラ属性</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="CyclicHandler" />
    </table>

    <h4>アラームハンドラ</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>関数名</th>
    <th>拡張情報</th>
    <th>アラームハンドラ属性</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="AlarmHandler" />
    </table>

    <h4>割込みハンドラ</h4>
    <table>
    <tr>
    <th>割込み番号</th>
    <th>関数名</th>
    <th>割込みレベル</th>
    <th>割込みハンドラ属性</th>
    </tr>
    <xsl:apply-templates select="IntHandler" />
    </table>

    <h4>割込みサービスルーチン</h4>
    <table>
    <tr>
    <th>IDの定義名</th>
    <th>割込み番号</th>
    <th>関数名</th>
    <th>拡張情報</th>
    <th>割込みレベル</th>
    <th>割込みサービスルーチン属性</th>
    </tr>
    <xsl:apply-templates select="Isr" />
    </table>

    <h4>デバイスドライバ</h4>
    <table>
    <tr>
    <th>デバイスID</th>
    <th>制御情報のパケット</th>
    <th>関数名</th>
    <th>名称</th>
    </tr>
    <xsl:apply-templates select="Dev" />
    </table>

  </xsl:template>

  <xsl:template match="Kernel/General">
    <table>
      <tr>
        <th>タスク優先度の最大値</th>
        <th>チック時間</th>
        <th>システムサービスブロックの個数</th>
        <th>システムメモリサイズ(Byte)</th>
        <th>スタック用メモリサイズ(Byte)</th>
        <th>メモリプール用メモリサイズ(Byte)</th>
        <th>アイドル処理</th>
        <th>スタック初期化処理</th>
        <th>追加ヘッダファイル</th>
      </tr>
      <tr>
        <td><xsl:value-of select="CFG_MAXTSKPRI"/></td>
        <td><xsl:value-of select="CFG_TICK"/></td>
        <td><xsl:value-of select="CFG_SSB_NUM"/></td>
        <td><xsl:value-of select="CFG_SYSMEM_SIZE"/></td>
        <td><xsl:value-of select="CFG_STKMEM_SIZE"/></td>
        <td><xsl:value-of select="CFG_MPLMEM_SIZE"/></td>
        <td><xsl:value-of select="CFG_IDLEFUNC"/></td>
        <td><xsl:value-of select="CFG_INISTK"/></td>
        <td><xsl:value-of select="CFG_ADDHEADER"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="Kernel/IDMAX">
    <table>
      <tr>
        <th>タスクIDの最大値</th>
        <th>セマフォIDの最大値</th>
        <th>イベントフラグIDの最大値</th>
        <th>データキューIDの最大値</th>
        <th>メールボックスIDの最大値</th>
        <th>ミューテックスIDの最大値</th>
        <th>メッセージバッファIDの最大値</th>
        <th>ランデブポートIDの最大値</th>
        <th>固定長メモリプールIDの最大値</th>
        <th>可変長メモリプールIDの最大値</th>
        <th>アラームハンドラIDの最大値</th>
        <th>周期ハンドラIDの最大値</th>
        <th>割込みサービスルーチンIDの最大値</th>
        <th>デバイスドライバIDの最大値</th>
      </tr>
      <tr>
        <td><xsl:value-of select="CFG_TSKID_MAX"/></td>
        <td><xsl:value-of select="CFG_SEMID_MAX"/></td>
        <td><xsl:value-of select="CFG_FLGID_MAX"/></td>
        <td><xsl:value-of select="CFG_DTQID_MAX"/></td>
        <td><xsl:value-of select="CFG_MBXID_MAX"/></td>
        <td><xsl:value-of select="CFG_MTXID_MAX"/></td>
        <td><xsl:value-of select="CFG_MBFID_MAX"/></td>
        <td><xsl:value-of select="CFG_PORID_MAX"/></td>
        <td><xsl:value-of select="CFG_MPFID_MAX"/></td>
        <td><xsl:value-of select="CFG_MPLID_MAX"/></td>
        <td><xsl:value-of select="CFG_ALMID_MAX"/></td>
        <td><xsl:value-of select="CFG_CYCID_MAX"/></td>
        <td><xsl:value-of select="CFG_ISRID_MAX"/></td>
        <td><xsl:value-of select="CFG_DEVID_MAX"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="Kernel/Misc">
    <table>
      <tr>
        <th>オーバランハンドラ</th>
        <th>トレース機能</th>
        <th>エージェント機能</th>
      </tr>
      <tr>
        <td>
          <xsl:choose>
            <xsl:when test="CFG_OVR_ENA=1">有効</xsl:when>
            <xsl:when test="CFG_OVR_ENA='true'">有効</xsl:when>
            <xsl:when test="CFG_OVR_ENA=0">無効</xsl:when>
            <xsl:when test="CFG_OVR_ENA='false'">無効</xsl:when>
          </xsl:choose>
        </td>
        <td><xsl:value-of select="CFG_TRACE"/></td>
        <td><xsl:value-of select="CFG_AGENT"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="OverrunHandler">
    <tr>
      <td><xsl:value-of select="CFG_OVRHDR"/></td>
      <td><xsl:value-of select="CFG_OVRATR"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Task">
    <tr>
      <td><xsl:value-of select="@CFG_TSKID"/></td>
      <td><xsl:value-of select="CFG_TASK"/></td>
      <td><xsl:value-of select="CFG_ITSKPRI"/></td>
      <td><xsl:value-of select="CFG_TSKEXINF"/></td>
      <td><xsl:value-of select="CFG_TSKATR"/></td>
      <td><xsl:value-of select="CFG_STKSZ"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="Semaphore">
    <tr>
      <td><xsl:value-of select="@CFG_SEMID"/></td>
      <td><xsl:value-of select="CFG_ISEMCNT"/></td>
      <td><xsl:value-of select="CFG_MAXSEM"/></td>
      <td><xsl:value-of select="CFG_SEMATR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="EventFlag">
    <tr>
      <td><xsl:value-of select="@CFG_FLGID"/></td>
      <td><xsl:value-of select="CFG_IFLGPTN"/></td>
      <td><xsl:value-of select="CFG_FLGATR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="DataQueue">
    <tr>
      <td><xsl:value-of select="@CFG_DTQID"/></td>
      <td><xsl:value-of select="CFG_DTQCNT"/></td>
      <td><xsl:value-of select="CFG_DTQATR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Mailbox">
    <tr>
      <td><xsl:value-of select="@CFG_MBXID"/></td>
      <td><xsl:value-of select="CFG_MBXATR"/></td>
      <td><xsl:value-of select="CFG_MAXMPRI"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Mutex">
    <tr>
      <td><xsl:value-of select="@CFG_MTXID"/></td>
      <td><xsl:value-of select="CFG_MTXATR"/></td>
      <td><xsl:value-of select="CFG_CEILPRI"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="MessageBuffer">
    <tr>
      <td><xsl:value-of select="@CFG_MBFID"/></td>
      <td><xsl:value-of select="CFG_MBFATR"/></td>
      <td><xsl:value-of select="CFG_MAXMSZ"/></td>
      <td><xsl:value-of select="CFG_MBFSZ"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Rendezvous">
    <tr>
      <td><xsl:value-of select="@CFG_PORID"/></td>
      <td><xsl:value-of select="CFG_PORATR"/></td>
      <td><xsl:value-of select="CFG_MAXCMSZ"/></td>
      <td><xsl:value-of select="CFG_MAXRMSZ"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="FixedMemPool">
    <tr>
      <td><xsl:value-of select="@CFG_MPFID"/></td>
      <td><xsl:value-of select="CFG_MPFATR"/></td>
      <td><xsl:value-of select="CFG_BLKCNT"/></td>
      <xsl:choose>
        <xsl:when test="CFG_MPFDIRECT=1">
          <td><xsl:value-of select="CFG_BLKSZ"/></td>
        </xsl:when>
        <xsl:when test="CFG_MPFDIRECT='true'">
          <td><xsl:value-of select="CFG_BLKSZ"/></td>
        </xsl:when>
        <xsl:when test="CFG_MPFDIRECT=0">
          <td><xsl:value-of select="CFG_MPFEXP"/></td>
        </xsl:when>
        <xsl:when test="CFG_MPFDIRECT='false'">
          <td><xsl:value-of select="CFG_MPFEXP"/></td>
        </xsl:when>
      </xsl:choose>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="VariableMemPool">
    <tr>
      <td><xsl:value-of select="@CFG_MPLID"/></td>
      <td><xsl:value-of select="CFG_MPLATR"/></td>
      <td><xsl:value-of select="CFG_MPLSZ"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="CyclicHandler">
    <tr>
      <td><xsl:value-of select="@CFG_CYCID"/></td>
      <td><xsl:value-of select="CFG_CYCHDR"/></td>
      <td><xsl:value-of select="CFG_CYCEXINF"/></td>
      <td><xsl:value-of select="CFG_CYCTIM"/></td>
      <td><xsl:value-of select="CFG_CYCPHS"/></td>
      <td><xsl:value-of select="CFG_CYCATR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="AlarmHandler">
    <tr>
      <td><xsl:value-of select="@CFG_ALMID"/></td>
      <td><xsl:value-of select="CFG_ALMHDR"/></td>
      <td><xsl:value-of select="CFG_ALMEXINF"/></td>
      <td><xsl:value-of select="CFG_ALMATR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="IntHandler">
    <tr>
      <td><xsl:value-of select="CFG_INHNO"/></td>
      <td><xsl:value-of select="CFG_INTHDR"/></td>
      <td><xsl:value-of select="CFG_INHIMASK"/></td>
      <td><xsl:value-of select="CFG_INHATR"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Isr">
    <tr>
      <td><xsl:value-of select="@CFG_ISRID"/></td>
      <td><xsl:value-of select="CFG_ISRINTNO"/></td>
      <td><xsl:value-of select="CFG_ISR"/></td>
      <td><xsl:value-of select="CFG_ISREXINF"/></td>
      <td><xsl:value-of select="CFG_ISRIMASK"/></td>
      <td><xsl:value-of select="CFG_ISRATR"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="Dev">
    <tr>
      <td><xsl:value-of select="@CFG_DEVID"/></td>
      <td><xsl:value-of select="CFG_CTRBLK"/></td>
      <td><xsl:value-of select="CFG_DEVHDR"/></td>
      <td><xsl:value-of select="@objname"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
