--[[
  @file     ftp_client_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.01
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/06/13    1.00        
  2015/05/13    1.01        FTPSΉ
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    FTP Client Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __FTP_CLIENT_CFG_H__\n")
    fprintf(fout, "#define __FTP_CLIENT_CFG_H__\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_FFSYS_USE", 0) == 1 then
        fprintf(fout, "/* File system */\n")
        if MCFGGetParamInteger("CFG_UNET3_FFSYS_SEL", 0) == 0 then
            fprintf(fout, "#include \"%s\"\n",  MCFGGetParamString("CFG_UNET3_FFSYS_OTHER_INC", 0))
        else
            fprintf(fout, "#include \"ffsys.h\"\n")
        end
        if MCFGGetParamInteger("CFG_UNET3_FTPC_SSL", 0) == 1 then
            fprintf(fout, "\n")
            fprintf(fout, "/* Enable FTPS */\n")
            fprintf(fout, "#define FTPC_SSL_SUP\n")
        end
    end
    
    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __FTP_CLIENT_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



