--[[
  @file     http_server_cfg.h.lua
  @brief    
  
  @author   s-makino
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2015/06/02    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    
    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    HTTP Server Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef HTTP_SERVER_CFG_H\n")
    fprintf(fout, "#define HTTP_SERVER_CFG_H\n")

    fprintf(fout, "\n")
    if MCFGGetParamInteger("CFG_UNET3_HTTPD_KPA_USE", 0) == 1 then
        fprintf(fout, "#define ENA_KEEP_ALIVE        /* Enable HTTP Keep-Alive */\n")
    end
    if MCFGGetParamInteger("CFG_UNET3_HTTPD_KPA_USE", 0) == 1 then
        fprintf(fout, "#define HTTP_KPA_MAX    %d    /* Keep-Alive max value */\n", 
          MCFGGetParamInteger("CFG_UNET3_HTTPD_KPA_MAX", 0))
    end
    if MCFGGetParamInteger("CFG_UNET3_HTTPD_EXT_USE", 0) == 1 then
        fprintf(fout, "#define ENA_USER_EXT          /* Enable User Extension */\n")
    end

    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* HTTP_SERVER_CFG_H */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



