--[[
  @file     snmp_cfg.h.lua
  @brief    
  
  @author   i-cho
  @version  1.00
  -------------------------------------------------------
  DATE          VERSION     DESCRIPTION
  2014/07/04    1.00        
  -------------------------------------------------------
--]]
require("uC3")

-- alias
fprintf = uC3.fprintf


--[[
    main function
--]]
function main()
    -- Variables
    local nowtim = os.date("%Y-%m-%d %H:%M:%S")
    local netif_count = MCFGGetParamInteger("CFG_UNET3_IF_COUNT", 0)

    fprintf(fout, "/***************************************************************************\n")
    fprintf(fout, "    MICRO C CUBE / COMPACT/STANDARD, NETWORK Application\n")
    fprintf(fout, "    SNMP Configuration\n")
    fprintf(fout, "\n")
    fprintf(fout, "    Generated at %s\n", nowtim)
    fprintf(fout, " **************************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#ifndef __SNMP_CFG_H__\n")
    fprintf(fout, "#define __SNMP_CFG_H__\n")

    fprintf(fout, "\n")
    fprintf(fout, "#include \"net_cfg.h\"\n")
    fprintf(fout, "#include \"net_id.h\"\n")

    fprintf(fout, "\n")
    fprintf(fout, "\n")
    fprintf(fout, "#define CFG_SNMP_NET_DEV_CNT    %d     /* Number of network devices (1..2) */\n", netif_count)
    fprintf(fout, "#define CFG_SNMP_NET_DEV_NUM    %s     /* Network devices number (1..2) */\n", MCFGGetParamString("CFG_UNET3_SNMP_NET_DEV_NUM", 0))
    
    fprintf(fout, "\n")
    fprintf(fout, "/* Number of network sockets */\n")
    fprintf(fout, "#define CFG_SNMP_MAX_SOC_CNT    (CFG_NET_SOC_MAX)\n")
    fprintf(fout, "#define CFG_SNMP_MAX_TCP_CNT    (CFG_NET_TCP_MAX)\n")
    fprintf(fout, "#define CFG_SNMP_MAX_ARP_CNT    (CFG_NET_ARP_MAX)\n")

    fprintf(fout, "\n")
    fprintf(fout, "#define CFG_SNMP_MAX_TRP_CNT    %d          /* Number of traps at any time (0 or 1..32) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MAX_TRP_CNT", 0))
    fprintf(fout, "#define CFG_SNMP_MSG_VAR_CNT    %d          /* Maximum number of variable bindings (4 or greater) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MSG_VAR_CNT", 0))
    fprintf(fout, "#define CFG_SNMP_MIB_NOD_CNT    %d         /* Number of nodes in the MIB tree */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB_NOD_CNT", 0))
    fprintf(fout, "#define CFG_SNMP_MAX_MIB_DEP    %d          /* Maximum depth of the MIB tree */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MAX_MIB_DEP", 0))
    fprintf(fout, "#define CFG_SNMP_MIB_DAT_LEN    (%d + 1)    /* Maximum size of the MIB data (with null terminator) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB_DAT_LEN", 0))

    fprintf(fout, "\n")
    fprintf(fout, "/* Generic trap enabled */\n")
    fprintf(fout, "#define CFG_SNMP_GEN_TRP_ENA    0x%04X\n", MCFGGetParamInteger("CFG_UNET3_SNMP_GEN_TRP_ENA", 0))

    fprintf(fout, "\n")
    fprintf(fout, "/* MIB2 group selector */\n")
    fprintf(fout, "#define CFG_SNMP_MIB2_IF_ENA      %d    /* Interfaces    (1.3.6.1.2.1.2) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_IF_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_AT_ENA      %d    /* Address trans (1.3.6.1.2.1.3) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_AT_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_IP_ENA      %d    /* IP            (1.3.6.1.2.1.4) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_IP_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_ICMP_ENA    %d    /* ICMP          (1.3.6.1.2.1.5) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_ICMP_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_TCP_ENA     %d    /* TCP           (1.3.6.1.2.1.6) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_TCP_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_UDP_ENA     %d    /* UDP           (1.3.6.1.2.1.7) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_UDP_ENA", 0))
    fprintf(fout, "#define CFG_SNMP_MIB2_SNMP_ENA    %d    /* SNMP          (1.3.6.1.2.1.11) */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_MIB2_SNMP_ENA", 0))

    fprintf(fout, "\n")
    fprintf(fout, "/* Maximum size of an SNMP message  (4-byte aligned) */\n")
    fprintf(fout, "#define CFG_SNMP_RCV_MSG_LEN    %d                    /* Message can receive */\n", MCFGGetParamInteger("CFG_UNET3_SNMP_RCV_MSG_LEN", 0))
    fprintf(fout, "#define CFG_SNMP_SND_MSG_LEN    CFG_SNMP_RCV_MSG_LEN    /* Message can send*/\n")
    
    fprintf(fout, "\n")
    fprintf(fout, "/* Do not change the following items */\n")
    fprintf(fout, "#define CFG_SNMP_FNC_FLG        SNMP_AGT    /* SNMP agent */\n")
    fprintf(fout, "#define CFG_SNMP_UDP_SND_TMO    2000        /* UDP socket send timeout */\n")
    fprintf(fout, "#define CFG_SNMP_UDP_RCV_TMO    2000        /* UDP socket receive timeout */\n")
    fprintf(fout, "#define CFG_SNMP_SEM_TMO        800         /* Semaphore timeput period for internal */\n")
    
    -- End
    fprintf(fout, "\n")
    fprintf(fout, "#endif /* __SNMP_CFG_H__ */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end



