require("uC3")

-- uC3 module alias
fprintf = uC3.fprintf


--[[
ÓI\PbgID̕ϐo͂
--]]
function main()
    fprintf(fout, "/***********************************************************************\n")
    fprintf(fout, "    TCP/IP Protocol Stack Object ID definitions\n")
    fprintf(fout, " ***********************************************************************/\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"net_id.h\"\n")
    fprintf(fout, "\n")
    fprintf(fout, "#include \"kernel.h\"\n")

    -- Variables
    version     = MCFGGetParamInteger("CFG_UNET3_VERSION", 0)
    httpd_use   = MCFGGetParamInteger("CFG_UNET3_HTTPD_USE", 0)
    httpc_use   = MCFGGetParamInteger("CFG_UNET3_HTTPC_USE", 0)
    -- ver3ȍ~̕ϐ
    ftpd_use    = 0
    tftpd_use   = 0
    dhcpd_use   = 0
    sntpd_use   = 0
    telnetd_use = 0
    if version >= 300 then
        ftpd_use    = MCFGGetParamInteger("CFG_UNET3_FTPD_USE", 0)
        tftpd_use   = MCFGGetParamInteger("CFG_UNET3_TFTPD_USE", 0)
        dhcpd_use   = MCFGGetParamInteger("CFG_UNET3_DHCPD_USE", 0)
        sntpd_use   = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE", 0)
        telnetd_use = MCFGGetParamInteger("CFG_UNET3_TELNETD_USE", 0)
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Socket ID's */\n")
    static_soc_cnt = MCFGGetParamInteger("CFG_UNET3_SOC_COUNT", 0)
    for cnt = 0, static_soc_cnt-1 do
        fprintf(fout, "SID %s;\n", MCFGGetParamString("CFG_UNET3_SOCID", cnt))
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Task ID's */\n")
    if httpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_HTTPD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_HTTPD_TSKID", 0), i+1)
        end
    end
    if ftpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_FTPD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_FTPD_TSKID", 0), i+1)
        end
    end
    if tftpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TFTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TFTPD_TSKID", 0), i+1)
        end
    end
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_TSKID", 0), i+1)
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_RCV_TSKID", 0), i+1)
        end
    end
    if sntpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 0), i+1)
            local mc_use = MCFGGetParamInteger("CFG_UNET3_SNTPD_USE_MULTICAST", 0)
            if mc_use == 1 then
                fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_TSKID", 1), i+1)
            end
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 0), i+1)
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_TSKID", 1), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Semaphore ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Event Flag ID's */\n")
    if sntpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_SNTPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_SNTPD_FLGID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_FLGID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* DataQueue ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Mailbox ID's */\n")
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MBXID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_MBXID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Mutex ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Message buffer ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Rendezvous ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Fixed-Sized Memory Pool ID's */\n")
    if httpc_use == 1 then
        fprintf(fout, "ID %s;\n", MCFGGetParamString("CFG_UNET3_HTTPC_MPFID", 0))
    end
    if dhcpd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_DHCPD_COUNT", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_DHCPD_SVR_MPFID", 0), i+1)
        end
    end
    if telnetd_use == 1 then
        local session_cnt = MCFGGetParamInteger("CFG_UNET3_TELNETD_SESSION", 0)
        for i = 0, (session_cnt-1) do 
            fprintf(fout, "ID %s%d;\n", MCFGGetParamString("CFG_UNET3_TELNETD_MPFID", 0), i+1)
        end
    end

    fprintf(fout, "\n")
    fprintf(fout, "/* Variable-Sized Memory Pool ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Cyclic Handler ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Alarm Handler ID's */\n")

    fprintf(fout, "\n")
    fprintf(fout, "/* Interrupt Service Routine ID's */\n")
    if sntpd_use == 1 then
        fprintf(fout, "ID %s;\n", MCFGGetParamString("CFG_UNET3_SNTPD_ISRID", 0))
    end

    fprintf(fout, "\n/* end */\n")
end

-- Start
do
    fout = io.open(MCFGGetOutputFile(), "w")
    main()
    fout:close()
end
