--[[
/**
 * @file       uC3.lua
 * @author     Copyright (c) 2012 eForce Co.,Ltd. All Rights Reserved.
 * @brief      Basic lua module for uC3/Configurator
 *             This module should deploy at same directory as configurator.exe. ex) \lua\uC3.lua
 * @revisions
 *             - rev 1.00 (2012-07-11)
 *               First public release.
 *             - rev 1.01 (2013-03-5)
 *               Added isdigit(), tohex() function.
 */
--]]
module("uC3", package.seeall)

-- Print formatted data to a file stream.
function fprintf(fp, ...)
    fp:write(string.format(...))
end

-- Find character in string from the end
function string.rfind(s, pattern)
    local i = 0
    local p = nil
    repeat
        i = i - 1
        p, q = string.find(s, pattern, i, true)
    until (p ~= nil or i == -string.len(s))
    return p
end

-- Is string numeric?
function isdigit(s)
    local i = 0
    for i = 1, string.len(s) do
        if string.find(string.sub(s, i, i), "%d") == nil then
            return false
        end
    end
    return true
end

-- 16i𐔒lɕϊB
function tohex(s)
  return tonumber(s, 16)
end

-- checking if a table contains a value
function table.contains(table, element)
  for _, value in pairs(table) do
    if value == element then
      return true
    end
  end
  return false
end

-- Get parent from full path.
function path_parent(fullpath)
    local parent = ""
    local pos = string.rfind(fullpath, '\\')
    if pos ~= nil then
        parent = string.sub(fullpath, 1, pos-1)
    end
    return parent
end

-- Get basename from full path.
function path_basename(fullpath)
    local parent = ""
    local len = string.len(fullpath)
    local pos = string.rfind(fullpath, '\\')
    if pos ~= nil then
        parent = string.sub(fullpath, pos+1, len)
    end
    return parent
end

-- t@CRs[֐
-- source, destination: t@C\
function file_copy(source, destination)
  local fhs, fhd, buf, estr, ecode
  fhs, estr, ecode = io.open(source, "r")
  if fhs == nil then
    return nil, estr, ecode
  end
  fhd, estr, ecode = io.open(destination, "w")
  if fhd == nil then
    fhs:close()
    return nil, estr, ecode
  end
  repeat
    buf = fhs:read(1000)
    if buf then
      fhd:write(buf)
    end
  until buf == nil
  fhd:close()
  fhs:close()
  return true
end
